'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption6.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->Grid
'*
'************************************************************************
'*
' #1 cOption6                     ' Initial Routine
' #1 tOptionsGrid_save            ' Check all Grid Options and change them
' #1 tOptionsGrid_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsGridRestore_settings ' Restore default settings
' #1 tOptionsGrid_functionality 'wrn:2|err:0 '  ' Test correct functionality of changes
'*
'\***********************************************************************

Global curr_Snap as double, flag_Snap as double, curr_Ax as double, flag_Ax as double, curr_Sync as double, flag_Sync as double
Global Xres as double, Yres as double, Xsub as double, Ysub as double
Global curr_Xres as string, flag_Xres as string, curr_Yres as string, flag_Yres as string, curr_Xsub as string, flag_Xsub as string
Global curr_Ysub as string, flag_Ysub as string

'*** Global variables for the functionality test
Global chg_Snap as boolean
Global x_pos as double, y_pos as double, x1_pos as String, y1_pos as String

sub cOption6

        printLog Chr(13) + "--------- cOption6 ---------"
        printlog "Tools|Options|Spreadsheet|Grid"

        call tOptionsGrid_save
        call tOptionsGrid_reload
        call tOptionsGrid_functionality
        call tOptionsGridRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsGrid_save
'/// This test invokes the "Tools|Options|Spreadsheet|Grid" dialog
'/// First the default settings are checked ///'
'/// For each item of unexpected value a warning is throw ///'
'/// Now each control is modified and the dialog is saved & closed using <OK> ///'
'/// After a restart of the office the changed settings are checked for persistence
'/// Further the correct functionality of the grid options is tested ///'
'/// Finally the original settings are restored. ///'

        ' Initialize the variables
        curr_Snap = 0
        flag_Snap = 0
        curr_Ax = 0
        flag_Ax = 0
        curr_Sync = 0
        flag_Sync = 0
        curr_Xsub = 1
        curr_Ysub = 1
        Xres = 4
        Yres = 4
        Xsub = 4
        Ysub = 4
        chg_Snap = false

    select case iSystemSprache
        case 01 : curr_Xres = "0.50" & chr(34) : curr_Yres = "0.50" & chr(34) : flag_Xres = "0.58" & chr(34)
        case 49 : curr_Xres = "1,00cm" : curr_Yres = "1,00cm" : flag_Xres = "1,40cm"
    end select

    select case iSprache
        case 01 : curr_Xsub = "1" : curr_Ysub = "1" : flag_Xsub = "5" : flag_Ysub = "5"
        case 49 : curr_Xsub = "1" : curr_Ysub = "1" : flag_Xsub = "5" : flag_Ysub = "5"
        case 81 : curr_Xsub = "1" : curr_Ysub = "1" : flag_Xsub = "5" : flag_Ysub = "5"
        case else : curr_Xsub = "1" : curr_Ysub = "1" : flag_Xsub = "5" : flag_Ysub = "5"
    end select

    Call hNewDocument

        ' Modify all parameters in this tabpage
        ToolsOptions
        hToolsOptions("SPREADSHEET", "GRID")
        sleep 5

    ' Snap to grid
    if FangrasterBenutzen.ischecked then
        warnlog "<Snap to grid> is enabled by default"
        curr_Snap = 1
        FangrasterBenutzen.uncheck
        flag_Snap = FangrasterBenutzen.GetState
    else
        curr_Snap = 0
        FangrasterBenutzen.check
        flag_Snap = FangrasterBenutzen.GetState
    end if

        ' Visible grid
        if RasterSichtbar.ischecked then
                warnlog "<Visible grid> is enabled by default"
                curr_Ax = 1
                RasterSichtbar.uncheck
                flag_Ax = RasterSichtbar.GetState
        else
                curr_Ax = 0
                RasterSichtbar.check
                flag_Ax = RasterSichtbar.GetState
        end if

    ' Synchronize axes
    if AchsenSynchronisieren.ischecked then
        curr_Sync = 1
        AchsenSynchronisieren.uncheck
        flag_Sync = AchsenSynchronisieren.GetState
    else
        warnlog "<Synchronize axes> is not enabled by default"
        curr_Sync = 0
        AchsenSynchronisieren.check
        flag_Sync = AchsenSynchronisieren.GetState
    end if

    ' Xaxis resolution
    if RasterAufloesungXAchse.GetText <> curr_Xres then
        warnlog "The value of <X-axis resolution> is not as expected. It is " & RasterAufloesungXAchse.GetText & " instead of " & curr_Xres
        printlog " Changing it to default"
        RasterAufloesungXAchse.SetText curr_Xres
    end if
    RasterAufloesungXAchse.More Xres
    ' flag_Xres = RasterAufloesungXAchse.GetText

    ' Yaxis resolution
    if RasterAufloesungYAchse.GetText <> curr_Yres then
        warnlog "The value of <Y-axis resolution> is not as expected. It is " & RasterAufloesungYAchse.GetText & " instead of " & curr_Yres
        printlog " Changing it ot default"
        RasterAufloesungYAchse.SetText curr_Yres
    end if
    RasterAufloesungYAchse.More Yres
    ' flag_Yres = RasterAufloesungYAchse.GetText

    ' Xsubdivision
    if iSprache <> 81 then
        if RasterUnterteilungXAchse.GetText <> curr_Xsub then
                warnlog "The value of <X-axis subdivision> is not as expected. It is " & RasterUnterteilungXAchse.GetText & " instead of " & curr_Xsub
                printlog " Changing it ot default"
                RasterUnterteilungXAchse.SetText curr_Xres
        end if
    else
        if left(RasterUnterteilungXAchse.GetText, 1) <> left(curr_Xsub, 1) then
                warnlog "The value of <X-axis subdivision> is not as expected. It is " & left(RasterUnterteilungXAchse.GetText, 1) & " instead of " & left(curr_Xsub, 1)
                printlog " Changing it ot default"
                RasterUnterteilungXAchse.SetText curr_Xres
        end if
    end if
    RasterUnterteilungXAchse.More Xsub
    ' flag_Xsub = RasterUnterteilungXAchse.GetText

    ' Ysubdivision
    if iSprache <> 81 then
        if RasterUnterteilungYAchse.GetText <> curr_Ysub then
                warnlog "The value of <Y-axis subdivision> is not as expected. It is " & RasterUnterteilungYAchse.GetText & " instead of " & curr_Ysub
                printlog " Changing it ot default"
                RasterUnterteilungYAchse.SetText curr_Yres
        end if
    else
        if left(RasterUnterteilungYAchse.GetText, 1) <> left(curr_Ysub, 1) then
                warnlog "The value of <Y-axis subdivision> is not as expected. It is " & left(RasterUnterteilungYAchse.GetText, 1) & " instead of " & left(curr_Ysub, 1)
                printlog " Changing it ot default"
                RasterUnterteilungYAchse.SetText curr_Yres
        end if
    end if
    RasterUnterteilungYAchse.More Ysub
    ' flag_Ysub = RasterUnterteilungYAchse.GetText

    ' the contents of the Metric fields Subdivision X and Y depend on the state of the checkbox
    ' Synchronize axes.
    if AchsenSynchronisieren.ischecked then
        if iSystemSprache = 49 then
                flag_Yres = "1,80cm"
        else
                flag_Yres = "1.80cm" & chr(34)
        end if
        if iSprache = 49 then
                flag_Xsub = "8"
        else
                flag_Xsub = "8"
        end if
    else
        if iSystemSprache = 49 then
                flag_Yres = "1,40cm"
        else
                flag_Yres = "0.58" & chr(34)
        end if
        if iSprache = 49 then
                flag_Xsub = "5"
        else
                flag_Xsub = "5"
        end if
    end if

    ' Close the Options dialog with the changed settings

        Kontext "OptionenDlg"
        OptionenDlg.OK
    sleep 5
        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGrid_reload
'/// Documentation is summarized in tOptionsGrid_save

        'Restart the complete office
    sleep 5
    'Restart the complete office
    ExitRestartTheOffice

    Call hNewDocument

    ' Check the made settings
    ToolsOptions
    hToolsOptions("SPREADSHEET", "GRID")
    sleep 5

    ' Snap to grid
    if FangrasterBenutzen.GetState = flag_Snap then
        printlog "OK, the new value for <Snap to grid> is persistent"
        chg_Snap = true
        else
                warnlog "The new value for <Snap to grid> wasn't stored"
        end if

        ' Visible grid
        if RasterSichtbar.GetState = flag_Ax then
           printlog "OK, the new value for <Visible grid> is persistent"
        else
           warnlog "The new value for <Visible grid> wasn't stored"
        end if

    ' Synchronize axes
    if AchsenSynchronisieren.GetState = flag_Sync then
           printlog "OK, the new value for <Synchronize axes> is persistent"
        else
           warnlog "The new value for <Synchronize axes> wasn't stored"
        end if

    ' Xaxis resolution
    if RasterAufloesungXAchse.GetText = flag_Xres then
           printlog "OK, the new value for <X-axis resolution> is persistent"
        else
           warnlog "The new value for <X-axis resolution> wasn't stored"
        end if

    ' Yaxis resolution
    if RasterAufloesungYAchse.GetText = flag_Yres then
           printlog "OK, the new value for <Y-axis resolution> is persistent"
        else
           warnlog "The new value for <Y-axis resolution> wasn't stored"
        end if

    ' Xsubdivision
    printlog "RasterUnterteilungXAchse.GetText " & RasterUnterteilungXAchse.GetText
    printlog "flag_Xsub " & flag_Xsub
    if iSprache <> 81 then
        if RasterUnterteilungXAchse.GetText = flag_Xsub then
           printlog "OK, the new value for <X-axis subdivision> is persistent"
        else
           warnlog "The new value for <X-axis subdivision> wasn't stored"
        end if
    else
        if left(RasterUnterteilungXAchse.GetText, 1) = left(flag_Xsub, 1) then
           printlog "OK, the new value for <X-axis subdivision> is persistent"
        else
           warnlog "The new value for <X-axis subdivision> wasn't stored"
        end if
    end if

    ' Ysubdivision
    printlog "RasterUnterteilungYAchse.GetText " & RasterUnterteilungYAchse.GetText
    printlog "flag_Ysub " & flag_Ysub
    if iSprache <> 81 then
        if RasterUnterteilungYAchse.GetText = flag_Ysub then
           printlog "OK, the new value for <Y-axis subdivision> is persistent"
        else
           warnlog "The new value for <Y-axis subdivision> wasn't stored"
        end if
    else
        if left(RasterUnterteilungYAchse.GetText, 1) = left(flag_Ysub, 1) then
           printlog "OK, the new value for <Y-axis subdivision> is persistent"
        else
           warnlog "The new value for <Y-axis subdivision> wasn't stored"
        end if
    end if


    ' Close the Options dialog with the changed settings

        Kontext "OptionenDlg"
        OptionenDlg.Cancel

        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGridRestore_settings
'/// Documentation is summarized in tOptionsGrid_save

        call hNewDocument

        ' restore the default settings
        ToolsOptions
        hToolsOptions("SPREADSHEET", "GRID")
        sleep 5

    ' Snap to grid
    if curr_Snap = 1 then
        FangrasterBenutzen.check
    else
        FangrasterBenutzen.uncheck
    end if

        ' Visible grid
        if curr_Ax = 1 then
                RasterSichtbar.check
        else
                RasterSichtbar.uncheck
        end if

    ' Synchronize axes
    if curr_Sync = 1 then
        AchsenSynchronisieren.check
    else
        AchsenSynchronisieren.uncheck
    end if

    ' Xaxis resolution
    RasterAufloesungXAchse.SetText curr_Xres

    ' Yaxis resolution
    RasterAufloesungYAchse.SetText curr_Yres

    ' Xsubdivision
    RasterUnterteilungXAchse.SetText curr_Xsub

    ' Ysubdivision
    RasterUnterteilungYAchse.SetText curr_Ysub

    Kontext "OptionenDlg"
        OptionenDlg.OK

        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGrid_functionality
'/// Documentation is summarized in tOptionsGrid_save

        Call hNewDocument

        ' Check the changed settings on their functionality

        ' Snap to grid
        if chg_Snap then
                if flag_Snap = 1 then
                        ' in order to make the option more easier to test, it is set the Resolution
                        ' and Subdivision to current
                        ToolsOptions
                        hToolsOptions("SPREADSHEET", "GRID")
                        sleep 5
                RasterAufloesungXAchse.SetText curr_Xres
                ' Yaxis resolution
                RasterAufloesungYAchse.SetText curr_Yres
                ' Xsubdivision
                RasterUnterteilungXAchse.SetText curr_Xsub
                ' Ysubdivision
                RasterUnterteilungYAchse.SetText curr_Ysub
                Kontext "OptionenDlg"
                sleep 3
                        OptionenDlg.OK
                        sleep 3
                        call inscontrol(false)
                        printlog "first call of inscontrol"
                        printlog "x_pos: " & x_pos
                        printlog "y_pos: " & y_pos
                        call inscontrol(true)
                        printlog "second call of inscontrol"
                        printlog "x_pos: " & x1_pos
                        printlog "y_pos: " & y1_pos
                        call checkpos()
        else
                ' If the option "Snap to Grid" isn't activated change it
                printlog "If <Snap to Grid> isn't activated change it"
                        ToolsOptions
                        hToolsOptions("SPREADSHEET", "GRID")
                        sleep 5
                FangrasterBenutzen.check
                ' in order to make the option more easier to test, it is set the Resolution
                        ' and Subdivision to current
                        RasterAufloesungXAchse.SetText curr_Xres
                ' Yaxis resolution
                RasterAufloesungYAchse.SetText curr_Yres
                ' Xsubdivision
                RasterUnterteilungXAchse.SetText curr_Xsub
                ' Ysubdivision
                RasterUnterteilungYAchse.SetText curr_Ysub
                Kontext "OptionenDlg"
                        OptionenDlg.OK
                        call inscontrol(false)
                        printlog "third call of inscontrol"
                        printlog "x_pos: " & x_pos
                        printlog "y_pos: " & y_pos
                        call inscontrol(true)
                        printlog "fourth call of inscontrol"
                        printlog "x_pos: " & x1_pos
                        printlog "y_pos: " & y1_pos
                        call checkpos()
                        ' After checking this feature the original state must be recovered
                        ToolsOptions
                        hToolsOptions("SPREADSHEET", "GRID")
                        sleep 5
                FangrasterBenutzen.uncheck
                Kontext "OptionenDlg"
                sleep 3
                        OptionenDlg.OK
                        sleep 3
                end if
        else
                warnlog "Because initial settings were not as expected the functionality check is skipped"
        end if

        call hCloseDocument

endcase

