'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_losa_ms_ole.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Conversion of Microsoft OLE objects in dependency of settings in Tools::Options::Load/Save::MS_Office
'*
'************************************************************************
'*
' #1 ms_ole        ' Initial routine
' #1 tMS_OLE_Conversion
' #1 subSelectOLEinNavigator
'*
'\************************************************************************

sub ms_ole

  printLog Chr(13) + "---------  MS_OLE   ----------"

  Call tMS_OLE_Conversion ( "excelOLE.doc" )
  Call tMS_OLE_Conversion ( "excelOLE.ppt" )
  Call tMS_OLE_Conversion ( "mathOLE.doc" )
  Call tMS_OLE_Conversion ( "mathOLE.ppt" )
  Call tMS_OLE_Conversion ( "mathOLE.xls" )
  Call tMS_OLE_Conversion ( "pptOLE.doc" )
  Call tMS_OLE_Conversion ( "pptOLE.xls" )
  Call tMS_OLE_Conversion ( "wordOLE.ppt" )
  Call tMS_OLE_Conversion ( "wordOLE.xls" )
  'Reset settings in Tools::Options::Load/Save::MS Office
  call subSetConversionMicrosoftOLE ( "RESET" )

End Sub

'*******************************************************************

testcase tMS_OLE_Conversion ( sCurrentTestDocument as STRING )
'///<u><b>Test the conversion of MS OLE objects while loading MS documents</b><br>///
'///(All OLE types in each application except OLE and application of same type)</u>///

dim iIndex as INTEGER

dim sInputFile as STRING
    sInputFile = convertpath ( gTesttoolpath & "calc/loadsave/input/ms_ole/" & sCurrentTestDocument )
    
dim sSplitCurrentTestDocument() as STRING
    sSplitCurrentTestDocument() = split ( sCurrentTestDocument , ".")
dim sCurrentFileName as STRING
    sCurrentFileName = sSplitCurrentTestDocument ( 0 )
dim sCurrentExtension as STRING
    sCurrentExtension = sSplitCurrentTestDocument ( 1 )
    
dim sExtNames( 5 ) AS String
dim sCurrentExtensionOasis as STRING
    select case sCurrentExtension
           case ( "doc" ) : sExtNames() = hGetFilternameExtension ( "writer8" )
           case ( "xls" ) : sExtNames() = hGetFilternameExtension ( "calc8" )
           case ( "ppt" ) : sExtNames() = hGetFilternameExtension ( "impress8" )
    end select
    sCurrentExtensionOasis = " (." & sExtNames(0) & ")"
dim sCurrentFilter as STRING
    select case sCurrentExtension
           case ( "doc" ) : sCurrentFilter = hGetUIFiltername ( "writer8"  ) & sCurrentExtensionOasis
           case ( "xls" ) : sCurrentFilter = hGetUIFiltername (  "calc8"   ) & sCurrentExtensionOasis
           case ( "ppt" ) : sCurrentFilter = hGetUIFiltername ( "impress8" ) & sCurrentExtensionOasis
    end select
dim sOutputFile as STRING
    sOutputFile = (gOfficePath & ConvertPath("user\work\") & sCurrentFileName & "." & sExtNames(0) )
    
dim bEditObjectWasSuccessful as BOOLEAN
dim bUnexpectedMsgBox as BOOLEAN
'///<ul>
    '///<li>Test MS OLE conversion for current document in eight different cases</li>///
    '///<li>Case 1-4: Test correct conversion after loading with the different settings in Tools::Options::Load/Save::MS Office</li>///
    '///<li>Case 5-8: Test correct conversion after saving in OpenDocument format and reloading</li>///
    for iIndex = 1 to 8
        bEditObjectWasSuccessful = FALSE
        bUnexpectedMsgBox = FALSE
        select case iIndex
               case 1 , 5 : call subSetConversionMicrosoftOLE ( "RESET" )
               case 2 , 6 : call subSetConversionMicrosoftOLE ( "SAVE"  )
               case 3 , 7 : call subSetConversionMicrosoftOLE ( "LOAD"  )
               case 4 , 8 : call subSetConversionMicrosoftOLE (  "ALL"  )
        end select
        sleep(2)
        '///<li>Open test document</li>///
        call hDateiOeffnen ( sInputFile )
        printlog "Loading: " & sInputFile
        sleep(2)
        '///<li>Case 5-8: Save document in OpenDocument format</li>///
        select case iIndex
               case > 4
                    if hSpeichernUnterMitFilterKill ( sOutputFile , sCurrentFilter ) then
                        printlog "OK, successfully saved the test document!"
                    else
                        warnlog "Saving the testdocument failed!"
                    endif
                    sleep(2)
                    '///<li>Case 5-8: Close document</li>///
                    call hCloseDocument
                    '///<li>Case 5-8: Reload document</li>///
                    sleep(2)
                    call hDateiOeffnen ( sOutputFile )
                    sleep(2)
        end select
        '///<li>Select OLE using navigator</li>///
        select case sCurrentExtension
               case ( "doc" )
                    Kontext "NavigatorWriter"
                    if NOT NavigatorWriter.exists (3) then
                        EditNavigator
                    end if
                    subSelectOLEinNavigator ( Auswahlliste , 5 )
               case ( "xls" )
                    Kontext "NavigatorCalc"
                    if NOT NavigatorCalc.exists (3) then
                        EditNavigator
                    end if
                    subSelectOLEinNavigator ( Liste , 6 )
               case ( "ppt" )
                    Kontext "NavigatorDraw"
                    if NOT NavigatorDraw.exists (3) then
                        EditNavigator
                    end if
                    subSelectOLEinNavigator ( Liste , 1 )
        end select
        sleep(2)
        '///<li>Try Edit::Object::SaveCopyAs on OLE (fails for MS OLEs, should work for OpenDocument OLEs</li>///
        try 
            EditObjectSaveCopyAs
            sleep(2)
            kontext
            if active.exists(2) then
                bUnexpectedMsgBox = TRUE
                active.OK
            endif
            if bUnexpectedMsgBox then
                if gPlatGroup = "w95" then
                    if ( left ( sCurrentFileName ,4 ) = "math" ) OR ( left ( sCurrentFileName ,4 ) = "word" ) then
                        qaErrorLog "We know this unwanted MsgBox after sending 'EditObjectSaveCopyAs' to a MS-Equation or Word OLE on Windows with MS-Office installed."
                        qaErrorLog "pj@openoffice.org: IMHO it's not worth writing an issue because this cannot happen to users."
                    else
                        warnlog "WINDOWS: This MsgBox is not expected for the current application! -> Check this out!"
                    endif
                else
                    warnlog "UNIX: MsgBox isn't expected at all! -> Check this out!"
                endif
            endif
            Kontext "SpeichernDlg"
            SpeichernDlg.Cancel
            if bUnexpectedMsgBox then
                warnlog "The unexpected MsgBox seems to be different to the one we already know because we reached the SaveAS dialog -> Check this out!"
            endif
            bEditObjectWasSuccessful = TRUE
            kontext
            if active.exists(2) then
                active.OK
                qaErrorLog "#i48155 - Unwanted MsgBox"
            endif
        catch
            if bEditObjectWasSuccessful = TRUE then
            ' bEditObjectWasSuccessful can only be TRUE at this point if TRY block passed 'SaveAs' dialog
                warnlog "'Catch' was reached unexpectedly -> Is there any disturbing MsgBox or dialog?"
            endif
        endcatch
        '///<li>Analyze if success/failture of OLE activation is the expected result</li>///
        select case iIndex
               case 1 , 2 , 5 , 6
                    if bEditObjectWasSuccessful then
                        warnlog "It shouldn't be possible to use 'Edit::Object::SaveCopyAs' on this OLE -> Check this out!"
                    else
                        printlog "OK, saving OLE failed!"
                    endif
               case 3 , 4 , 7 , 8
                    if bEditObjectWasSuccessful then
                        printlog "OK, saving OLE works!"
                    else
                        warnlog "OOPS, 'Edit::Object::SaveCopyAs' failed for this OLE -> Check this out!"
                    endif
        end select
        '///<li>Close document</li>///
        call hCloseDocument
    next iIndex
    '///</ul>
endcase
'
'-----------------------------------------------------------------------------
'
sub subSelectOLEinNavigator ( oNavigatorList as OBJECT , iItemID as Integer )
'///<u><b>Select OLE object in Document</b></u>///

    dim iIndex as INTEGER
'///<ul><li>Go to Top in Navigator</li>///
    oNavigatorList.TypeKeys "<HOME>"
    '///<li>Travel top to bottom through all categories above OLE objects</li>///
    for iIndex = 1 to 6
    '///<li>Make sure all elements in category are hidden, apply '-' key</li>///
         oNavigatorList.TypeKeys "-<DOWN>"
    next iIndex
    '///<li>Select desired category</li>///
    oNavigatorList.select ( iItemID )
    '///<li>Unfold elements of selected category</li>///
    oNavigatorList.TypeKeys "+"
    '///<li>Select desired position within category</li>///
    oNavigatorList.select ( iItemID + 1 )
    '///<li>Hit 'RETURN' key to select element in document</li></ul>///
    oNavigatorList.TypeKeys "<RETURN>"
end sub

