'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_102b_.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:06 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description  :  Detailed test of the functions in the Edit menu - Part 2
'*
'*************************************************************************
'*
' #1 c_102b_ ' Initial routine
' #1 tEditDeleteTables
' #1 tEditDeleteCells
' #1 tEditLinkGraphic
' #1 tEditLinkOLE
' #1 tCalc2DrawCopy
' #1 tEditMoveCopyTable
' #1 tEditDeleteManualRowBreak
' #1 tEditDeleteManualColumnBreak
' #1 tEditModifyMergeDocuments
'*
'\************************************************************************


sub c_102b_

Printlog "--------- C_102b_ ---------"

   call tEditDeleteTables
   call tEditDeleteCells
   call tEditLinkGraphic
   call tEditLinkOLE
   call tCalc2DrawCopy
   call tEditMoveCopyTable
   call tEditDeleteManualRowBreak
   call tEditDeleteManualColumnBreak
   call tEditModifyMergeDocuments

end sub
'
'-----------------------------------------------------------
'
testcase tEditLinkGraphic
'/// This test insert a graphic as link in a calcdocument and remove it again ///
'/// It is checked, if the graphic was inserted and if it is possible to remove the link. ///

    call  hNewDocument

    InsertGraphicsFromFile
    Kontext "GrafikEinfuegenDLG"
    Dateiname.settext ConvertPath(gtesttoolpath & "global\input\graf_inp\baer.tif")
    Link.Check
    Oeffnen.Click
    sleep (2)
    EditLinksCalc
    Kontext "VerknuepfungenBearbeiten"
    If NOT VerknuepfungenBearbeiten.exists (5) then
      Warnlog "Dialog EditLink doesn't appear"
    end if
    Aendern.click
    Kontext "GrafikEinfuegenDLG"
    If GrafikEinfuegenDLG.exists then
      'Printlog "Ok"
    else
      Warnlog "Modify doesn't call the dialog InsertGraphic"
    end if
    GrafikEinfuegenDLG.Cancel
    Kontext "VerknuepfungenBearbeiten"
    loesen.Click
    Kontext
    If NOT Active.exists then
        Warnlog "No request by deleting the link"
    end if
    Active.Yes
    Kontext "VerknuepfungenBearbeiten"
    VerknuepfungenBearbeiten.Cancel

    try
      EditLinksCalc
      Warnlog "The link still exists"
    catch
      Printlog "OK, the link has been deleted"
    endcatch

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditLinkOLE
'/// A text is inserted in a mathdocument. This document is linked to a calcdocument. ///
'/// + Then a new text is inserted into the mathdocument and the calcdocument is closed without ///
'/// + saving. Now it is checked by compare the textwidth if the link was updated ///
'/// + (this would be an ERROR) or if the content of the link has the old content ("Example"). ///

    dim check_width
    dim sFile as String
    dim SFileMath as String
    dim ExtMath as string
    ExtMath = ".sxm"
    sFileMath = gOfficePath & "user/work/verkn.sxm"
    sFile = gOfficePath & "user/work/verkn" & Ext

    gApplication = "Math"

    dim MathFilter as string
    MathFilter = gMathFilter
    call  hNewDocument
    setClipboard ("Example")
    Kontext
    EditPaste
    sleep 2
    call hSpeichernUnterMitFilterKill (sFileMath, MathFilter)
    printlog "saved as " & sFileMath
    call hCloseDocument
    gApplication = "CALC"
    printlog "call new calcdocument"
    call  hNewDocument
    InsertObjectOLEObject
    kontext "OLEObjektEinfuegen"
    AusDateierstellen.check
    OleDatei.settext  ConvertPath (sFileMath)
    OLEObjektEinfuegen.Ok
    Kontext
    call hSpeichernUnterMitFilterKill convertpath (sFile), FileFormat
    printlog "saved calcdocument as " & convertpath (sFile)
    sleep 3
    call hCloseDocument
    sleep 3
    printlog "reload the mathdocument " & sFileMath
    call hDateioeffnen sFileMath
    setClipboard ("NextExample")
    Kontext
    EditPaste
    sleep 2
    FileSave
    call hCloseDocument
    sleep 3
    printlog "reload the calcdocument " & sFile
    call hDateioeffnen sFile
    Kontext
    call gMouseClick (1,1)
    FormatPositionAndSize
    Kontext
    active.setpage TabPositionAndSize
    Kontext "TabPositionAndSize"
    check_width = Width.gettext
    printlog "width: " &  width
    TabPositionAndSize.Cancel
    Kontext
    call gMouseClick (1,1)
    Obj_Originalgroesse
    sleep 1
    FormatPositionAndSize
    Kontext
    active.setpage TabPositionAndSize
    Kontext "TabPositionAndSize"
    if val(Width.gettext) > val(check_width) then
      Warnlog "Link has been updated"
    else
      Printlog "Link hasn't been updated"
    end if
    TabPositionAndSize.Cancel

    call hCloseDocument

    try
      app.kill ConvertPath (sFileMath)
      app.kill ConvertPath (sFile)
    catch
      Warnlog "Error while deleting two files"
    endcatch

endcase
'
'-----------------------------------------------------------
'
testcase tCalc2DrawCopy
'/// This testcase test the copy and paste functionality with objects ///
'/// For this purpose a chart is created, modified and copied. ///
'/// Then a new drawdocument is called and the chart is pasted. ///

   call  hNewDocument

   printlog " tCalc2DrawCopy"
   Kontext "DocumentCalc"
   Printlog "Create number line"
'/// Create a number line for a chart
   DocumentCalc.Typekeys ("<RIGHT><RIGHT><RIGHT><DOWN><DOWN>")
   DocumentCalc.Typekeys ("12<return>")
   DocumentCalc.Typekeys ("25<return>")
   DocumentCalc.Typekeys ("42<return>")
   DocumentCalc.Typekeys ("15<return>")
   DocumentCalc.Typekeys ("14<return>")
   DocumentCalc.Typekeys ("10<return>")
   DocumentCalc.TypeKeys ("<UP>")
   DocumentCalc.Typekeys ("<MOD1 SHIFT UP>")
   Kontext
'/// Create a chart, which based on this numbers
   InsertChartCalc
   Kontext "DiagrammEinfuegen"
   If AutoformatDiagrammBeginn.exists (2) then
      Printlog "Create chart"
      Kontext "AutoformatDiagrammBeginn"
      Weiter.Click
      Kontext "AutoformatDiagramm2"
      Weiter.Click
   else
      warnlog "Chart isn't shown"
   end if
   Kontext "AutoformatDiagramm3 "
   Printlog "AutoformatChart2"
   Sleep 2
   'Spalten.Check it doesn't work and i don't know why
   Sleep 2
   Fertigstellen.Click
   Sleep 2
   Kontext "DocumentChart"
   try
       FormatChartType
       Kontext "Diagrammtyp"
       Printlog "Modify charttype"
       Sleep 1
       Typ.Typekeys "<Tab>"
       Typ.TypeKeys "<Left><Left><Down>"
       Sleep 2
      Diagrammtyp.OK
   catch
      warnlog "No dialog"
   endcatch
   Sleep 2
   Kontext
   call gMouseClick (2,2)
   sleep 1
   call gMouseClick (50,20)
'/// Copy the chart
   EditCopy
   Printlog "Copy Chart"
   Sleep (2)
   gApplication = "DRAW"
   Printlog "Changed application to DRAW"
'/// open a new draw document and paste the chart into it
   call hNewDocument
   EditPaste
'/// Check if the chart has been inserted
   Printlog "Chart is inserted"
   Sleep (2)
   call hCloseDocument
   Sleep (2)
   gApplication = "CALC"
   Printlog "Changed application to CALC"
   Kontext
   Sleep 5
   call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditMoveCopyTable
'/// This test check, if the move/copy function works ///

   dim content

   call  hNewDocument
'/// Open a new calc document and insert a '13' into cell 'A1', then select the cell
   DocumentCalc.Typekeys "13<Return><Up>"
   DocumentCalc.Typekeys "<SHIFT DOWN UP>"
'/// Call the menuitem 'InsertNamesDefine' and define a name for this cellrange
   InsertNamesDefine
   Kontext "Namenfestlegen"
   BereichsName.settext "range1"
   content = ZugeordnetZu.gettext
   Namenfestlegen.cancel
'/// Copy this sheet and insert it before sheet_2
   EditCopyMoveSheet
   Kontext "TabelleVerschiebenKopieren"
   EinfuegenVor.select 2
   Kopieren.Check
   TabelleVerschiebenKopieren.OK
'/// Check, if the sheet has been really copied
   sleep (2)
   Kontext
   DocumentCalc.Typekeys "<Down>=" + content + "<Return><Up Up>"
   call cZellenVergleichen (1,0,0)

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManualRowBreak
'/// This test inserted a RowBreak, then it is tested, if the RowBreak ///
'/// has been really inserted. At last the RowBreak is deleted. ///
'/// The same procedure is executed in the next test (ColumnBreak) ///

    call  hNewDocument

    DocumentCalc.Typekeys "1<Return>2<Return><Up>"
    InsertManuelBreakRowBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Printlog "RowBreak is inserted"
    catch
      Warnlog "No RowBreak is inserted"
    endcatch
    Kontext "Previewbar"
    Seitenansicht.Click
    Kontext
    call cgotocell ("A2")
    EditRemoveManualBreakRowBreak
    FilePageView
    Kontext "Previewbar"
    try
      OL_SEITENANSICHT_NaechsteSeiteCalc
      OL_SEITENANSICHT_VorherigeSeiteCalc
      Warnlog "RowBreak hasn't been removed"
    catch
      Printlog "OK, the RowBreak has been removed"
    endcatch
    Seitenansicht.Click

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManualColumnBreak
'/// For description, please have a look after 'tEditDeleteManualRowBreak'

    call  hNewDocument

    DocumentCalc.Typekeys "1<Right>2<Right><Left>"
    InsertManuelBreakColumnBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Printlog "ColumnBreak is inserted"
    catch
      Warnlog "No ColumnBreak has been inserted"
    endcatch
    Kontext "Previewbar"
    Seitenansicht.Click
    Kontext
    call cgotocell ("B1")
    EditRemoveManualBreakColumnBreak
    FilePageView
    Kontext "Previewbar"
    try
        OL_SEITENANSICHT_NaechsteSeiteCalc
        OL_SEITENANSICHT_VorherigeSeiteCalc
        Warnlog "ColumnBreak is still present"
    catch
      Printlog "OK, ColumnBreak has been removed"
    endcatch
    Kontext "Previewbar"
    Seitenansicht.Click
    Kontext

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditModifyMergeDocuments
'/// This test check,if it is possible to merge two documents

   dim file as string
   file = convertpath (gTesttoolPath & "calc/level1/input/c_102/teditmergedocument.sxc")
   call hNewDocument
'/// First open a new calc document, then call menuitem 'EditChangesMergeDocument'
   EditChangesMergeDocument
   Kontext "OeffnenDlg"
   UebergeordneterOrdner.Click
   Standard.Click
'/// Set as mergedocument "gTesttoolPath & "calc/level1/input/c_102/teditmergedocument"
'/// and check if the appropriate dialog appears, then close this dialog.
   Dateiname.setText file
   Oeffnen.click
   sleep 60
   Kontext "Aenderungenanzeigen"
   sleep 3
   Aenderungenanzeigen.close
   sleep 3
   Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteTables
'/// This test check, if the correct sheet is deleted ///
'/// For this purpose a cellrange is created and then the sheet with the range ///
'/// is copied behind the first sheet. Then it is tested if the sheet has ///
'/// really inserted. At last the sheet is deleted. ///

   dim content
   dim cellref

   'cellref = "=$#REF!.$A$1"

   select case isprache
        case 01   : cellref = "=$#REF!.$A$1"
        case 03   : cellref = "=$#REF!.$A$1"
        case 31   : cellref = "=$#VERW!.$A$1"
        case 33   : cellref = "=$#REF !.$A$1"
        case 34   : cellref = "=$#REF!.$A$1"
        case 39   : cellref = "=$#RIF!.$A$1"
        case 45   : cellref = "=$#REF!.$A$1"
        case 46   : cellref = "=$#REF!.$A$1"
        case 48   : cellref = "=$#REF!.$A$1"
        case 49   : cellref = "=$#REF!.$A$1"
        case 55   : cellref = "=$#REF!.$A$1"
        case 81   : cellref = "=$#REF!.$A$1"
        case 82   : cellref = "=$#REF!.$A$1"
        case 86   : cellref = "=$#REF!.$A$1"
        case 88   : cellref = "=$#REF!.$A$1"
        case else : QAErrorlog "The language adjustment is still missing" : goto endsub
   end select

    call  hNewDocument

    Kontext
    DocumentCalc.Typekeys "<SHIFT DOWN UP>"
    InsertNamesDefine
    Kontext "Namenfestlegen"
    BereichsName.settext "range1"
    content = ZugeordnetZu.gettext
    Namenfestlegen.cancel
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    EinfuegenVor.select 2
    Kopieren.Check
    TabelleVerschiebenKopieren.OK
    sleep (2)
    Kontext
    DocumentCalc.Typekeys "1<Return>=" + content + "<Return><Up><Up><Shift Down Up>"
    AlleTabellenAuswaehlen
    EditFillSheet
    Kontext "TabellenFuellen"
    AuswahlAllesEinfuegen.check
    TabellenFuellen.Ok
    WindowNewWindow
    Kontext
    call cZellenVergleichen (1,0,0)

    'workaround to deselect all sheets
    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    nach.check
    Neuerstellen.check
    Anzahl.settext "1"
    Tabellenname.settext "Warbird"
    TabelleEinfuegenCalc.Ok

    fCalcSelectSheet ( 1 )
    EditDeleteSheet
    Kontext
    If Active.exists (10) then
      printlog "OK, warning message before delete cell"
      Active.Yes
    else
      warnlog "No warning message is appeared!"
    end if
    call fCalcSelectSheet ( 1 )
    Kontext
    DocumentCalc.Typekeys "<F2>"
    EditSelectAll
    EditCopy
    DocumentCalc.Typekeys "<Return>"
    if getClipboardtext = cellref then
      Printlog "OK, the inserted sheet has been deleted."
    else
      Warnlog "The sheet hasn't been deleted, or something else is happened!"
      warnlog "getClipboardtext: " & getClipboardtext
    end if

    call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteCells
'/// A short test to check the function delete cells. ///

    call  hNewDocument
'/// Open a new calcdocument and insert in cell 'A3' a '1', then call the manuitem 'EditDeleteCells' ...
    DocumentCalc.TypeKeys "<Down><Down>1<Return><Up>"
    EditDeleteCells
    Kontext "ZellenLoeschen"
    if ZellenLoeschen.exists(10) then
      Printlog "OK,  the dialog 'DeleteCells' appears"
    else
      Warnlog "Dialog not shown"
    end if
    ZellenLoeschen.Ok
'/// ... and confirm this dialog
    sleep 5
    call ZellenMarkieren (1,1)
'/// Check, if the cell 'A3' has been deleted
    DocumentCalc.Typekeys "<Up>"
    call cZellenVergleichen (1,0,0)

    call hCloseDocument

endcase

