'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_upd_MainApp.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: msc $ $Date: 2006/02/09 12:41:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : test the Main Application Window
'*
'************************************************************************
'*
' #1 tMainApp
' #1 tMainMenuBar
' #1 tDatabaseProperties    
' #1 tTableView
' #1 tPreview    
' #1 tTableFilters
' #1 tRegisterDatabaseDialog
'*
'\***********************************************************************************
sub b_upd_MainApp

    printlog "------------------ b_upt_MainApp.inc ---------------------"
    
    call tMainApp
    call tMainMenuBar
    call tDatabaseProperties    
    call tTableView
    call tPreview    
    call tTableFilters
    
    call tRegisterDatabaseDialog
    
end sub
'-------------------------------------------------------------------------
'-------------------------------------------------------------------------
'-------------------------------------------------------------------------
testcase tTableFilters
    
    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))
        
    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
    sleep(1)
    TableFilters
    sleep(1)
    Kontext "TablesFilter"
    
    TablesFilter.Cancel
    sleep 1
    
    call hCloseDocument
    
    
endcase
'-------------------------------------------------------------------------
testcase tTableView
   
    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))
        
    Kontext "Insight"

    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
        
    if not InsightSwapIconView.exists(1) then        
        warnlog "InsightSwapIconView doesn't exists"
        goto endsub
    end if
        
    '/// display Tables View
    printlog "display Tables View"
    ViewTables
    Kontext "ContainerView"
    if not TableTree.exists(1) then        
        warnlog "TableTree doesn't appear"
        goto endsub
    end if
    
    TableTree.TypeKeys("<HOME>")
    TableTree.TypeKeys("<UP>")
    
    sleep(5)
    
    call hCloseDocument
    
endcase
'-------------------------------------------------------------------------
testcase tMainApp
    
    dim iCount as integer ' the numbers of the items in the creation list.
    
    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))

    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
    
    Kontext "Insight"
    if Insight.exists() then
        printlog "Insight appear"
    else
        warnlog "Insight doesn't appear"
        goto endsub
    end if
    
    if InsightSwapView.exists() then
        printlog "InsightSwapView appear"        
    else
        warnlog "InsightSwapView doesn't appear"
        goto endsub
    end if
        
    '/// display Tables View
    printlog "display Tables View"
    ViewTables    
    if InsightTablesView.exists(1) then
        printlog "InsightTablesView appear"        
    else
        warnlog "InsightTablesView doesn't appear"
        goto endsub
    end if
    
    '/// count the items in the CreationList
    printlog "count the items in the CreationList"
    iCount = CreationList.getItemCount() 
    if ( iCount <> 2) then
        warnlog "There are not 2 items in the CreationList. There are " + iCount + " items."
    end if
        
    '/// display Queries View
    printlog "display Queries View"
    ViewQueries    
    if InsightQueriesView.exists(1) then
        printlog "InsightQueriesView appear"        
    else
        warnlog "InsightQueriesView doesn't appear"
        goto endsub
    end if
    
    '/// count the items in the CreationList
    printlog "count the items in the CreationList"
    iCount = CreationList.getItemCount() 
    if ( iCount <> 3) then
        warnlog "There are not 3 items in the CreationList. There are " + iCount + " items."
    end if
    
    '/// display Forms View
    printlog "display Forms View"
	ViewForms
    Kontext "ContainerView"    
    if FormTree.exists(1) then
        printlog "InsightFormsView appear"        
    else
        warnlog "InsightFormsView doesn't appear"
        goto endsub
    end if
    Kontext "Insight"
    '/// count the items in the CreationList
    printlog "count the items in the CreationList"
    iCount = CreationList.getItemCount() 
    if ( iCount <> 2) then
        warnlog "There are not 2 items in the CreationList. There are " + iCount + " items."
    end if
    
    '/// display Reports View
    printlog "display Reports View"
    ViewReports    
    if InsightReportsView.exists(1) then
        printlog "InsightReportsView appear"        
    else
        warnlog "InsightReportsView doesn't appear"
        goto endsub
    end if
    
    '/// count the items in the CreationList
    printlog "count the items in the CreationList"
    iCount = CreationList.getItemCount() 
    if ( iCount <> 1) then
        warnlog "There are not 1 items in the CreationList. There are " + iCount + " items."
    end if
    
    call hCloseDocument
    
endcase
'-------------------------------------------------------------------------
testcase tPreview

    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))

    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)    
    
    ViewTables
    
    sleep(1)
    
    Kontext "ContainerView"        
        TableTree.select 1
    
    Kontext "Insight"
        Insight.UseMenu
        hMenuSelectNr(3)
        hMenuSelectNr(4)
        hMenuSelectNr(3)
        
    sleep(5)
    
    
    Kontext "DatabaseBeamer"
        if ( not DatabaseBeamer.exists(1) ) then
            warnlog "the preview doesn't display the table"
        else
            printlog "preview displayed"
        endif    
        
    Kontext "Insight"
        Insight.UseMenu
        hMenuSelectNr(3)
        hMenuSelectNr(4)
        hMenuSelectNr(1)
    
    sleep(5)    
        
    Kontext "DatabaseBeamer"
        if ( DatabaseBeamer.exists(1) ) then
            warnlog "the preview is still there"
        else
            printlog "preview turn off"
        endif        
        
    sleep(1)    
        
    call fCloseDatabase
    
endcase
'-------------------------------------------------------------------------
testcase tMainMenuBar

    dim iCount as integer ' the numbers of the items in the menu.    
    
    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))
    
    Kontext "Insight"
        Insight.UseMenu        
        '/// check if there are 11 items in the file menu.
        printlog "check if there are 11 items in the file menu."
        '/// + there different count related to the file pick list.                
        printlog "+ there different count related to the file pick list."        
        hMenuSelectNr(1) ' the file menu        
        iCount = getMenuItemCount()        
        if (iCount <> 11 ) then
            warnlog "There should be 11 items in the file menu but there are " + iCount + " items."
        end if
        

        '/// check if there are 12 items in the FILE/NEW menu.
        printlog "check if there are 12 items in the FILE/NEW menu."
        hMenuSelectNr(1) ' FILE/NEW menu        
        iCount = hMenuItemGetCount()        
        if (iCount <> 12) then
            warnlog "There should 12 items in the FILE/NEW menu but there are " + iCount + " items."
        end if        
        call hMenuClose() ' close the FILE menu
        
        '/// check the FILE/AUTOPILOTS
        printlog "check the FILE/AUTOPILOTS"
        Insight.UseMenu        
        hMenuSelectNr(1) ' the file menu
        hMenuSelectNr(4) ' the autopilots menu        
        iCount = hMenuItemGetCount()
        if (gOOO) then   
            if (iCount <> 10) then
                warnlog "There should 10 items in the FILE/AUTOPILOTS menu but there are " + iCount + " items."
            end if
        else
            if (iCount <> 8) then
                warnlog "There should 8 items in the FILE/AUTOPILOTS menu but there are " + iCount + " items."
            end if
        endif
        call hMenuClose()
        
        '/// check if there are 12 items in the edit menu.
        printlog "check if there are 12 items in the edit menu."
        Insight.UseMenu 
        hMenuSelectNr(2)        
        iCount = hMenuItemGetCount()
        if (iCount <> 14) then
            warnlog "There should 14 items in the edit menu but there are " + iCount + " items."
        end if
        call hMenuClose()

        '/// check if there are 6 items in the view menu.
        printlog "check if there are 6 items in the view menu."
        Insight.UseMenu 
        hMenuSelectNr(3)        
        iCount = hMenuItemGetCount()
        if (iCount <> 6) then
            warnlog "There should 6 items in the view menu but there are " + iCount + " items."
        end if
        call hMenuClose()

        '/// check the VIEW/DATABASE OBJECTS
        printlog "check the VIEW/DATABASE OBJECTS"
        Insight.UseMenu
        hMenuSelectNr(3)
        hMenuSelectNr(1)                
        iCount = hMenuItemGetCount()        
        if (iCount <> 4) then
            warnlog "There should 4 items in the VIEW/DATABASE menu but there are " + iCount + " items."
        end if        
        call hMenuClose()

        '/// check the VIEW/SORT OBJECTS
        printlog "check the VIEW/SORT OBJECTS"
        Insight.UseMenu
        hMenuSelectNr(3)
        hMenuSelectNr(5)                
        iCount = hMenuItemGetCount()        
        if (iCount <> 2) then
            warnlog "There should 2 items in the VIEW/SORT menu but there are " + iCount + " items."
        end if        
        call hMenuClose()

        '/// check the VIEW/PREVIEW
        printlog "check the VIEW/PREVIEW"
        Insight.UseMenu
        hMenuSelectNr(3)
        hMenuSelectNr(4 )                
        iCount = hMenuItemGetCount()        
        if (iCount <> 3) then
            warnlog "There should 3 items in the VIEW/PREVIEW menu but there are " + iCount + " items."
        end if        
        call hMenuClose()
        
        '/// check if there are 8 items in the insert menu.
        printlog "check if there are 8 items in the insert menu."
        Insight.UseMenu 
        hMenuSelectNr(4)       
        iCount = hMenuItemGetCount()
        if (iCount <> 8) then
            warnlog "There should 8 items in the insert menu but there are " + iCount + " items."
        end if
        call hMenuClose()

        '/// check if there are 9 items in the tools menu.
        printlog "check if there are 9 items in the tools menu."        
        Insight.UseMenu 
        hMenuSelectNr(5)        
        iCount = hMenuItemGetCount()
        if (iCount <> 9) then
            warnlog "There should 9 items in the tools menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        '/// check if there are 4 items in the TOOLS/MACRO menu.
        printlog "check if there are 4 items in the TOOLS/MACRO menu."        
        Insight.UseMenu 
        hMenuSelectNr(5)
        hMenuSelectNr(5)        
        iCount = hMenuItemGetCount()
        if (iCount <> 4) then
            warnlog "There should 4 items in the TOOLS/MACRO menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        
        '/// check if there are 3 items in the window menu.
        printlog "check if there are 3 items in the window menu."        
        Insight.UseMenu 
        hMenuSelectNr(6)        
        iCount = hMenuItemGetCount()
        if (iCount <> 3) then
            warnlog "There should 3 items in the window menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
        '/// check if there are 5 items in the help menu.
        printlog "check if there are 5 items in the help menu."        
        Insight.UseMenu 
        hMenuSelectNr(7)        
        iCount = hMenuItemGetCount()
        if (iCount <> 5) then
            warnlog "There should 5 items in the help menu but there are " + iCount + " items."
        end if
        call hMenuClose()
        
    call hCloseDocument
        
endcase
'-------------------------------------------------------------------------
testcase tDatabaseProperties 
    
    dim sValue as string
    
    call fDateiOeffnen(gOfficePath + ConvertPath("user\database\biblio.odb"))
    
    Kontext "Insight"        
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    
    Kontext "Insight"    
        Insight.UseMenu    
        hMenuSelectNr(2)
        hMenuSelectNr(14)
        hMenuSelectNr(1)
    sleep(1)
    Kontext "DatabaseProperties"
        call DialogTest(DatabaseProperties)
        ' TabControl.SetPage TabGeneral
    ' 
    ' '/// check the general tabpage
    ' printlog "check the general tabpage"     
    ' Kontext "TabGeneral"
    ' 'TODO: check real names. 
        ' sValue = SourceName.getText()
        ' if ( strComp(sValue,"TT_Biblio") <> 0 ) then
            ' warnlog "The datasource name is not right. it should be 'TT_Biblio' but it is " + sValue
        ' end if
        ' sValue = DataBaseType.getSelText()
        ' if ( strComp(sValue,"dBASE") <> 0 ) then
            ' warnlog "The datasource type is not right. it should be 'dBase' but it is " + sValue
        ' end if
        ' 
        ' Advanced.Click
    ' Kontext "Advanced"
        ' Advanced.Close
        
' tabconnection in this script == tabgeneral in the office ( historic reasons )        
    '/// check the connection tabpage
    printlog "check the connection tabpage"
    Kontext "DatabaseProperties"             
        TabControl.SetPage TabConnection
    
    Kontext "TabConnection"
        if NOT TabConnection.exists(1) then
            warnlog "Tabpage doesn't exists."
        end if
        '/// check if the text in the path is correct
        'printlog "check if the text in the path is correct"
        sValue = dBasePath.getText()
        'if ( strComp(sValue,"sdbc:dbase:$(userurl)/database/biblio") <> 0 ) then
        '    warnlog "the path is not correct. It is " + sValue
        'end if
        '/// click the select path button
        printlog "click the select path button"        
        SelectPath.Click        
    
    Kontext "GeneralFileDialog"
        '/// cancel the open dialog
        printlog "cancel the open dialog"
        GeneralFileDialog.Cancel
    
    Kontext "TabConnection"
        '/// click the test connection button
        printlog "click the test connection button"
        TestConnection.Click
    
    Kontext "Active"
        '/// close the messagesdialog
        printlog "close the messagesdialog"
        Active.OK
    
    Kontext "DatabaseProperties"             
        '/// switch to the additional Settings
        printlog "switch to the additional Settings"
        TabControl.SetPage TabdBase
    
    Kontext "TabdBase"        
        '/// open the index dialog
        printlog "open the index dialog"
        Indexes.Click
    
    Kontext "Indexes"
        '/// close the index dialog with cancel
        Indexes.Cancel
    
    Kontext "DatabaseProperties"
        '/// Cancel the datasource admin dialog
        printlog "Cancel the datasource admin dialog"
        DatabaseProperties.Cancel
        
    call hCloseDocument()
    
endcase
'--------------------------------------------------------------------
testcase tRegisterDatabaseDialog
    
    dim i as integer
    '/// open new document
    printlog "open new document"
    call hNewDocument
    '/// open TOOLS / OPTIONS
    printlog "open TOOLS / OPTIONS"
    ToolsOptions
    '/// open Data Source / DATABASES
    printlog "open Data Source / DATABASES"    
    call hToolsOptions ( "Datasources", "Databases" )
       
    Kontext "TabRegisteredDatabase"
        call DialogTest( TabRegisteredDatabase )    
        if (RegisteredDatabases.getItemCount() = 0 ) then
            warnlog "there are no registered databases. There should be at least a  registered 'Bibliography' database."
            Kontext "OptionenDlg"
                OptionenDlg.Cancel
            call hCloseDocument
            goto endsub
        endif            
        RegisteredDatabases.select 1
        '/// check if the Bibliography is registered
        printlog "check if the Bibliography is registered"
        if RegisteredDatabases.getSeltext() <> "Bibliography" then
            warnlog "the bibliography database is not registered"
        else
            printlog "database bibliography is registered"
        endif
        '/// click in the delete button but don't delete the database
        printlog "click in the delete button but don't delete the database"
        DeleteBtn.Click	
        Kontext "Active"
            Active.no
    '/// click on the new button
    printlog "click on the new button"            
    Kontext "TabRegisteredDatabase"
        NewBtn.Click
    sleep(1)
    '/// cancel the new dialog
    printlog "cancel the new dialog"
    Kontext "CreateDatabaseLink"
        call DialogTest( CreateDatabaseLink )
        CreateDatabaseLink.Cancel

    '/// click on the edit button
    printlog "click on the edit button"            
    Kontext "TabRegisteredDatabase"
        EditBtn.Click
    sleep(1)
    '/// cancel the edit dialog
    Kontext "CreateDatabaseLink"
        call DialogTest( CreateDatabaseLink )
        CreateDatabaseLink.Cancel        
        
    sleep(1)
    '/// close TOOLS / OPTIONS with cancel
    printlog "close TOOLS / OPTIONS with cancel"
    Kontext "OptionenDlg"
        OptionenDlg.Cancel
        
    '/// close document
    printlog "close document"
        
    call hCloseDocument        
        
endcase
'-------------------------------------------------------------------------
'-------------------------------------------------------------------------
'-------------------------------------------------------------------------
function fDateiOeffnen ( DocName$ )
    
    Dim DieDatei as String
    
    DieDatei = ConvertPath ( DocName$ )
    
    FileOpen
    sleep (1)
    Kontext "OeffnenDlg"
    Dateiname.SetText DieDatei
    sleep (3)
    Oeffnen.Click
    sleep (3)

    fDateiOeffnen = true
    
end function
'-------------------------------------------------------------------------
function getMenuItemCount as Integer
'use this function becasue this doesn't count the pick list
    Dim i, j, Ende, nID as Integer
    Sleep 2
    j=0
    for i=1 to MenuGetItemCount
        if NOT MenuIsSeperator ( i ) then            
            dim s as String 
            s = Mid(MenuGetItemText( MenuGetItemID(i)),3,1)
            'printlog "s = " + s
            'printlog "MenuGetItemText( MenuGetItemID(i)) = " + MenuGetItemText( MenuGetItemID(i))
            if s <> ":" then             
                j=j+1
            endif
        endif
    next i
    getMenuItemCount = j
end function

