static char Version_OpenMX[30] = "3.2 with patch3.2.3"; /* version of OpenMX */ 
 
#define PI              3.1415926535897932384626
#define BYTESIZE        8                        /* Don't change!! */
#define kB              0.00008617251324000000   /* eV/K           */          
#define BohrR           0.529177249              /* Angstrom       */
#define eV2Hartree      27.2113845                
 
#define NYOUSO       60        /* # of YOUSO                                      */
/* #define YOUSO1                 # of atoms in the system                        */ 
/* #define YOUSO2                 # of atoms in hopping cluster                   */
/* #define YOUSO3                 maximum # of recursion levels for GEVP          */
/* #define YOUSO4                 # of 1D-copied cells                            */
/* #define YOUSO5                 size of the first index of HNL                  */
#define YOUSO6      130        /* no role */
/* #define YOUSO7                 max # of orbitals including an atom             */
/* #define YOUSO8                 max # of atoms in a rcut-off cluster            */
/* #define YOUSO9                 maximum # of recursion levels for inverse S     */
#define YOUSO10     100        /* length of a file name                           */
/* #define YOUSO11                max # of grids for an atom                      */
/* #define YOUSO12                max # of overlapping grids                      */
#define YOUSO14     104        /* number of elements in the periodic table        */
/* #define YOUSO15                max # of normK-grids                            */
/* #define YOUSO16                max # of previous steps in real-space Pulay mixing */
/* #define YOUSO17                max # of 1D-grids for FFT in the unit cell      */
/* #define YOUSO18                max # of species in the system                  */
/* #define YOUSO19                # of radial projection obitals in KB potential  */
/* #define YOUSO20                # of total projection obitals in KB potential   */
/* #define YOUSO21                # of mesh for radial wave functions             */
/* #define YOUSO22                # of mesh VPS                                   */
/* #define YOUSO23                # of spin polization                            */
/* #define YOUSO24                max multiplicity of radial wave functions       */
/* #define YOUSO25                max # of L for orbital                          */
#define YOUSO26      60         /* size of the second index in Gxyz[][]           */
/* #define YOUSO27                # of grids along "x"-axis in the k-space        */
/* #define YOUSO28                # of grids along "y"-axis in the k-space        */
/* #define YOUSO29                # of grids along "z"-axis in the k-space        */
/* #define YOUSO30                max # of L for KB projectors                    */
/* #define YOUSO31                # of HOMOs for output                           */
/* #define YOUSO32                # of LUMOs for output                           */
/* #define YOUSO33                # of MO_Nkpoint                                 */
/* #define YOUSO34                # of radial parts in VNA projector expansion    */
/* #define YOUSO35                max L of projectors in VNA projector expansion  */
#define YOUSO36      14         /* max L in Comp2Real array                       */
/* #define YOUSO37                max # of charge states in LESP                  */
/* #define YOUSO38                max # of previous steps in k-space Pulay mixing */

#define Supported_MaxL      4        /* supported max angular momentum for basis orbital */
#define Radial_kmin       10e-7      /* the minimum radius in the radial k-space */
#define GL_Mesh           300        /* # of grids in Gauss-Legendre quadrature */
#define FineGL_Mesh       1500       /* # of grids in fine Gauss-Legendre quadrature */
#define Threshold_OLP_Eigen  1.0e-4  /* threshold for cutting off eigenvalues of OLP */
#define fp_bsize         1048576     /* buffer size for setvbuf */
#define Shift_K_Point    1.0e-6      /* disturbance for stabilization of eigenvalue routine */
#define NG_Mixed_Basis      4        /* NG_Mixed_Basis = (# of grids) / (# of FE basis) */

#define Host_ID             0         /* ID of the host CPU in MPI */


typedef float     Type_DS_VNA;          /* type of DS_VNA */
#define MPI_Type_DS_VNA  MPI_FLOAT      /* type of DS_VNA */

typedef float     Type_Orbs_Grid;       /* type of Orbs_Grid */
#define MPI_Type_Orbs_Grid  MPI_FLOAT   /* type of Orbs_Grid */



#ifndef ___INTEGER_definition___
typedef int INTEGER; /* for fortran integer */
#define ___INTEGER_definition___ 
#endif

#ifndef ___dcomplex_definition___
typedef struct { double r,i; } dcomplex;
#define ___dcomplex_definition___ 
#endif

/* FFT radix */
static int NfundamentalNum=4;
static int fundamentalNum[4]={2,3,5,7};

#ifndef __sqr_definition___
#define sqr(x)   ( (x)*(x) )
#define __sqr_definition___
#endif

#ifdef nompi

#ifndef ___MPI_Comm_definition___
typedef int MPI_Comm;
#define ___MPI_Comm_definition___ 
#endif

#ifndef ___MPI_Status_definition___
typedef struct MPIStatus{int i;}  MPI_Status;  
#define ___MPI_Status_definition___ 
#endif

#ifndef ___MPI_Request_definition___
typedef struct MPIRequest{int i;} MPI_Request;  
#define ___MPI_Request_definition___ 
#endif

#else
#include "mpi.h"
MPI_Comm  mpi_comm_level1;
#endif

#include "f77func.h"

#ifndef ___logical_definition___
typedef long int logical;
#define ___logical_definition___ 
#endif

typedef long int integer;
typedef double doublereal;
typedef short ftnlen;
typedef short flag;
typedef short ftnint;


/*****************************************************************************
                             once allocated arrays
*****************************************************************************/
 
/*******************************************************
 char **SpeName; 
 character symbol of species
  size: SpeName[SpeciesNum][YOUSO10]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
char **SpeName;

/*******************************************************
 char **SpeBasis; 
 character symbol of a basis set assigned to species
  size: SpeBasis[SpeciesNum][YOUSO10]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
char **SpeBasis;

/*******************************************************
 char **SpeBasisName; 
 file name of a basis set assigned to species
  size: SpeBasisName[SpeciesNum][YOUSO10]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
char **SpeBasisName;

/*******************************************************
  char **SpeVPS; 
  file name of pseudo potentials set assigned to species
  size: SpeBasisVPS[SpeciesNum][YOUSO10]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
char **SpeVPS;

/*******************************************************
 int *Spe_MaxL_Basis; 
 the maximum "l" component of used atomic orbitals inv
 each species
  size: Spe_MaxL_Basis[SpeciesNum]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_MaxL_Basis;

/*******************************************************
 int **Spe_Num_Basis; 
 the number of multiplicity of primitive radial parts
 for each "l" component in an species
  size: Spe_Num_Basis[SpeciesNum][6]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Spe_Num_Basis;

/*******************************************************
 int **Spe_Num_CBasis; 
 the number of multiplicity of contracted radial parts
 for each "l" component in an species
  size: Spe_Num_CBasis[SpeciesNum][6]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Spe_Num_CBasis;

/*******************************************************
 double **EH0_scaling;
  scaling factors to vanish Ecore plus EH0
  at the cutoff radius  
  size: EH0_scaling[SpeciesNum][SpeciesNum]
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **EH0_scaling;

/*******************************************************
 double ***Hub_U_Basis          --- added by MJ
 the value of Hubbard U for LDA+U calculation
  size: Hub_U_Basis[SpeciesNum][Spe_MaxL_Basis+1][Spe_Num_Basis]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***Hub_U_Basis ;      /* --- added by MJ  */

/*******************************************************
 int *OrbPol_flag          --- added by MJ and TO
  flag that spefifies how orbital is polarized
  size: OrbPol[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *OrbPol_flag ;          /* --- added by MJ and TO  */

/*******************************************************
 double **Gxyz; 
 atomic global coordinates, velocities, and gradients of
 the total energy with respect to the atomic coordinates
  size: Gxyz[atomnum+1][YOUSO26]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Gxyz;

/********************************************************
 double ***GxyzHistoryIn;
  atomic global coordinates and history
  size GxyzHistoryIn[M_GDIIS_HISTORY+1][atomnum+1][4];
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***GxyzHistoryIn;

/********************************************************
 double ***GxyzHistoryR;
  atomic global coordinates and history
  size GxyzHistoryR[M_GDIIS_HISTORY+1][atomnum+1][4];
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***GxyzHistoryR;

/********************************************************
 double **His_Gxyz;
  history of atomic global coordinates for charge extrapolation
  size His_Gxyz[Extrapolated_Charge_History][3*atomnum];
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **His_Gxyz;

/*******************************************************
 int **atom_Fixed_XYZ;
  atomic global coordinates, =0 relax, =1 fix position
  size: atom_Fixed_XYZ[atomnum+1][3];
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **atom_Fixed_XYZ;

/*******************************************************
 double **Cell_Gxyz; 
 atomic global coordinates spanned
 by the unit cell vectors
  size: Cell_Gxyz[atomnum+1][4]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Cell_Gxyz;

/*******************************************************
 double *InitN_USpin; 
  the number of the upspin electon of initial atoms
  size: InitN_USpin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitN_USpin;

/*******************************************************
 double *InitN_DSpin; 
  the number of the upspin electon of initial atoms
  size: InitN_DSpin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitN_DSpin;

/*******************************************************
 double *Angle0_Spin; 
  angle of theta for atomic projected spin moment
  size: Angle0_Spin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Angle0_Spin;

/*******************************************************
 double *Angle1_Spin; 
  angle of phi for atomic projected spin moment
  size: Angle1_Spin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Angle1_Spin;

/*******************************************************
 double *InitAngle0_Spin; 
  initial angle of theta for atomic projected spin moment
  size: InitAngle0_Spin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitAngle0_Spin;

/*******************************************************
 double *InitAngle1_Spin; 
  initial angle of phi for atomic projected spin moment
  size: InitAngle1_Spin[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitAngle1_Spin;

/*******************************************************
 double *Angle0_Orbital; 
  angle of theta for atomic projected orbital moment
  size: Angle0_Orbital[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Angle0_Orbital;

/*******************************************************
 double *Angle1_Orbital; 
  angle of phi for atomic projected orbital moment
  size: Angle1_Orbital[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Angle1_Orbital;

/*******************************************************
 double *OrbitalMoment;
  magnitude of atomic projected orbital moment
  size: OrbitalMoment[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *OrbitalMoment;

/*******************************************************
 int *Constraint_SpinAngle; 
  flag for constraining the spin angle of atomic projected spin
  size: Constraint_SpinAngle[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Constraint_SpinAngle;

/*******************************************************
 double *InitAngle0_Orbital; 
  initial angle of theta for atomic projected orbital moment
  size: InitAngle0_Orbital[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitAngle0_Orbital;

/*******************************************************
 double *InitAngle1_Orbital; 
  initial angle of phi for atomic projected orbital moment
  size: InitAngle1_Orbital[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *InitAngle1_Orbital;

/*******************************************************
 double **Orbital_Moment_XYZ;
  x-, y-, and z- components of orbital moment calculated
  at each atomic site
  size: Orbital_Moment_XYZ[atomnum+1][3]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Orbital_Moment_XYZ;

/*******************************************************
 int *Constraint_OrbitalAngle; 
  flag for constraining the orbital moment angle of atomic 
  projected orbital moment
  size: Constraint_OrbitalAngle[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Constraint_OrbitalAngle;

/*******************************************************
 int *WhatSpecies; 
 array to specify species for each atom in the system 
  size: WhatSpecies[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *WhatSpecies;

/*******************************************************
 int *GridN_Atom; 
 the number of grids overlaping to each atom
  size: GridN_Atom[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *GridN_Atom;

/*******************************************************
 double *NormK; 
 radial grid values in the reciprocal space
  size: NormK[Ngrid_NormK+1]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *NormK;

/*******************************************************
 double *Spe_Atom_Cut1; 
 cutoff radius of atomic orbitals for each species
  size: Spe_Atom_Cut1[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Spe_Atom_Cut1;

/*******************************************************
 double *Spe_Core_Charge; 
 effective core charge of each species
  size: Spe_Core_Charge[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *Spe_Core_Charge;

/*******************************************************
 int *TGN_EH0; 
 the number of 3D grids for calculating EH0 in
 Correction_Energy.c
  size: TGN_EH0[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *TGN_EH0;

/*******************************************************
 double *dv_EH0; 
 the volume of a grid for calculating EH0 in
 Correction_Energy.c
  size: dv_EH0[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *dv_EH0;

/*******************************************************
 int *Spe_Num_Mesh_VPS; 
 the number of grids for pseudo potentials
  size: Spe_Num_Mesh_VPS[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Num_Mesh_VPS;

/*******************************************************
 int *Spe_Num_Mesh_PAO; 
 the number of grids for atomic orbitals
  size: Spe_Num_Mesh_PAO[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Num_Mesh_PAO;

/*******************************************************
 int *Spe_Total_VPS_Pro; 
 the total number of projector in KB nonlocal potentials
  size: Spe_Total_VPS_Pro[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Total_VPS_Pro;

/*******************************************************
 int *Spe_Num_RVPS; 
 the number of radial projectors in KB nonlocal potentials
  size: Spe_Num_RVPS[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Num_RVPS;

/*******************************************************
 int *Spe_PAO_LMAX; 
 the maximum "l" component of atomic orbitals stored
 in the file of each species
  size: Spe_PAO_LMAX[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_PAO_LMAX;

/*******************************************************
 int *Spe_PAO_Mul; 
 the multiplicity of radial wave functions for each "l"
 component of atomic orbitals stored in the file of each
 species
  size: Spe_PAO_Mul[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_PAO_Mul;

/*******************************************************
 int *Spe_WhatAtom; 
 atomic number in the periodic table for each species
  size: Spe_WhatAtom[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_WhatAtom;

/*******************************************************
 int *Spe_Total_NO; 
 the number of primitive atomic orbitals in a species
  size: Spe_Total_NO[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Total_NO;

/*******************************************************
 int *Spe_Total_CNO; 
 the number of contracted atomic orbitals in a species
  size: Spe_Total_CNO[SpeciesNum]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Total_CNO;

/*******************************************************
 int *FNAN; 
 the number of first neighboring atoms
  size: FNAN[atomnum+1]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *FNAN;

/*******************************************************
 int *SNAN; 
 the number of second neighboring atoms
  size: SNAN[atomnum+1]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *SNAN;

/*******************************************************
 int *MFNAN_GDC; 
 the number of clustered atoms in the GDC method
  size: MFNAN_GDC[Matomnum_GDC+1]
  allocation: call as Set_Allocate_Atom2CPU.c
  free:       call as Set_Allocate_Atom2CPU.c
*******************************************************/
int *MFNAN_GDC;

/*******************************************************
 int *SNAN_GDC; 
 the number of second neighboring atoms except for SNAN
 in the GDC method
  size: SNAN_GDC[atomnum+1]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *SNAN_GDC;

/*******************************************************
 int *True_SNAN;
 the number of second neighboring atoms determined by 
 the conventional truncation scheme in the GDC method
  size: True_SNAN[atomnum+1]
  allocation: call as Allocate_Arrays(2) in readfile.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *True_SNAN;

/*******************************************************
 int **natn; 
  grobal index number of neighboring atoms of an atom ct_AN
  size: natn[atomnum+1][Max_FSNAN*ScaleSize+1]
  allocation: call as Allocate_Arrays(3) in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **natn;

/*******************************************************
 int **natn_GDC; 
  grobal index number of neighboring atoms (related to
  SNAN_GDC) of an atom ct_AN

  size: natn_GDC[atomnum+1][Max_FSNAN*ScaleSize+1]
  allocation: call as ?????
  free:       call as ?????
*******************************************************/
int **natn_GDC;

/*******************************************************
 int **Mnatn_GDC; 
  medium index number of neighboring atoms of an atom
  Mc_AN in the GDC method
  size: Mnatn_GDC[Matomnum+1][]
  allocation: call as Set_Allocate_Atom2CPU.c
  free:       call as Set_Allocate_Atom2CPU.c
*******************************************************/
int **Mnatn_GDC;

/*******************************************************
 int **ncn; 
  grobal index number for cell of neighboring atoms of
  an atom ct_AN
  size: ncn[atomnum+1][Max_FSNAN*ScaleSize+1]
  allocation: call as Allocate_Arrays(3) in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **ncn;

/*******************************************************
 int **ncn_GDC; 
  grobal index number for cell of neighboring atoms
  (related to SNAN_GDC) of an atom ct_AN
  size: ncn_GDC[atomnum+1][Max_FSNAN*ScaleSize+1]
  allocation: call as ????
  free:       call as ????
*******************************************************/
int **ncn_GDC;

/*******************************************************
 double **Dis; 
  distance to neighboring atoms of an atom ct_AN
  size: Dis[atomnum+1][Max_FSNAN*ScaleSize+1]
  allocation: call as Allocate_Arrays(3) in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Dis;

/*******************************************************
 double **GridX_EH0, **GridY_EH0, **GridZ_EH0 ;
  x,y,and z-coordinates of grids for calculating EH0 in
  Correction_Energy.c
  size: GridX_EH0[SpeciesNum][Max_TGN_EH0]
  allocation: call as Allocate_Arrays(4)
              in Correcion_Energy.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **GridX_EH0,**GridY_EH0,**GridZ_EH0;

/*******************************************************
 double **Arho_EH0;
  atomic density on grids for calculating EH0 in
  Correction_Energy.c
  size: Arho_EH0[SpeciesNum][Max_TGN_EH0]
  allocation: call as Allocate_Arrays(4)
              in Correcion_Energy.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Arho_EH0;

/*******************************************************
 double **Wt_EH0;
  quadrature weight of grids for calculating EH0
  in Correction_Energy.c
  size: Wt_EH0[SpeciesNum][Max_TGN_EH0]
  allocation: call as Allocate_Arrays(4)
              in Correcion_Energy.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Wt_EH0;

/*******************************************************
 double **atv;
  xyz translation vectors of periodically copied cells
  size: atv[TCpyCell+1][4]
  allocation: in Set_Periodic() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **atv;

/*******************************************************
 int **ratv;
  queue number of periodically copied cells
  size: ratv[TCpyCell*2+4][TCpyCell*2+4][TCpyCell*2+4];
  allocation: in Set_Periodic() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int ***ratv;

/*******************************************************
 int **atv_ijk;
  i,j,and j number of periodically copied cells
  size: atv_ijk[TCpyCell+1][4];
  allocation: in Set_Periodic() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **atv_ijk;

/*******************************************************
 double **MO_kpoint;
  kpoints at which wave functions are calculated.
  size: MO_kpoint[MO_Nkpoint+1][4]
  allocation: call as Allocate_Arrays(5) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **MO_kpoint;

/*******************************************************
 double **Spe_PAO_XV;
  radial mesh (x=log(r)) for PAO 
  size: Spe_PAO_XV[List_YOUSO[18]]
                  [List_YOUSO[21]]
  allocation: call as Allocate_Arrays(6) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_PAO_XV;

/*******************************************************
 double **Spe_PAO_RV;
  logarithmic radial mesh (r=exp(r)) for PAO 
  size: Spe_PAO_XV[List_YOUSO[18]]
                  [List_YOUSO[21]]
  allocation: call as Allocate_Arrays(6) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_PAO_RV;

/*******************************************************
 double **Spe_Atomic_Den;
  atomic charge densities on radial mesh of PAO 
  size: Spe_Atomic_Den[List_YOUSO[18]]
                      [List_YOUSO[21]]
  allocation: call as Allocate_Arrays(6) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_Atomic_Den;

/*******************************************************
 double ****Spe_PAO_RWF;
  radial parts of basis orbitals on radial mesh of PAO 
  size: Spe_PAO_RWF[List_YOUSO[18]]
                   [List_YOUSO[25]+1]
                   [List_YOUSO[24]]
                   [List_YOUSO[21]]
  allocation: call as Allocate_Arrays(6) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****Spe_PAO_RWF;

/*******************************************************
 double ****Spe_RF_Bessel;
  radial parts of basis orbitals on radial mesh in the
  momentum space
  size: Spe_RF_Bessel[List_YOUSO[18]]
                     [List_YOUSO[25]+1]
                     [List_YOUSO[24]]
                     [List_YOUSO[15]]
  allocation: call as Allocate_Arrays(6) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****Spe_RF_Bessel;

/*******************************************************
 double **Spe_VPS_XV;
  radial mesh (x=log(r)) for VPS 
  size: Spe_VPS_XV[List_YOUSO[18]]
                  [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_VPS_XV;

/*******************************************************
 double **Spe_VPS_XV;
  logarithmic radial mesh (r=exp(x)) for VPS 
  size: Spe_VPS_RV[List_YOUSO[18]]
                  [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_VPS_RV;

/*******************************************************
 double **Spe_Vna;
  neutral atom potentials on radial mesh of VPS
  size: Spe_Vna[List_YOUSO[18]]
               [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_Vna;

/*******************************************************
 double **Spe_VH_Atom;
  Hartree potentials of atomic charge densities
  on radial mesh of VPS
  size: Spe_VH_Atom[List_YOUSO[18]]
                   [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_VH_Atom;

/*******************************************************
 double **Spe_Atomic_PCC;
  partial core correction charge densities on radial
  mesh of VPS
  size: Spe_Atomic_PCC[List_YOUSO[18]]
                      [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_Atomic_PCC;

/*******************************************************
 double ****Spe_VNL;
  radial parts of projectors of non-local potentials
  on radial mesh of VPS
  size: Spe_VNL[SO_switch+1]
               [List_YOUSO[18]]
               [List_YOUSO[19]]
               [List_YOUSO[22]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****Spe_VNL;

/*******************************************************
 double ***Spe_VNLE;
  projection energies of projectors of non-local
  potentials on radial mesh of VPS
  size: Spe_VNLE[SO_switch+1]
                [List_YOUSO[18]]
                [List_YOUSO[19]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***Spe_VNLE;

/*******************************************************
 int **Spe_VPS_List;
  angular momentum numbers of projectors of non-local
  potentials
  size: Spe_VPS_List[List_YOUSO[18]]
                    [List_YOUSO[19]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Spe_VPS_List;

/*******************************************************
 double ****Spe_NLRF_Bessel;
  radial parts of projectors of non-local potentials
  on radial mesh in the momentum space
  size: Spe_RF_Bessel[SO_switch+1]
                     [List_YOUSO[18]]
                     [List_YOUSO[19]+2]
                     [List_YOUSO[15]]
  allocation: call as Allocate_Arrays(7) in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****Spe_NLRF_Bessel;

/*****************************************************************************
                   allocated arrays at every MD step 
*****************************************************************************/

/*******************************************************
 int ***GListTAtoms0;
  grid index (grobal) overlaping between two orbitals 
  size: GListTAtoms0[Matomnum+1]
                    [FNAN[Gc_AN]+1]
                    [NumOLG[Gc_AN][h_AN]]
  allocation: UCell_Box() of truncation.c
  free:       truncation.c and Free_Arrays(0) in openmx.c
*******************************************************/
int ***GListTAtoms0;

/*******************************************************
 int ***GListTCells0;
  cell index (grobal) overlaping between two orbitals 
  size: GListTCells0[Matomnum+1]
                    [FNAN[Gc_AN]+1]
                    [NumOLG[Gc_AN][h_AN]]
  allocation: UCell_Box() of truncation.c
  free:       truncation.c and Free_Arrays(0) in openmx.c
*******************************************************/
int ***GListTCells0;

/*******************************************************
 int ***GListTAtoms1;
  grid index (local for ct_AN) overlaping between
  two orbitals 
  size: GListTAtoms1[Matomnum+1]
                    [FNAN[Gc_AN]+1]
                    [NumOLG[Gc_AN][h_AN]]
  allocation: UCell_Box() of truncation.c
  free:       truncation.c and Free_Arrays(0) in openmx.c
*******************************************************/
int ***GListTAtoms1;

/*******************************************************
 int ***GListTAtoms2;
  grid index (local for h_AN) overlaping between
  two orbitals 
  size: GListTAtoms2[Matomnum+1]
                    [FNAN[Gc_AN]+1]
                    [NumOLG[Gc_AN][h_AN]]
  allocation: UCell_Box() of truncation.c
  free:       truncation.c and Free_Arrays(0) in openmx.c
*******************************************************/
int ***GListTAtoms2;

/*******************************************************
 int ***GListTAtoms3;
  grid index (medium1) overlaping between two orbitals 
  size: GListTAtoms3[Matomnum+1]
                    [FNAN[Gc_AN]+1]
                    [NumOLG[Gc_AN][h_AN]]
  allocation: UCell_Box() of truncation.c
  free:       truncation.c and Free_Arrays(0) in openmx.c
*******************************************************/
int ***GListTAtoms3;

/*******************************************************
 int **GridListAtom; 
  neighboring grid points of an atom Mc_AN
  size: GridListAtom[Matomnum+MatomnumF+1][Max_GridN_Atom*ScaleSize+1]
  allocation: allocate in UCell_Box() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **GridListAtom;

/*******************************************************
 int **CellListAtom; 
  cell number of neighboring grid points of an atom Mc_AN
  size: CellListAtom[Matomnum+MatomnumF+1][Max_GridN_Atom*ScaleSize+1]
  allocation: allocate in UCell_Box() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **CellListAtom;

/*******************************************************
 int **MGridListAtom; 
  neighboring grid points (medium variable) of an atom Mc_AN
  size: MGridListAtom[Matomnum+MatomnumF+1][Max_GridN_Atom*ScaleSize+1]
  allocation: allocate in UCell_Box() of truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **MGridListAtom;

/*******************************************************
 double **Density_Grid; 
  electron densities on grids
  size: Density_Grid[2 or 4][Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Density_Grid;

/*******************************************************
 double *ADensity_Grid; 
  electron densities by the superposition of atomic
  densities on grids
  size: ADensity_Grid[Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *ADensity_Grid;

/*******************************************************
 double *PCCDensity_Grid; 
  electron densities by the superposition of partial 
  core correction densities on grids
  size: PCCDensity_Grid[Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *PCCDensity_Grid;

/*******************************************************
 double **Vxc_Grid; 
  exchange-correlation potentials on grids
  size: Vxc_Grid[2 or 4][Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Vxc_Grid;

/*******************************************************
 double *VNA_Grid; 
  neutral atom potential on grids
  size: VNA_Grid[Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *VNA_Grid;

/*******************************************************
 double *VEF_Grid; 
  potential on grids by external electric field
  size: VEF_Grid[Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *VEF_Grid;

/*******************************************************
 double *dVHart_Grid; 
  Hartree potential of the differential
  electron density on grids
  size: dVHart_Grid[Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *dVHart_Grid;

/*******************************************************
 double **Vpot_Grid; 
  Kohn-Sham effective potentials on grids
  size: Vpot_Grid[2 or 4][Num_Cells0*Ngrid2*Ngrid3]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **Vpot_Grid;

/*******************************************************
 Type_Orbs_Grid ***Orbs_Grid;
  values of basis orbitals on grids
  size: Orbs_Grid[Matomnum+MatomnumF+1]
                 [Spe_Total_NO[Cwan]]
                 [GridN_Atom[Gc_AN]]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
Type_Orbs_Grid ***Orbs_Grid;

/*******************************************************
 Type_Orbs_Grid ***COrbs_Grid;
  values of contrated basis orbitals on grids
  size: COrbs_Grid[Matomnum+MatomnumF+1]
                  [Spe_Total_NO[Cwan]]
                  [GridN_Atom[Gc_AN]]
  allocation: allocate in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
Type_Orbs_Grid ***COrbs_Grid;

/*******************************************************
 double *****H0;
  matrix elements of basis orbitals for T+VNL
  size: H0[4]
          [Matomnum+1]
          [FNAN[Gc_AN]+1]
          [Spe_Total_NO[Cwan]]
          [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****H0;

/*******************************************************
 double *****CntH0;
  matrix elements of contracted basis orbitals for T+VNL
  size: CntH0[4]
             [Matomnum+1]
             [FNAN[Gc_AN]+1]
             [Spe_Total_CNO[Cwan]]
             [Spe_Total_CNO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****CntH0;

/*******************************************************
 double *****HNL;
  real matrix elements of basis orbitals for non-local VPS
  size: HNL[List_YOUSO[5]]
           [Matomnum+1]
           [FNAN[Gc_AN]+1]
           [Spe_Total_NO[Cwan]]
           [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****HNL;

/*******************************************************
 double *****iHNL;
  imaginary matrix elements of basis orbitals for non-local VPS
  size: iHNL[List_YOUSO[5]]
            [Matomnum+MatomnumF+MatomnumS+1]
            [FNAN[Gc_AN]+1]
            [Spe_Total_NO[Cwan]]
            [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****iHNL;

/*******************************************************
 double *****iCntHNL;
  imaginary matrix elements of contracted basis orbitals
  for non-local VPS
  size: iCntHNL[List_YOUSO[5]]
               [Matomnum+MatomnumF+MatomnumS+1]
               [FNAN[Gc_AN]+1]
               [Spe_Total_CNO[Cwan]]
               [Spe_Total_CNO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****iCntHNL;

/*******************************************************
 double *****OLP_L;
  <i|lx,ly,lz|j> overlap matrix elements with lx,y,z
  operator of basis orbitals which are used to calculate
  orbital moment
  size: OLP_L[3]
             [Matomnum+1]
             [FNAN[Gc_AN]+1]
             [Spe_Total_NO[Cwan]]
             [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****OLP_L;

/*******************************************************
 double *****OLP;
  overlap matrix elements of basis orbitals
  size: OLP[4]
           [Matomnum+MatomnumF+MatomnumS+1]
           [FNAN[Gc_AN]+1]
           [Spe_Total_NO[Cwan]]
           [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****OLP;

/*******************************************************
 double *****CntOLP;
  overlap matrix elements of contracted basis orbitals
  size: CntOLP[4]
              [Matomnum+MatomnumF+MatomnumS+1]
              [FNAN[Gc_AN]+1]
              [Spe_Total_CNO[Cwan]]
              [Spe_Total_CNO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****CntOLP;

/*******************************************************
 double *****H;
  Kohn-Sham matrix elements of basis orbitals
  size: H[SpinP_switch+1]
         [Matomnum+MatomnumF+MatomnumS+1]
         [FNAN[Gc_AN]+1]
         [Spe_Total_NO[Cwan]]
         [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****H;

/*******************************************************
 double *****CntH;
  Kohn-Sham matrix elements of contracted basis orbitals
  size: CntH[SpinP_switch+1]
            [Matomnum+MatomnumF+MatomnumS+1]
            [FNAN[Gc_AN]+1]
            [Spe_Total_CNO[Cwan]]
            [Spe_Total_CNO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****CntH;

/*******************************************************
 double *****H_Hub;             --- added by MJ
  real part of effective Hubbard Hamiltonian;
  same structure with OLP but the first dimension of OLP,
  the dimensions for derivatives, is not required in H_Hub.
  instead of it, H_Hub should have spin index.
  size: H_Hub[spin]
             [Matomnum+1 --> Mc_AN]  
             [FNAN[Gc_AN]+1]
             [Spe_Total_NO[Cwan]]
             [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****H_Hub;           /* --- added by MJ  */

/*******************************************************
 double *****iHNL0;             --- added by TO
  imaginary matrix elements for non-local VPS
  size: iHNL[List_YOUSO[5]]
            [Matomnum+1]
            [FNAN[Gc_AN]+1]
            [Spe_Total_NO[Cwan]]
            [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****iHNL0;           /* --- added by TO  */

/*******************************************************
 double ******DS_NL;
  overlap matrix elements between projectors,
  of non-local potentials, and basis orbitals 
  size: DS_NL[SO_switch+1]
             [4]
             [Matomnum+MatomnumF+1]
             [FNAN[Gc_AN]+1]
             [Spe_Total_NO[Cwan]]
             [Spe_Total_VPS_Pro[Hwan]+2] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******DS_NL;

/*******************************************************
 double ******CntDS_NL;
  overlap matrix elements between projectors, of non-local
  potentials, and contracted basis orbitals 
  size: CntDS_NL[SO_switch+1] 
                [4]
                [Matomnum+MatomnumF+1]
                [FNAN[Gc_AN]+1]
                [Spe_Total_CNO[Cwan]]
                [Spe_Total_VPS_Pro[Hwan]+2] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******CntDS_NL;

/*******************************************************
 double ***H_Zeeman_NCO;          
  matrix element introduced by the constraint for orbital
  magnetic moments. Note that the matrix elements are purely
  imaginary. 
  size: H_Zeeman_NCO[Matomnum+1]  
                    [Spe_Total_NO[Cwan]]
                    [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***H_Zeeman_NCO;

/*******************************************************
 double ***TRAN_DecMulP;
  partial decomposed Mulliken population by CL or CR 
  overlapping 
  size: TRAN_DecMulP
          [SpinP_switch+1]
          [Matomnum+1]
          [List_YOUSO[7]]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***TRAN_DecMulP;

/*******************************************************
 double ******DM;
  current and old density matrices
  size: DM[List_YOUSO[16]]
          [SpinP_switch+1]
          [Matomnum+1]
          [FNAN[Gc_AN]+1]
          [Spe_Total_NO[Cwan]]
          [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******DM;

/*******************************************************
 double ****DM_onsite;     --- added by MJ
   current 'onsite' density matrices
  ; same with ******DM, but [List_YOUSO[16] = 0],[FNAN[Gc_AN]+1 = 0]
   i.e. DM_onsite[][][][][] is defined as DM[0][][][0][][].
   To make DM_onsite physically meaninful(H_Hub must be Hermitian),
   it is set to be diagonal in the U_Mulliken_Charge.c.
   Therefore, last two dimensions are equivalent, i.e.,
   if [Spe_Total_NO[Cwan]] != [Spe_Total_NO[Hwan]] then
   DM_onsite = 0.
   So, it is possible to reduce the dimension of this array into 3, 
   but it remains for the future generalization.

  size: DM_onsite
          [2]
          [SpinP_switch+1]
          [Matomnum+1]
          [Spe_Total_NO[Cwan]]
          [Spe_Total_NO[Hwan]] 
  allocation: allocate in  truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****DM_onsite;     /* --- added by MJ  */

/*******************************************************
 double ****v_eff;     --- added by MJ
  temporary effective Hubbard type potential which will be used
  to construct the effective Hubbard potential, V_eff.
  (cf. MJ's LDA+U note at 14, April 2004)

  size: v_eff
         [SpinP_switch+1]
         [Matomnum+MatomnumF+1]
         [Spe_Total_NO[Cwan]]
         [Spe_Total_NO[Cwan]] 
  allocation: allocate in  truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****v_eff;     /* --- added by MJ  */

/*******************************************************
 dcomplex ******NC_OcpN;     
   matrix consisting of occupation numbers which are used in 
   the non-collinear LDA+U method and a constraint DFT for 
   the spin orientation at each site. 

  size: NC_OcpN
          [2]
          [2]
          [2]
          [Matomnum+1]
          [Spe_Total_NO[Cwan]]
          [Spe_Total_NO[Cwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
dcomplex ******NC_OcpN;  

/*******************************************************
 dcomplex *****NC_v_eff;     
   effectiv potential which are used in the non-collinear
   LDA+U method and a constraint DFT for the spin orientation
   at each site. 

  size: NC_v_eff
          [2]
          [2]
          [Matomnum+MatomnumF+1]
          [Spe_Total_NO[Cwan]]
          [Spe_Total_NO[Cwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
dcomplex *****NC_v_eff;

/*******************************************************
 double ******ResidualDM;
  current and old residual real density matrices, which are
  defined as the difference between input and output
  density matrices
  size: ResidualDM[List_YOUSO[16]]
                  [SpinP_switch+1]
                  [Matomnum+1]
                  [FNAN[Gc_AN]+1]
                  [Spe_Total_NO[Cwan]]
                  [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******ResidualDM;

/*******************************************************
 double ******iResidualDM;
  current and old residual imaginary density matrices,
  which are defined as the difference between input and
  output density matrices
  size: iResidualDM[List_YOUSO[16]]
                   [2]
                   [Matomnum+1]
                   [FNAN[Gc_AN]+1]
                   [Spe_Total_NO[Cwan]]
                   [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******iResidualDM;

/*******************************************************
 double *****EDM;
  current energy density matrices
  size: EDM[SpinP_switch+1]
           [Matomnum+1]
           [FNAN[Gc_AN]+1]
           [Spe_Total_NO[Cwan]]
           [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****EDM;

/*******************************************************
 double *****PDM;
  density matrix at one-step before
  size: PDM[SpinP_switch+1]
           [Matomnum+1]
           [FNAN[Gc_AN]+1]
           [Spe_Total_NO[Cwan]]
           [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****PDM;

/*******************************************************
 double *****iDM;
  imaginary density matrix
  size: iDM[List_YOUSO[16]]
           [2]
           [Matomnum+1]
           [FNAN[Gc_AN]+1]
           [Spe_Total_NO[Cwan]]
           [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ******iDM;

/*******************************************************
 double ****IOLP;
  inverse overlap matrix
  size: IOLP[Matomnum+MatomnumF+MatomnumS+1]
            [FNAN[Gc_AN]+SNAN[Gc_AN]+1]
            [Spe_Total_NO[Cwan]]
            [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****IOLP;

/*******************************************************
 double ***S12;
  S^{-1/2} of overlap matrix in divide-conquer (DC) method
  and generalized divide-conquer (GDC) method

  size: S12[Matomnum    +1][n2][n2] for  DC method
  size: S12[Matomnum_GDC+1][n2][n2] for GDC method
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***S12;

/*******************************************************
 double *****Left_U0;
  the initial left side Lanczos vectors which span
  a subspace in the recursion method method.

  size: Left_U0[SpinP_switch+1][Matomnum+1]
               [List_YOUSO[3]][tno1][vsize]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****Left_U0;

/*******************************************************
 double *****Right_U0;
  the initial right side Lanczos vectors which span
  a subspace in the recursion method method.

  size: Right_U0[SpinP_switch+1][Matomnum+1]
                [List_YOUSO[3]][tno1][vsize]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****Right_U0;

/*******************************************************
 int **NumOLG;
  the number of overlapping grids between atom Mc_AN 
  and atom Lh_AN
  size: NumOLG[Matomnum+1]
              [FNAN[Gc_AN]+1]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int **NumOLG;

/*******************************************************
 int *RNUM;
  the number of initial recusion levels of each atom 
  size: RNUM[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *RNUM;

/*******************************************************
 int *RNUM2;
  the number of current recusion levels of each atom 
  size: RNUM2[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *RNUM2;

/*******************************************************
 int ***RMI1;
  a table which converts local atomic index to global
  atomic index. 
  size: RMI1[Matomnum+1]
            [FNAN[Gc_AN]+SNAN[Gc_AN]+1]
            [FNAN[Gc_AN]+SNAN[Gc_AN]+1]
  allocation: in Trn_System() of truncation.c
  free:       truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int ***RMI1;

/*******************************************************
 int ***RMI2;
  a table which converts local atomic index to global
  atomic index. 
  size: RMI2[Matomnum+1]
            [FNAN[Gc_AN]+SNAN[Gc_AN]+1]
            [FNAN[Gc_AN]+SNAN[Gc_AN]+1]
  allocation: in Trn_System() of truncation.c
  free:       truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int ***RMI2;

/*******************************************************
 dcomplex *****HOMOs_Coef;
  LCAO coefficients of HOMOs 
  size: HOMOs_Coef[List_YOUSO[33]]
                  [2] 
                  [List_YOUSO[31]]
                  [List_YOUSO[1]]
                  [List_YOUSO[7]]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
dcomplex *****HOMOs_Coef;

/*******************************************************
 dcomplex *****LUMOs_Coef;
  LCAO coefficients of HOMOs 
  size: HOMOs_Coef[List_YOUSO[33]]
                  [2] 
                  [List_YOUSO[32]]
                  [List_YOUSO[1]]
                  [List_YOUSO[7]]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
dcomplex *****LUMOs_Coef;

/*******************************************************
 int **Spe_Specified_Num;
  a table which converts index of contracted orbitals
  to that of primitive orbitals
  size: Spe_Specified_Num[List_YOUSO[18]]
                         [Spe_Total_NO[spe]]  
  allocation: in Set_BasisPara() of SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Spe_Specified_Num;

/*******************************************************
 int ***Spe_Trans_Orbital;
  a table which converts index of contracted orbitals
  to that of primitive orbitals
  size: Spe_Trans_Orbital[List_YOUSO[18]]
                         [Spe_Total_NO[spe]]  
                         [List_YOUSO[24]]
  allocation: in Set_BasisPara() of SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int ***Spe_Trans_Orbital;

/*******************************************************
 int *Spe_Spe2Ban;
  intermediate variable used in Correction_Energy.c
  size: Spe_Spe2Ban[List_YOUSO[18]]
  allocation: Allocation_Arrays(0) in Input_std()
              of SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Spe_Spe2Ban;

/*******************************************************
 int *Bulk_Num_HOMOs;
  the number of HOMOs of bulk for outputting to files
  size: Bulk_Num_HOMOs[List_YOUSO[33]]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Bulk_Num_HOMOs;

/*******************************************************
 int *Bulk_Num_LUMOs;
  the number of LUMOs of bulk for outputting to files
  size: Bulk_Num_HOMOs[List_YOUSO[33]]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Bulk_Num_LUMOs;

/*******************************************************
 int **Bulk_HOMO;
  HOMOs of up and down spins in the bulk systems
  size: Bulk_HOMO[List_YOUSO[33]][2]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Bulk_HOMO;

/*******************************************************
 double ***CntCoes;
  contraction coefficients of basis orbitals
  size: CntCoes[Matomnum+MatomnumF+1]
               [List_YOUSO[7]]
               [List_YOUSO[24]]
  allocation: in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ***CntCoes;

/*******************************************************
 int *CntOrb_Atoms;
  atoms for outputting contraction coefficients of
  basis orbitals to files
  size: CntOrb_Atoms[Num_CntOrb_Atoms]
  allocation: in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *CntOrb_Atoms;

/*******************************************************
 double **S;
  a full overlap matrix
  size: S[Size_Total_Matrix+2][Size_Total_Matrix+2]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double **S;

/*******************************************************
 double *EV_S;
  the eigenvalues of a full overlap matrix
  size: EV_S[Size_Total_Matrix+2]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *EV_S;

/*******************************************************
 double *IEV_S;
  the inverse of eigenvalues of a full overlap matrix
  size: IEV_S[Size_Total_Matrix+2]
  allocation: in SetPara_DFT.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *IEV_S;

/*******************************************************
 int *M2G
  M2G gives a conversion from the medium
  index to the global indicies of atoms.
  size: M2G[Matomnum+1]
  allocation: in Set_Allocate_Atom2CPU.c
  free:       call as Free_Arrays(0) in openmx.c
              and in Set_Allocate_Atom2CPU.c
*******************************************************/
int *M2G;

/*******************************************************
 int *F_M2G, *S_M2G;
  F_M2G, and S_M2G give a conversion from the medium
  index (Matomnum+MatomnumF,
         Matomnum+MatomnumF+MatomnumS)
  to the global indicies of atoms.
  size: F_M2G[Matomnum+MatomnumF+1],
        S_M2G[Matomnum+MatomnumF+MatomnumS+1]
  allocation: in truncation.c
  free:       call as Free_Arrays(0) in openmx.c
              and in truncation.c
*******************************************************/
int *F_M2G,*S_M2G;

/*******************************************************
 int *VPS_j_dependency;
  VPS_j_dependency gives a flag whethere the VPS depends
  on total moment j.
  size: VPS_j_dependency[SpeciesNum],
  allocation: call as Allocate_Arrays(0) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *VPS_j_dependency;

/*******************************************************
 int *ESM_Atoms;
  atoms for calculating exchange splitting matrix
  size: ESM_Atoms[Num_ESM]
  allocation: in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *ESM_Atoms;

/*******************************************************
 double *****ESM;
  exchange splitting matrix
  size: ESM[Num_ESM][FNAN][FNAN][tno0][tno1]
  allocation: in Make_ESM.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****ESM;

/*******************************************************
 double ***Projector_VNA;
  Projectors for a projector expansion of VNA
  size: Projector_VNA[List_YOUSO[18]][YOUSO35+1][YOUSO34][List_YOUSO[22]]
  allocation: call Allocate_Arrays(7) in SetPara_DFT.c
  free:       call Free_Arrays(0) in openmx.c
*******************************************************/
double ****Projector_VNA;

/*******************************************************
 double **VNA_proj_ene;
  Projector energy for a projector expansion of VNA
  size: VNA_proj_ene[List_YOUSO[18]][YOUSO35+1][YOUSO34]
  allocation: call Allocate_Arrays(7) in SetPara_DFT.c
  free:       call Free_Arrays(0) in openmx.c
*******************************************************/
double ***VNA_proj_ene;

/*******************************************************
 double ***Spe_VNA_Bessel;
  radial parts of projectors of VNA on radial mesh
  in the momentum space
  size: Spe_VNA_Bessel[List_YOUSO[18]][YOUSO35+1][YOUSO34][List_YOUSO[15]]
  allocation: call Allocate_Arrays(7) in SetPara_DFT.c
  free:       call Free_Arrays(0) in openmx.c
*******************************************************/
double ****Spe_VNA_Bessel;

/*******************************************************
 double **Spe_CrudeVNA_Bessel;
  radial parts of crude VNA potentials on
  Gauss-Legendre radial mesh in the momentum space
  size: Spe_CrudeVNA_Bessel[List_YOUSO[18]][GL_Mesh+2]
  allocation: call Allocate_Arrays(7) in SetPara_DFT.c
  free:       call Free_Arrays(0) in openmx.c
*******************************************************/
double **Spe_CrudeVNA_Bessel;

/*******************************************************
 double *******Spe_ProductRF_Bessel;
  radial parts of product of two PAOs on
  Gauss-Legendre radial mesh in the momentum space
  size: Spe_ProductRF_Bessel[List_YOUSO[18]]
                            [Spe_MaxL_Basis[i]+1]
                            [Spe_Num_Basis[i][j]]
                            [Spe_MaxL_Basis[i]+1]
                            [Spe_Num_Basis[i][l]]
                            [Lmax+1]
                            [GL_Mesh+2]
  allocation: call Allocate_Arrays(7) in SetPara_DFT.c
  free:       call Free_Arrays(0) in openmx.c
*******************************************************/
double *******Spe_ProductRF_Bessel;

/*******************************************************
 double ****HVNA;
  real matrix elements of basis orbitals for VNA projectors
  size: HVNA[Matomnum+1]
            [FNAN[Gc_AN]+1]
            [Spe_Total_NO[Cwan]]
            [Spe_Total_NO[Hwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****HVNA;

/*******************************************************
 Type_DS_VNA *****DS_VNA;
  overlap matrix elements between projectors of VNA
  potentials, and basis orbitals 
  size: DS_VNA[4]
              [Matomnum+MatomnumF+1]
              [FNAN[Gc_AN]+1]
              [Spe_Total_NO[Cwan]]
              [(YOUSO35+1)*(YOUSO35+1)*YOUSO34]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
Type_DS_VNA *****DS_VNA;

/*******************************************************
 Type_DS_VNA *****CntDS_VNA;
  overlap matrix elements between projectors of VNA
  potentials, and contracted basis orbitals 
  size: CntDS_VNA[4]
                 [Matomnum+MatomnumF+1]
                 [FNAN[Gc_AN]+1]
                 [Spe_Total_CNO[Cwan]]
                 [(YOUSO35+1)*(YOUSO35+1)*YOUSO34]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
Type_DS_VNA *****CntDS_VNA;

/*******************************************************
 double ****HVNA2;
  real matrix elements of basis orbitals for VNA projectors
  size: HVNA2[4]
             [Matomnum+MatomnumF+1]
             [FNAN[Gc_AN]+1]
             [Spe_Total_NO[Cwan]]
             [Spe_Total_NO[Cwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****HVNA2;

/*******************************************************
 double ****CntHVNA2;
  real matrix elements of basis orbitals for VNA projectors
  size: CntHVNA2[4]
                [Matomnum+MatomnumF+1]
                [FNAN[Gc_AN]+1]
                [Spe_Total_CNO[Cwan]]
                [Spe_Total_CNO[Cwan]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****CntHVNA2;

/*******************************************************
 double *****Krylov_U
  a Krylov matrix used in the embedding cluster method
  size: Krylov_U[SpinP_switch+1]
                [Matomnum+1]
                [List_YOUSO[3]]
                [List_YOUSO[7]] 
                [(Max_FNAN+1)*List_YOUSO[7]]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *****Krylov_U;

/*******************************************************
 double ****EC_matrix
  a perturbation matrix used in the embedding cluster method
  size: EC_matrix[SpinP_switch+1]
                 [Matomnum+1]
                 [List_YOUSO[3]*List_YOUSO[7]] 
                 [List_YOUSO[3]*List_YOUSO[7]] 
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double ****EC_matrix;

/*******************************************************
 int *rlmax_EC;
  recursion level to generate the preconditioning matrix
  for Hamiltonian in EC method
  size: rlmax_EC[Matomnum+1]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *rlmax_EC;

/*******************************************************
 int *rlmax_EC2;
  recursion level to generate the preconditioning matrix
  for overlap matrix in EC method
  size: rlmax_EC2[Matomnum+1]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *rlmax_EC2;

/*******************************************************
 int *EKC_core_size;
  core size in EKC method
  size: EKC_core_size[Matomnum+1]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *EKC_core_size;

/*******************************************************
 double *scale_rc_EKC;
  scale factor to determine the core size in EKC method
  size: scale_rc_EKC[Matomnum+1]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *scale_rc_EKC;

/*******************************************************
 double *DIAG_LBFGS
  DIAG array for LBFGS method 
  size: DIAG_LBFGS[NDIM_LBFGS]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *DIAG_LBFGS;

/*******************************************************
 double *W_LBFGS
  W array for LBFGS method 
  size: W_LBFGS[NWORK_LBFGS]
  allocation: allocate in truncation.c
  free:       in truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
double *W_LBFGS;







dcomplex *zp,*Ep,*Rp;
double GL_Abscissae[GL_Mesh+2],GL_Weight[GL_Mesh+2];
double FineGL_Abscissae[FineGL_Mesh+2],FineGL_Weight[FineGL_Mesh+2];
double GL_NormK[GL_Mesh+2];
char Atom_Symbol[YOUSO14][4];
double Atom_Weight[YOUSO14];
double tv[4][4],rtv[4][4];
double Left_tv[4][4],Right_tv[4][4];
double gtv[4][4],rgtv[4][4],length_gtv[4];
double gtv_FE[4][4],rgtv_FE[4][4];

double Grid_Origin[4];
double dipole_moment[4][4];
double TempPara[30][3],PrePara[30][3];
double MD_TimeStep,ChemP,Beta,CN_Error,E_Temp,FCR,BCR;
double GP,GT,T,Weight,Cell_Volume,Uele,Uele2,Ukc,Uvdw;
double Uele_OS0,Uele_OS1,Uele_IS0,Uele_IS1,Uxc0,Uxc1;
double UH0,UH1,UH2,Ucore,Uhub,Ucs,Uef,Ukin,Unl,Una,Uzs,Uzo;
double Ucc,Ucoh,Uatom,Udc,Utot,Uxc,Given_Total_Charge,Calc_Total_Charge;
double Min_Mixing_weight,Max_Mixing_weight,Max_Mixing_weight2,Mixing_weight;
double Kerker_factor;
double Gdiis_Mixing,system_charge,VNA_reduce_ratio,Total_Num_Electrons;
double Total_SpinS,Total_SpinSx,Total_SpinSy,Total_SpinSz;
double Total_OrbitalMoment,Total_OrbitalMomentx;
double Total_OrbitalMomenty,Total_OrbitalMomentz;
double Total_SpinAngle0,Total_SpinAngle1;
double Total_OrbitalMomentAngle0,Total_OrbitalMomentAngle1;
double ScaleSize,Pin[4][4],Ptot[4][4];
double LastBoxCenterX,LastBoxCenterY,LastBoxCenterZ;
double Vol,Vol1,Vol2,Vol3,W;
double SCF_Criterion,NormRD[5],BestNormRD,History_Uele[5];
double PAO_Nkmax,Grid_Ecut,Finite_Elements_Ecut,rcut_FEB;
double orbitalOpt_criterion,MD_Opt_criterion;
dcomplex Comp2Real[YOUSO36+1][2*(YOUSO36+1)+1][2*(YOUSO36+1)+1];
/* added by mari (May 2004) */
double TempScale[30],RatScale[30],Temp; 
int IntScale[30],NumScale[30];
/* added by mari (May 2004) */
/* for Nose-Hoover algorithm */
double NH_R,NH_nzeta,NH_czeta,TempQ,GivenTemp,NH_Ham;

int alloc_first[30],Last_TNumGrid;
int Scf_RestartFromFile,Band_disp_switch; 
int coordinates_unit,unitvector_unit;
int Size_Total_Matrix,SP_PEV,EKC_core_size_max;
int specified_system,MO_fileout,num_HOMOs,num_LUMOs;
int Cluster_HOMO[2],MO_Nkpoint,ML_flag,ForceConsistency_flag,force_flag;
int CntOrb_fileout,Num_CntOrb_Atoms,Num_ESM,ESM_flag;
int remake_headfile,OneD_Grid,Ngrid1,Ngrid2,Ngrid3;
int Ngrid1_FE,Ngrid2_FE,Ngrid3_FE;
int TNumGrid,Kspace_grid1,Kspace_grid2,Kspace_grid3;
int DFTSCF_loop,Ngrid_NormK,SCF_RENZOKU;
int Mixing_switch,MD_IterNumber,Av_num,T_switch,IS_switch;
int MD_Init_Velocity;
int rlmax_IS,XC_switch,PCC_switch,SpinP_switch,SpeciesNum,real_SpeciesNum;
int Hub_U_switch,Hub_U_occupation,Hub_U_Enhance_OrbPol;  /* --- added by MJ */
int SO_switch,MPI_tunedgrid_flag,Voronoi_Charge_flag,Voronoi_OrbM_flag;
int Constraint_NCS_switch;
int Zeeman_NCS_switch,Zeeman_NCO_switch;
int atomnum,Catomnum,Latomnum,Ratomnum,atomnum_GDC;
int POLES,rlmax,Solver,Solver_DIIS_flag,dste_flag,Ngrid_fixed_flag;
int KrylovH_order,KrylovS_order,recalc_EM,EKC_invS_flag;
int EKC_Exact_invS_flag,EKC_expand_core_flag;
int MD_switch,PeriodicGamma_flag;
int Max_FNAN,Max_FSNAN,Max_GridN_Atom,Max_NumOLG,Max_OneD_Grids;
int Max_Nd,Max_TGN_EH0,CellNN_flag,Kmixing_flag;
int List_YOUSO[NYOUSO];
int PreNum,TempNum,TCpyCell,CpyCell;
int Num_Mixing_pDM,level_stdout,level_fileout,HS_fileout;
int Pulay_SCF,EveryPulay_SCF;
int Cnt_switch,RCnt_switch,SICnt_switch,ACnt_switch;
int E_Field_switch,Simple_InitCnt[10];
int MD_Opt_OK,orbitalOpt_SCF,orbitalOpt_MD,orbitalOpt_per_MDIter;
int NOHS_L,NOHS_C,ProExpn_VNA,BufferL_ProVNA,Mixed_Basis_flag;
int M_GDIIS_HISTORY,OptStartDIIS,OptEveryDIIS;
int Extrapolated_Charge_History;
int NDIM_LBFGS,MSAVE_LBFGS,NWORK_LBFGS;
int orderN_Kgrid,FT_files_save,FT_files_read;
double **CompTime;

char filename[YOUSO10],filepath[YOUSO10],command[YOUSO10];
char DFT_DATA_PATH[YOUSO10];
double Oopt_NormD[10];
double bias_weight,Past_Utot[10];
double Max_Force,GridVol,W_OrthoNorm,Cnt_scaling;
double SD_scaling,SD_scaling_user;
double GDC_opt,Constraint_NCS_V;
double Mag_Field_Orbital,Mag_Field_Spin;
double scf_fixed_origin[4];
int F_dVHart_flag,F_Vxc_flag,F_VNA_flag;
int F_VEF_flag,F_Kin_flag,F_NL_flag,F_U_flag;

/* band dispersion */
int Band_Nkpath,Band_kPathUnit;
double Band_UnitCell[4][4];
int *Band_N_perpath;
double ***Band_kpath;
char ***Band_kname; 

/*  DOS */
int DosGauss_fileout;
int Dos_fileout;
int DosGauss_Num_Mesh;
double DosGauss_Width;
double Dos_Erange[2];
int Dos_Kgrid[3];
int Opticalconductivity_fileout;

/*  electric field */ 
double E_Field[3];

/*------------------------------------------------------------------------*/
void Maketest(int argc, char *argv[]);
void MaketestL(int argc, char *argv[]); 
void Runtest(char *mode, int argc, char *argv[]);
void Memory_Leak_test(int argc, char *argv[]);
void Get_VSZ(int MD_iter);
void Force_test(int argc, char *argv[]);
void Check_Force(char *argv[]);

double RF_BesselF(int Gensi, int GL, int Mul, double R);
double Nonlocal_RadialF(int Gensi, int l, int so, double R);
double PhiF(double R, double *phi0, double *MRV, int Grid_Num);
double AngularF(int l, int m, double Q, double P, int Use_switch,
                double siQ, double coQ, double siP, double coP);
double RadialF(int Gensi, int L, int Mul, double R);
void Dr_RadialF(int Gensi, int L, int Mul, double R, double Deri_RF[3]);
double Smoothing_Func(double rcut,double r1);
double VNAF(int Gensi, double R);
double Dr_VNAF(int Gensi, double R);
double VH_AtomF(int Gensi, double R);
double Dr_VH_AtomF(int Gensi, double R);
double AtomicDenF(int Gensi, double R);
double Dr_AtomicDenF(int Gensi, double R);
double AtomicPCCF(int Gensi, double R);
double Dr_AtomicPCCF(int Gensi, double R);
double AtomicCoreDenF(int Gensi, double R);
double Nonlocal_Basis(int wan, int Lnum_index, int Mnum, int so,
                      double r, double theta, double phi);
void Setup_Mixed_Basis(char *file, int myid);

void Get_Orbitals(int wan, double x, double y, double z, double *Chi);
void Get_dOrbitals(int wan, double R, double Q, double P, double **dChi);
void Get_Cnt_Orbitals(int Mc_AN, double x, double y, double z, double *Chi);
void Get_Cnt_dOrbitals(int Mc_AN, double x, double y, double z, double **dChi);

double Set_Orbitals_Grid(int Cnt_kind);
double Set_Aden_Grid(int init_density);
double Set_Density_Grid(int Cnt_kind, int Calc_CntOrbital_ON, double *****CDM);
void diagonalize_nc_density();
void Mulliken_Charge( char *mode );
/* added by MJ */
void Occupation_Number_LDA_U(int SCF_iter, int SucceedReadingDMfile, double dUele, double ECE[], char *mode);
/* added by MJ */
void Eff_Hub_Pot(int SCF_iter, double ****OLP0);
void EulerAngle_Spin( int quickcalc_flag,
                      double Re11, double Re22,
                      double Re12, double Im12,
                      double Re21, double Im21,
                      double Nup[2], double Ndown[2],
                      double t[2], double p[2] );

void Orbital_Moment(char *mode);


double Mixing_DM(int MD_iter,
                 int SCF_iter,
                 int SCF_iter0,
                 int SucceedReadingDMfile,
                 double *****ReRhok,
                 double *****ImRhok,
                 double ****ReBestRhok,
                 double ****ImBestRhok,
                 double *****Residual_ReRhok,
                 double *****Residual_ImRhok,
                 double ***ReV1,
                 double ***ImV1,
                 double ***ReV2,
                 double ***ImV2,
                 double ***ReRhoAtomk,
                 double ***ImRhoAtomk);
void Simple_Mixing_DM(int Change_switch, 
                      double Mix_wgt,
                      double *****CDM,
                      double *****PDM,
                      double *****P2DM,
                      double *****iCDM,
                      double *****iPDM,
                      double *****iP2DM,
                      double *****RDM,
                      double *****iRDM);
void DIIS_Mixing_DM(int SCF_iter, double ******ResidualDM, double ******iResidualDM);
void GR_Pulay_DM(int SCF_iter, double ******ResidualDM);
void Kerker_Mixing_Rhok(int Change_switch,
                        double Mix_wgt,
                        double *****ReRhok,
                        double *****ImRhok,
                        double ****ReBestRhok,
                        double ****ImBestRhok,
                        double *****Residual_ReRhok,
                        double *****Residual_ImRhok,
                        double ***ReV1,
                        double ***ImV1,
                        double ***ReV2,
                        double ***ImV2,
                        double ***ReRhoAtomk,
                        double ***ImRhoAtomk);

void DIIS_Mixing_Rhok(int SCF_iter,
                      double Mix_wgt,
                      double *****ReRhok,
                      double *****ImRhok,
                      double ****ReBestRhok,
                      double ****ImBestRhok,
                      double *****Residual_ReRhok,
                      double *****Residual_ImRhok,
                      double ***ReV1,
                      double ***ImV1,
                      double ***ReV2,
                      double ***ImV2,
                      double ***ReRhoAtomk,
                      double ***ImRhoAtomk);
 
void Overlap_Cluster(double ****OLP, double **S,int *MP);
void Hamiltonian_Cluster(double ****RH, double **H, int *MP);
void Hamiltonian_Cluster_NC(double *****RH, double *****IH,
                            dcomplex **H, int *MP);
void Hamiltonian_Cluster_SO(double ****RH, double ****IH, dcomplex **H, int *MP);
void Hamiltonian_Band(int Host_ID1, double ****RH,
                      dcomplex **H, int *MP,
                      double k1, double k2, double k3);
void Hamiltonian_Band_NC(int Host_ID1, double *****RH, double *****IH,
                         dcomplex **H, int *MP,
                         double k1, double k2, double k3);
int Get_OneD_HS_Col(int set_flag, double ****RH, double *H1, int *MP, 
                    int *order_GA, int *My_NZeros, int *is1, int *is2);
void Overlap_Band(int Host_ID1, double ****OLP, dcomplex **S, int *MP,
                  double k1, double k2, double k3);
void IS_Lanczos(double ****OLP, double ****IOLP, int rlmax_IS);
void IS_Taylor(double ****OLP, double ****IOLP, int rlmax_IS);
void IS_Hotelling(double ****OLP, double ****IOLP, int rlmax_IS);
void IS_LU(double ****S0, double ****IOLP);

void Initial_CntCoes(double *****nh, double *****OLP);
double Opt_Contraction(double *****H,   double *****OLP,
                       double *****CDM, double *****EDM);
void Contract_Hamiltonian(double *****H,   double *****CntH,
                          double *****OLP, double *****CntOLP);
void Contract_iHNL(double *****iHNL, double *****iCntHNL);
void Cont_Matrix0(double ****Mat, double ****CMat);
void Cont_Matrix1(double ****Mat, double ****CMat);
void Cont_Matrix2(Type_DS_VNA ****Mat, Type_DS_VNA ****CMat);
void Cont_Matrix3(double ****Mat, double ****CMat);

double RecursionS_H(int SCF_iter,
                    double *****Hks,
                    double ****OLP0,
                    double *****CDM,
                    double *****EDM,
                    double Eele0[2], double Eele1[2]);

double Divide_Conquer(int SCF_iter,
                      double *****Hks,
                      double *****ImNL,
                      double ****OLP0,
                      double *****CDM,
                      double *****EDM,
                      double Eele0[2], double Eele1[2]);
double GDivide_Conquer(int SCF_iter,
                       double *****Hks,
                       double *****ImNL,
                       double ****OLP0,
                       double *****CDM,
                       double *****EDM,
                       double Eele0[2], double Eele1[2]);
double Krylov(int SCF_iter,
              double *****Hks,
              double *****ImNL,
              double ****OLP0,
              double *****CDM,
              double *****EDM,
              double Eele0[2], double Eele1[2]);
double Krylov_Dosout( double *****Hks,
		      double *****ImNL,
		      double ****OLP0 );
double Divide_Conquer_Dosout(double *****Hks,
                             double *****ImNL,
                             double ****OLP0);
double GDivide_Conquer_Dosout(double *****Hks,
                              double *****ImNL,
			      double ****OLP0);
void Gauss_Legendre(int n, double x[], double w[], int *ncof, int *flag);
void zero_cfrac(int n, dcomplex *zp, dcomplex *Rp );

double dampingF(double rcut, double r);
double deri_dampingF(double rcut, double r);

void xyz2spherical(double x, double y, double z,
                   double xo, double yo, double zo,
                   double S_coordinate[3]);
int RestartFileDFT(char *mode, int MD_iter, double *Uele, double *****H, double *****CntH);
void FT_PAO();
void FT_NLP();
void FT_ProExpn_VNA();
void FT_VNA();
void FT_ProductPAO();

double Poisson(int fft_charge_flag,
               double ***ReV1, double ***ImV1,
               double ***ReV2, double ***ImV2);

void FFT_Density(int den_flag,
                 double ***ReV1, double ***ImV1,
                 double ***ReV2, double ***ImV2);

void FFT_Poisson(int NG1, int NG2,
                 int Ng1, int Ng2,  int Ng3,
                 int My_Ng1, int My_Ng2,
                 int sgn1, int sgn2, int sgn3,
                 double ***ReF1, double ***ImF1,
                 double ***ReF2, double ***ImF2);

void Get_Value_inReal(int complex_flag,
                      double ***ReV2, double ***ImV2,
                      double ***ReV1, double ***ImV1,
                      double *Value_Grid, double *iValue_Grid);
double Set_Hamiltonian(char *mode,
                       int SCF_iter,
                       int SucceedReadingDMfile,
                       int Cnt_kind,
                       double *****H0,
                       double *****HNL,
                       double *****CDM,
                       double *****H);
double Total_Energy(int MD_iter, double *****CDM, double ECE[]);
double Force(double *****H0,
             double ******DS_NL, 
             double *****OLP,
             double *****CDM,
             double *****EDM); 
double Set_OLP_Kin(double *****OLP, double *****H0);
double Set_Nonlocal(double *****HNL, double ******DS_NL);
double Set_ProExpn_VNA(double ****HVNA, double *****HVNA2, Type_DS_VNA *****DS_VNA);
void Set_WbyVNA();
void Set_Vpot(int SCF_iter, int XC_P_switch, double *****CDM);
void Set_XC_Grid(int XC_P_switch, int XC_switch);
double Pot_NeutralAtom(int ct_AN, double Gx, double Gy, double Gz);
double XC_Ceperly_Alder(double den, int P_switch);
void XC_CA_LSDA(double den0, double den1, double XC[2],int P_switch);
void XC_PW91C(double dens[2], double Ec[1], double Vc[2]);
void XC_PBE(double dens[2], double GDENS[3][2], double Exc[2],
            double DEXDD[2], double DECDD[2],
            double DEXDGD[3][2], double DECDGD[3][2]);
void XC_EX(int NSP, double DS0, double DS[2], double EX[1], double VX[2]);
void Voronoi_Charge();
void Voronoi_Orbital_Moment();

void Make_ESM();
double Fuzzy_Weight(int ct_AN, int Rn, double x, double y, double z);

/*-----------------------------------------------------------------------*/


double readfile(char *argv[]);
void Input_std(char *filename);

int factorize(int num0, int N, int *fund, int *pow, int must );
double truncation(int MD_iter, int flag_GDC, int UCell_flag);
void Find_ApproxFactN(double tv[4][4],double *GEcut,
                      int *Ng1,int *Ng2,int *Ng3,
                      double *A2, double *B2, double *C2);
double DFT(int MD_iter, int Cnt_Now);
double Cluster_DFT(int SCF_iter,
                   int SpinP_switch,
                   double ***Cluster_ReCoes,
                   double **Cluster_ko,
                   double *****nh,
                   double *****ImNL,
                   double ****CntOLP,
                   double *****CDM,
                   double *****EDM,
                   double Eele0[2], double Eele1[2]);
double Cluster_DFT_Dosout( int SpinP_switch,
                           double *****nh,
                           double *****ImNL,
                           double ****CntOLP);

double Band_DFT_NonCol(int SCF_iter,
                       double *koS,
                       dcomplex **S,
                       int knum_i, int knum_j, int knum_k,
		       int SpinP_switch,
		       double *****nh,
		       double *****ImNL,
		       double ****CntOLP,
		       double *****CDM,
		       double *****EDM,
		       double Eele0[2], double Eele1[2]);

double Band_DFT_Col(int SCF_iter,
                    int knum_i, int knum_j, int knum_k,
		    int SpinP_switch,
		    double *****nh,
		    double *****ImNL,
		    double ****CntOLP,
		    double *****CDM,
		    double *****EDM,
		    double Eele0[2], 
                    double Eele1[2], 
		    int *MP,
		    int *order_GA,
		    double *ko,
		    double *koS,
		    double ***EIGEN,
		    double *H1,
		    double *S1,
		    double *CDM1,
		    double *EDM1,
		    dcomplex **H,
		    dcomplex **S,
		    dcomplex **C,
                    dcomplex *BLAS_S,
		    int ***k_op,
		    int *T_k_op,
		    int **T_k_ID,
		    double *T_KGrids1,
		    double *T_KGrids2,
		    double *T_KGrids3,
                    int myworld1,
		    int *NPROCS_ID1,
		    int *Comm_World1,
		    int *NPROCS_WD1,
		    int *Comm_World_StartID1,
		    MPI_Comm *MPI_CommWD1,
                    int myworld2,
		    int *NPROCS_ID2,
		    int *NPROCS_WD2,
		    int *Comm_World2,
		    int *Comm_World_StartID2,
		    MPI_Comm *MPI_CommWD2);

void k_inversion(int i,  int j,  int k, 
                 int mi, int mj, int mk, 
                 int *ii, int *ij, int *ik ); 
void Band_DFT_kpath( int nkpath, int *n_perk,
                     double ***kpath, char ***kname,
                     int SpinP_switch,
                     double *****nh,
                     double *****ImNL,
                     double ****CntOLP);
void Band_DFT_MO( int nkpoint, double **kpoint,
                  int SpinP_switch, 
                  double *****nh,
                  double *****ImNL,
                  double ****CntOLP);
double Band_DFT_Dosout( int knum_i, int knum_j, int knum_k,
                        int SpinP_switch,
                        double *****nh,
                        double *****ImNL,
                        double ****CntOLP );
double MD_pac(int iter);
int Species2int(char Species[YOUSO10]);
int R_atv(int CpyCell, int i, int j, int k);
int SEQ(char str1[YOUSO10], char str2[YOUSO10]);
void Generation_ATV(int CpyCell);
void iterout(int iter,double drctime,char fileE[YOUSO10],char fileDRC[YOUSO10]);
void outputfile1(int f_switch, int MD_iter, int orbitalOpt_iter,
                 int Cnt_Now, int SCF_iter, char fname[YOUSO10],
                 double ChemP_e0[2]);
void init();
void Find_CGrids(int Real_Position, int n1, int n2, int n3,
                 double Cxyz[4], int NOC[4]);
void Diamond_structure(double aa);
void HCP_structure(double aa, double coa);
void FCC_structure(double aa);
void SetPara_DFT();
void Output_CompTime();
void Merge_LogFile(char *file);
void Eigen_lapack(double **a, double *ko, int n, int EVmax);
void EigenBand_lapack(dcomplex **a, double *ko, int n);
void Eigen_PReHH(MPI_Comm MPI_Current_Comm_WD, 
                 double **ac, double *ko, int n, int EVmax, int bcast_flag);
void Eigen_PHH(MPI_Comm MPI_Current_Comm_WD, 
               dcomplex **ac, double *ko, int n, int EVmax, int bcast_flag);
void BroadCast_ReMatrix(MPI_Comm MPI_Curret_Comm_WD, 
                        double **Mat, int n, int *is1,int *ie1, int myid, int numprocs,
                        MPI_Status *stat_send,
                        MPI_Request *request_send,
                        MPI_Request *request_recv);
void BroadCast_ComplexMatrix(MPI_Comm MPI_Current_Comm_WD, 
                             dcomplex **Mat, int n, int *is1, int *ie1, int myid, int numprocs, 
                             MPI_Status *stat_send,
                             MPI_Request *request_send,
                             MPI_Request *request_recv);
void lapack_dstedc1(INTEGER N, double *D, double *E, double *W, double **ev);
void lapack_dstedc2(INTEGER N, double *D, double *E, double *W, dcomplex **ev);
void lapack_dstegr1(INTEGER N, INTEGER EVmax, double *D, double *E, double *W, double **ev);
void lapack_dstegr2(INTEGER N, INTEGER EVmax, double *D, double *E, double *W, dcomplex **ev);
void lapack_dstevx1(INTEGER N, INTEGER EVmax, double *D, double *E, double *W, double **ev);
void lapack_dstevx2(INTEGER N, INTEGER EVmax, double *D, double *E, double *W, dcomplex **ev);
void lapack_dsteqr1(INTEGER N, double *D, double *E, double *W, double **ev);

void LU_inverse(int n, dcomplex **a);
void ReLU_inverse(int n, double **a, double **ia);
void spline3(double r, double r1, double rcut,
             double g, double dg, double value[2]);
void Cswap(dcomplex *a, dcomplex *b);
void fnjoint(char name1[YOUSO10],char name2[YOUSO10],char name3[YOUSO10]);
void fnjoint2(char name1[YOUSO10], char name2[YOUSO10],
              char name3[YOUSO10], char name4[YOUSO10]);
void chcp(char name1[YOUSO10],char name2[YOUSO10]);
void Init_List_YOUSO();
void Allocate_Arrays(int wherefrom);
void Free_Arrays(int dokokara);
void OutData(char *inputfile);
void init_alloc_first();
int File_CntCoes(char *mode);
void SCF2File(char *mode, char *inputfile);
void Determine_Cell_from_ECutoff(double tv[4][4], double ECut);
void Spherical_Bessel( double x, int lmax, double *sb, double *dsb );

void Make_Comm_Worlds(
   MPI_Comm MPI_Current_Comm_WD,   
   int myid0,
   int numprocs0,
   int Num_Comm_World, 
   int *myworld1, 
   MPI_Comm *MPI_CommWD,     /* size: Num_Comm_World */
   int *NPROCS1_ID,          /* size: numprocs0 */
   int *Comm_World1,         /* size: numprocs0 */
   int *NPROCS1_WD,          /* size: Num_Comm_World */
   int *Comm_World_StartID   /* size: Num_Comm_World */
   );


 
/***********************  openmx_common.c  **************************/

void Cross_Product(double a[4], double b[4], double c[4]);
double Dot_Product(double a[4], double b[4]);
void ComplexSH(int l, int m, double theta, double phi,
               double SH[2], double dSHt[2], double dSHp[2]);
void asbessel(int n, double x, double sbe[2]);
double Gaunt(int l,int m,int l1,int m1,int l2,int m2);
void Associated_Legendre(int l, int m, double x, double ALeg[2]);
void qsort_double(long n, double *a, double *b);
void qsort_int(long n, int *a, int *b);
void GN2N(int GN, int N3[4]);
int AproxFactN(int N0);
void Get_Grid_XYZ(int GN, double xyz[4]);
double rnd(double width);
double rnd0to1(void);
double largest(double a, double b);
double smallest(double a, double b);
double Cabs(dcomplex z);
double sgn(double nu);
double isgn(int nu);
dcomplex Complex(double re, double im);
dcomplex Cadd(dcomplex a, dcomplex b);
dcomplex Csub(dcomplex a, dcomplex b);
dcomplex Cmul(dcomplex a, dcomplex b);
dcomplex Conjg(dcomplex z);
dcomplex Cdiv(dcomplex a, dcomplex b);
dcomplex Csqrt(dcomplex z);
dcomplex RCadd(double x, dcomplex a);
dcomplex RCsub(double x, dcomplex a);
dcomplex RCmul(double x, dcomplex a);
dcomplex CRmul(dcomplex a, double x);
dcomplex RCdiv(double x, dcomplex a);
dcomplex CRC(dcomplex a, double x, dcomplex b);
dcomplex Im_pow(int fu, int Ls);
dcomplex Csin(dcomplex a);
dcomplex Ccos(dcomplex a);
dcomplex Cexp(dcomplex a);

void PrintMemory_Fix();
void PrintMemory(char *name, size_t size0, char *mode);
void dtime(double *);
 
/****************************************************************/

void *malloc_multidimarray(char *type, int N, int *size);
void free_multidimarray(void **p,  int N, int *size);

/****************************************************************
           subroutines and common variables for MPI
****************************************************************/

/*******************************************************
 int *G2ID;
  G2ID gives a proccesor ID allocated to each atom
  with a global atom index.
  size: G2ID[atomnum+1];
  allocation: Allocation_Arrays(1) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *G2ID;

/*******************************************************
 int *Species_Top,*Species_End;
  arrays, Species_Top and Species_End, give global
  indices of the first and last species in species
  allocated to each processor.
  size: Species_Top[numprocs],Species_End[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Species_Top,*Species_End;

/*******************************************************
 int *F_Snd_Num;

  F_Snd_Num gives the number of atoms of which informations,
  related by FNAN, are transfered from myid to ID.
  size: F_Snd_Num[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *F_Snd_Num;

/*******************************************************
 int *S_Snd_Num;

  S_Snd_Num gives the number of atoms of which informations,
  related by SNAN, are transfered from myid to ID.
  size: S_Snd_Num[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *S_Snd_Num;

/*******************************************************
 int *F_Rcv_Num;

  F_Rcv_Num gives the number of atoms of which informations,
  related by FNAN, are recieved at myid from ID.
  size: F_Rcv_Num[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *F_Rcv_Num;

/*******************************************************
 int *S_Rcv_Num;

  S_Rcv_Num gives the number of atoms of which informations,
  related by SNAN, are recieved at myid from ID.
  size: S_Rcv_Num[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *S_Rcv_Num;

/*******************************************************
 int *Snd_DS_NL_Size;

  Snd_DS_NL_Size gives the size of data for DS_NL
  which are transfered from myid to ID.
  size: Snd_DS_NL_Size[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Snd_DS_NL_Size;

/*******************************************************
 int *Rcv_DS_NL_Size;

  Rcv_DS_NL_Size gives the size of data for DS_NL
  which are received from ID.
  size: Rcv_DS_NL_Size[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Rcv_DS_NL_Size;

/*******************************************************
 int *F_TopMAN,*S_TopMAN;

  F_TopMAN and S_TopMAN give the first medium
  atom number in atoms sent from ID in the size of
  F_Rcv_Num[ID] and F_Rcv_Num[ID] + S_Rcv_Num[ID],
  respectively.
  size: F_TopMAN[numprocs],S_TopMAN[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *F_TopMAN,*S_TopMAN;

/*******************************************************
 int *F_G2M,*S_G2M;

  F_G2M and S_G2M give a conversion from the
  global atom number to the medium atom number
  for atoms sent from ID in the size of
  F_Rcv_Num[ID] and F_Rcv_Num[ID] + S_Rcv_Num[ID],
  respectively. 
  size: F_G2M[atomnum+1],S_G2M[atomnum+1]
  allocation: Allocation_Arrays(1) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *F_G2M,*S_G2M;

/*******************************************************
 int **Snd_MAN;
  Snd_MAN is a medium atom index of which informations
  are sent to a processor ID.
  size: Snd_MAN[numprocs][FS_Snd_Num[ID]]
  allocation: Set_Inf_SndRcv() of truncation.c
  free:       Set_Inf_SndRcv() of truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Snd_MAN;

/*******************************************************
 int **Snd_GAN;
  Snd_GAN is a global atom index of which informations
  are sent to a processor ID.
  size: Snd_GAN[numprocs][FS_Snd_Num[ID]]
  allocation: Set_Inf_SndRcv() of truncation.c
  free:       Set_Inf_SndRcv() of truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Snd_GAN;

/*******************************************************
 int **Rcv_GAN;
  Rcv_GAN is a global atom index of which informations
  are recieved at myid from a processor ID.
  size: Rcv_GAN[numprocs][F_Rcv_Num[ID]+S_Rcv_Num[ID]]
  allocation: Set_Inf_SndRcv() of truncation.c
  free:       Set_Inf_SndRcv() of truncation.c
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Rcv_GAN;

/*******************************************************
 int *My_Cell0
  My_Cell0 gives a flag for the grids of a-axis that
  a processor ID has to know.
  size: My_Cell0[Ngrid1];
  allocation: in allocate_grids2atoms() of truncation.c
  free:       in allocate_grids2atoms() of truncation.c  
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *My_Cell0;

/*******************************************************
 int *My_Cell1
  My_Cell1 gives the global grids of a-axis that
  a processor ID has to know.
  size: My_Cell1[Num_Cells0];
  allocation: in allocate_grids2atoms() of truncation.c
  free:       in allocate_grids2atoms() of truncation.c  
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *My_Cell1;

/*******************************************************
 int *Cell_ID0
  Cell_ID0 gives a processor ID which computes electron
  densities on the grids of a-axis.
  size: Cell_ID0[Ngrids1];
  allocation: in allocate_grids2atoms() of truncation.c
  free:       in allocate_grids2atoms() of truncation.c  
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Cell_ID0;

/*******************************************************
 int *edge_block
  edge_block specifies the boundoury cell of My_Cell0
  size: edge_block[Ngrids1];
  allocation: in allocate_grids2atoms() of truncation.c
  free:       in allocate_grids2atoms() of truncation.c  
              and call as Free_Arrays(0) in openmx.c
*******************************************************/
int *edge_block;

/*******************************************************
 int *Start_Grid1,*End_Grid1;

  Start_Grid1 and End_Grid1 give the first and final grid
  numbers of the a-axis allocated to a processor ID.
  size: Start_Grid1[numprocs],End_Grid1[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Start_Grid1,*End_Grid1;

/*******************************************************
 int *Start_Grid2,*End_Grid2;

  Start_Grid1 and End_Grid1 give the first and final grid
  numbers of the b-axis allocated to a processor ID.
  size: Start_Grid1[numprocs],End_Grid1[numprocs]
  allocation: Allocation_Arrays(0) in Input_std()
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Start_Grid2,*End_Grid2;

/*******************************************************
 int *Num_Rcv_Grid1;

  Num_Rcv_Grid1 gives the number of grids on the a-axis
  for myid to recieve from ID.
  size: Num_Rcv_Grid1[numprocs];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_Rcv_Grid1;

/*******************************************************
 int *Num_Snd_Grid1;

  Num_Snd_Grid1 gives the number of grids on the a-axis
  for myid to send to ID.
  size: Num_Snd_Grid1[numprocs];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_Snd_Grid1;

/*******************************************************
 int **Rcv_Grid1;

  Rcv_Grid1 gives the grids on the a-axis for myid to
  recieve from ID.
  size: Rcv_Grid1[numprocs][Num_Rcv_Grid1[ID]];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Rcv_Grid1;

/*******************************************************
 int **Snd_Grid1;

  Snd_Grid1 gives the grids on the a-axis for myid to
  send to ID.
  size: Snd_Grid1[numprocs][Num_Snd_Grid1[ID]];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Snd_Grid1;

/*******************************************************
 int *Num_IRcv_Grid1;

  Num_IRcv_Grid1 gives the number of grids on the a-axis
  for myid to recieve from ID for converting Poisson's
  grid to atom's grid.
  size: Num_IRcv_Grid1[numprocs];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_IRcv_Grid1;

/*******************************************************
 int *Num_ISnd_Grid1;

  Num_ISnd_Grid1 gives the number of grids on the a-axis
  for myid to send to ID for converting Poisson's
  grid to atom's grid.
  size: Num_ISnd_Grid1[numprocs];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_ISnd_Grid1;

/*******************************************************
 int **IRcv_Grid1;

  IRcv_Grid1 gives the grids on the a-axis for myid to
  recieve from ID for converting Poisson's grid to
  atom's grid.
  size: IRcv_Grid1[numprocs][Num_IRcv_Grid1[ID]];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **IRcv_Grid1;

/*******************************************************
 int **ISnd_Grid1;

  ISnd_Grid1 gives the grids on the a-axis for myid to
  send to ID for converting Poisson's grid to atom's grid.
  size: ISnd_Grid1[numprocs][Num_ISnd_Grid1[ID]];
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **ISnd_Grid1;

/*******************************************************
 int *TopMAN2_Grid;

  TopMAN2_Grid gives the first medium grid number in grids
  sent from ID in the size of Num_Rcv_FNAN2_Grid[ID].
  size: TopMAN2_Grid[numprocs]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *TopMAN2_Grid;

/*******************************************************
 int *Rcv_FNAN2_MN

  Rcv_FNAN2_MN gives a medium grid number sent
  in terms of FNAN2
  size: Rcv_FNAN2_MN[numprocs]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Rcv_FNAN2_MN;

/*******************************************************
 int *Num_Rcv_FNAN2_Grid

  Num_Rcv_FNAN2_Grid gives the number of grids for myid 
  to recieve from ID in terms of FNAN2.
  size: Num_Rcv_FNAN2_Grid[numprocs]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_Rcv_FNAN2_Grid;

/*******************************************************
 int *Num_Snd_FNAN2_Grid

  Num_Snd_FNAN2_Grid gives the number of grids for myid 
  to send to ID in terms of FNAN2.
  size: Num_Snd_FNAN2_Grid[numprocs]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Num_Snd_FNAN2_Grid;

/*******************************************************
 int *Rcv_FNAN2_GA

  Rcv_FNAN2_GA gives the global atom number which are
  sent from the other IDs in terms of FNAN2.
  size: Rcv_FNAN2_GA[FNAN2_Grid]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int *Rcv_FNAN2_GA;

/*******************************************************
 int **Snd_FNAN2_At

  Snd_FNAN2_At gives the global atom number which are sent
  from myid to ID in terms of FNAN2.

  size: Snd_FNAN2_At[numprocs][Num_Snd_FNAN2_Grid[ID]]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Snd_FNAN2_At;

/*******************************************************
 int **Snd_FNAN2_Nc

  Snd_FNAN2_Nc gives the medium grid number which are sent
  from myid to ID in terms of FNAN2.

  size: Snd_FNAN2_Nc[numprocs][Num_Snd_FNAN2_Grid[ID]]
  allocation: allocate_grids2atoms() in truncation.c
  free:       allocate_grids2atoms() and
              call as Free_Arrays(0) in openmx.c
*******************************************************/
int **Snd_FNAN2_Nc;

/*******************************************************
 double *time_per_atom; 
  elapsed time which is required for each atom
  size: time_per_atom[atomnum+1]
  allocation: call as Allocate_Arrays(1) in Input_std.c
  free:       call as Free_Arrays(0) in openmx.c
*******************************************************/
double *time_per_atom;

int Matomnum,MatomnumF,MatomnumS,Matomnum_GDC;
int MSpeciesNum,Num_Procs,Num_Procs2;
int Num_Cells0,My_NumGrid1,FNAN2_Grid;
int My_NGrid1_Poisson,My_NGrid2_Poisson;

void setup_CPU_group(char *file);
int Set_Allocate_Atom2CPU(int MD_iter, int isw, int NL_switch);
