// $Id: CDImageCLI.cc 7731 2008-04-03 19:58:10Z m9710797 $

#include "CDImageCLI.hh"
#include "CommandController.hh"
#include "CommandLineParser.hh"
#include "TclObject.hh"
#include "MSXException.hh"

using std::deque;
using std::string;

namespace openmsx {

CDImageCLI::CDImageCLI(CommandLineParser& commandLineParser)
	: commandController(commandLineParser.getCommandController())
{
	commandLineParser.registerOption("-cda", *this);
	// TODO: offer more options in case you want to specify 2 hard disk images?
}

bool CDImageCLI::parseOption(const string& option, deque<string>& cmdLine)
{
	string cd = option.substr(1); // cda
	string filename = getArgument(option, cmdLine);
	if (!commandController.hasCommand(cd)) { // TODO WIP
		throw MSXException("No CDROM named '" + cd + "'.");
	}
	TclObject command(commandController.getInterpreter());
	command.addListElement(cd);
	command.addListElement(filename);
	command.executeCommand();
	return true;
}
const string& CDImageCLI::optionHelp() const
{
	static const string text("Use iso image in argument for the CDROM extension");
	return text;
}

} // namespace openmsx
