// $Id: MSXWatchIODevice.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef MSXWATCHIODEVICE_HH
#define MSXWATCHIODEVICE_HH

#include "MSXMultiDevice.hh"
#include "WatchPoint.hh"

namespace openmsx {

class MSXWatchIODevice : public MSXMultiDevice, public WatchPoint
{
public:
	MSXWatchIODevice(MSXMotherBoard& motherboard,
	                 WatchPoint::Type type,
	                 unsigned beginAddr, unsigned endAddr,
	                 std::auto_ptr<TclObject> command,
	                 std::auto_ptr<TclObject> condition);
	virtual ~MSXWatchIODevice();

	MSXDevice*& getDevicePtr();

	// MSXDevice
	virtual std::string getName() const;
	virtual byte readIO(word port, EmuTime::param time);
	virtual byte peekIO(word port, EmuTime::param time) const;
	virtual void writeIO(word port, byte value, EmuTime::param time);

private:
	MSXDevice* device;
};

} // namespace openmsx

#endif
