// $Id: Pluggable.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef PLUGGABLE_HH
#define PLUGGABLE_HH

#include "EmuTime.hh"
#include "noncopyable.hh"
#include <string>

namespace openmsx {

class Connector;

class Pluggable : private noncopyable
{
public:
	Pluggable();
	virtual ~Pluggable();

	/** Name used to identify this pluggable.
	  */
	virtual const std::string& getName() const;

	/** A pluggable belongs to a certain class. A pluggable only fits in
	  * connectors of the same class.
	  */
	virtual const std::string& getClass() const = 0;

	/** Description for this pluggable.
	  */
	virtual const std::string& getDescription() const = 0;

	/** This method is called when this pluggable is inserted in a
	 * connector.
	 * @throws PlugException
	 */
	void plug(Connector& connector, EmuTime::param time);

	/** This method is called when this pluggable is removed from a
	  * conector.
	  */
	void unplug(EmuTime::param time);

	/** Get the connector this Pluggable is plugged into. Returns a NULL
	  * pointer if this Pluggable is not plugged.
	  */
	Connector* getConnector() const;

protected:
	virtual void plugHelper(Connector& newConnector, EmuTime::param time) = 0;
	virtual void unplugHelper(EmuTime::param time) = 0;

	friend class Connector; // for de-serialization
	void setConnector(Connector* conn);

private:
	Connector* connector;
};

} // namespace openmsx

#endif
