// $Id: Pluggable.cc 8352 2008-11-12 18:39:08Z m9710797 $

#include "Pluggable.hh"
#include "PlugException.hh"
#include "Connector.hh"
#include <cassert>

using std::string;

namespace openmsx {

Pluggable::Pluggable()
{
	setConnector(NULL);
}

Pluggable::~Pluggable()
{
}

const string& Pluggable::getName() const
{
	static const string name("--empty--");
	return name;
}

void Pluggable::plug(Connector& newConnector, EmuTime::param time)
{
	assert(getClass() == newConnector.getClass());

	if (connector) {
		throw PlugException(getName() + " already plugged in " +
		                    connector->getName() + ".");
	}
	plugHelper(newConnector, time);
	setConnector(&newConnector);
}

void Pluggable::unplug(EmuTime::param time)
{
	unplugHelper(time);
	setConnector(NULL);
}

Connector* Pluggable::getConnector() const
{
	return connector;
}

void Pluggable::setConnector(Connector* conn)
{
	connector = conn;
}

} // namespace openmsx
