# $Id: components2code.py 9288 2009-02-28 18:48:24Z mthuurne $
# Creates the components header file.

from components import iterComponents
from makeutils import extractMakeVariables
from outpututils import rewriteIfChanged

import sys

def iterComponentsHeader(probeMakePath):
	probeVars = extractMakeVariables(probeMakePath)
	buildComponents = set(
		component.makeName
		for component in iterComponents()
		if component.canBuild(probeVars)
		)

	yield '// Automatically generated by build process.'
	yield ''
	yield '#ifndef COMPONENTS_HH'
	yield '#define COMPONENTS_HH'
	yield ''
	yield '#include <string>'
	yield ''
	for component in iterComponents():
		varName = component.makeName
		if varName in buildComponents:
			yield '#define COMPONENT_%s 1' % varName
		else:
			yield '// #undef COMPONENT_%s' % varName
	yield ''
	yield 'namespace openmsx {'
	yield ''
	yield 'static const std::string BUILD_COMPONENTS = "%s";' \
		% ' '.join(sorted(buildComponents))
	yield ''
	yield '} // namespace openmsx'
	yield ''
	yield '#endif // COMPONENTS_HH'

if __name__ == '__main__':
	if len(sys.argv) == 3:
		rewriteIfChanged(sys.argv[1], iterComponentsHeader(sys.argv[2]))
	else:
		print >> sys.stderr, (
			'Usage: python components2code.py COMPONENTS_HEADER PROBE_MAKE'
			)
		sys.exit(2)
