/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;


import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;



import javax.swing.DefaultRowSorter;
import javax.swing.JTable;

import javax.swing.JOptionPane;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;

import javax.swing.event.RowSorterEvent.Type;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

import javax.swing.table.TableColumnModel;

import javax.swing.table.TableRowSorter;

import xmlObjects.VtEnv;

import help.Config;
import help.Pair;
import help.Text;

/***
 * 
 * @author Mathias Korepkat
 *
 */

/**
 * SymbolGroupTable inherits from JTable. It manages Symbols and can be used to move symbols to Groups or give them an limit.
 */
public class SymbolGroupTable extends javax.swing.JTable{	

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	private Text mytext = null;
	private DefaultTableModel tModel = new DefaultTableModel(){
		/**
		 * generated VersionUID
		 */
		private static final long serialVersionUID = 5469460752334558774L;

		public boolean isCellEditable(int rowIndex, int vColIndex) { 
			if(vColIndex == 3)
				return false; 
			else 
				return false; }
	};
	private MySorter sorter = new MySorter();
	RowSorterListener l = new RowSorterListener(){

		public void sorterChanged(RowSorterEvent e) {
			
			if(sorter.getSortKeys().size() != 0)
				if(e.getType() == Type.SORT_ORDER_CHANGED)
				{
					switch(view)
					{
						case GENERAL_VIEW:reorder_general();break;
						case GROUP_VIEW:reorder_group();break;
						case FILTER_VIEW:reorder_filter();break;
						default :;
					}		
				}
		}
	};
	public MySymbolTableRenderer c = new MySymbolTableRenderer();
	
	public ArrayList<String> hideGroups = new ArrayList<String>();
	private DefaultGroups defGroups = null;	
	private TableColumnModel genCol = new DefaultTableColumnModel(); 
	private TableColumnModel grpCol = new DefaultTableColumnModel();
	private TableColumnModel fltCol = new DefaultTableColumnModel();
	
	
	private boolean[] avail = {false,false,false};
	private ArrayList<String> hiddenExecs = new ArrayList<String>();
	private ArrayList<String> hiddenLibs = new ArrayList<String>();
	private ArrayList<String> shownGroups = new ArrayList<String>();
	private ArrayList<String> hiddenGrps = new ArrayList<String>();
	
	DefaultTableModel newExecModel = new DefaultTableModel();
	DefaultTableModel newLibModel = new DefaultTableModel();
	DefaultTableModel newOwnModel = new DefaultTableModel();
	
	public static final int GENERAL_VIEW=1;
	public static final int GROUP_VIEW = 2;
	public static final int FILTER_VIEW = 3;
	private int view = GENERAL_VIEW; 
	
	private RowFilter<Object,Object> curentFilter = RowFilter.regexFilter("", 1);
	private boolean isFiltering = false;
	public boolean executablesLoded = false;
	public boolean simbolIsSet = false;
	
	private String FilterFile = "";
	private String GroupFile = "";
	
	private boolean autoGrp = false;
	
	//Key: Symbol-name first char g=group s=symbol
	public HashMap<String,Integer> entries = new HashMap<String,Integer>(); //maps symbols to its index
	public HashMap<String,Pair<Integer,String>> changed = new HashMap<String,Pair<Integer,String>>(); //maps symbols to its index when something changed
	
	
	/***
	 * initialization 
	 */
	public SymbolGroupTable(Text mytext){
		this.mytext = mytext;
		this.setModel(tModel);
		confTableModel();
	}
	
	/***
	 * set {@link DefaultGroups DefaultGroups}
	 * @param grp DefaultGroups to order added Symbols to this groups if necessary
	 */
	public void setDefGroups(DefaultGroups grp)
	{
		this.defGroups = grp;
	}
	
	/***
	 * initialize tableModel, columnModels, rowsorter and MouseListener for this component
	 */
	private void confTableModel()
	{ 	     
		
		tModel.addColumn(mytext.getText("symTab_Col_system"));
		tModel.addColumn(mytext.getText("symTab_Col_name"));
		tModel.addColumn(mytext.getText("symTab_Col_type"));
		tModel.addColumn(mytext.getText("symTab_Col_call"));
		tModel.addColumn(mytext.getText("symTab_Col_group"));
		
		genCol.addColumn(this.getColumn(mytext.getText("symTab_Col_name")));
		
		grpCol.addColumn(this.getColumn(mytext.getText("symTab_Col_name")));
		grpCol.addColumn(this.getColumn(mytext.getText("symTab_Col_group")));
		fltCol.addColumn(this.getColumn(mytext.getText("symTab_Col_name")));
		fltCol.addColumn(this.getColumn(mytext.getText("symTab_Col_call")));
		
		String[] data = {"_system","Executable"};
		tModel.addRow(data);
		data[0] = "nsystem";
		data[1] = "Extra Symbols";
		tModel.addRow(data);
		sorter.setModel(tModel);
		sorter.setComparator(0, new myStringComparator());
		sorter.setComparator(2, new myStringComparator());
		sorter.setComparator(3, new myStringComparator());
		sorter.setComparator(4, new myStringComparator());
		sorter.setComparator(1, new myStringComparator());
		
		sorter.addRowSorterListener(l);
		ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
		keys.add(new RowSorter.SortKey(0,SortOrder.ASCENDING)); //order by group
		keys.add(new RowSorter.SortKey(2,SortOrder.ASCENDING)); //order libs
	    sorter.setSortKeys(keys);
		this.setRowSorter(sorter);
		this.setDefaultRenderer(Object.class, c);
		this.addMouseListener(new MouseListener(){


			public void mouseClicked(MouseEvent e) {
				
				if(((JTable)e.getSource()).isEnabled())
				{
					if(view == GENERAL_VIEW)
					{
						filter(tModel.getValueAt(sorter.convertRowIndexToModel(((JTable)e.getSource()).getSelectedRow()),1).toString(),((JTable)e.getSource()).getSelectedRow());
					}
					
					if(view == FILTER_VIEW)
					{
						if(tModel.getValueAt(sorter.convertRowIndexToModel(((JTable)e.getSource()).getSelectedRow()),0).toString().equals("agrp") &&
								((JTable)e.getSource()).getSelectedColumn() != 1	
						)
							setFltFilter(tModel.getValueAt(sorter.convertRowIndexToModel(((JTable)e.getSource()).getSelectedRow()),1).toString());
					}
				}
			}

			public void mouseEntered(MouseEvent arg0) {;}

			public void mouseExited(MouseEvent e) {;}


			public void mousePressed(MouseEvent e) {;}


			public void mouseReleased(MouseEvent e) {;}
			
		});
		
	}

	
	/***
	 * Set the view of the table
	 * @param view you can set view to GENERAL_VIEW, GROUP_VIEW or FILTER_VIEW
	 */
	public void setView(int view)
	{
		this.view = view;
		c.setView(view);
		ArrayList<RowFilter<Object,Object>> filters = new ArrayList<RowFilter<Object,Object>>();
		
		if(view == GENERAL_VIEW)
		{
			if(this.getColorModel() != genCol)
			this.setColumnModel(genCol);
		}
		
		if(view == GROUP_VIEW)
		{
			
			filters.add(RowFilter.regexFilter(" ",0));
			filters.add(RowFilter.regexFilter("group",0));
			filters.add(RowFilter.regexFilter("exec",0));
			filters.add(RowFilter.regexFilter("own",0));
			filters.add(RowFilter.regexFilter("9$",2));
			
			if(this.getColorModel() != grpCol)
				this.setColumnModel(grpCol);
		}
		
		if(view == FILTER_VIEW)
		{
			filters.add(RowFilter.regexFilter(" ",0));
			filters.add(RowFilter.regexFilter("group",0));
			filters.add(RowFilter.regexFilter("exec",0));
			filters.add(RowFilter.regexFilter("own",0));
			filters.add(RowFilter.regexFilter("9$",2));
			if(this.getColorModel() != fltCol)
				this.setColumnModel(fltCol);
			
			hiddenGrps.clear();
			((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenGrps.clear();
		}
		
		
		if(filters.size() == 0)
			sorter.setRowFilter(null);
		else
		{
			RowFilter<Object,Object> fooBarFilter = RowFilter.orFilter(filters);
			sorter.setRowFilter(fooBarFilter);
		}
		 
	}
	

	/***
	 * Change the row sorter in general view
	 */
	public void reorder_general()
	{
		sorter.removeRowSorterListener(l); //remove sortListener to avoid that sorthandles are fired
		RowSorter.SortKey key = new RowSorter.SortKey(0,SortOrder.ASCENDING);
		 if(!sorter.getSortKeys().isEmpty() && !sorter.getSortKeys().get(0).equals(key))
		 {
			 ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
		     keys.add(key); //order by group
		     keys.add(new RowSorter.SortKey(2,SortOrder.ASCENDING));
		     keys.add( sorter.getSortKeys().get(0)); //order by order
		     sorter.setSortKeys(keys);	     
		    
		 }

		sorter.addRowSorterListener(l);		//reset sortorder
	}
	
	/***
	 * Change the row sorter in group view
	 */
	public void reorder_group()
	{

		sorter.removeRowSorterListener(l); //remove sortListener to avoid that sorthandles are fired
		
		RowSorter.SortKey key = new RowSorter.SortKey(3,SortOrder.ASCENDING);
		 if(!sorter.getSortKeys().get(0).equals(key))
		 {
			 ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
		     keys.add(key); //order by group
		     keys.add( sorter.getSortKeys().get(0)); //order by order
		     sorter.setSortKeys(keys);	     
		    
		 }

		sorter.addRowSorterListener(l);		//reset sortorder
	}
	
	/***
	 * Change the row sorter in filter view
	 */
	public void reorder_filter()
	{
		sorter.removeRowSorterListener(l); //remove sortListener to avoid that sorthandles are fired
		
		RowSorter.SortKey key = new RowSorter.SortKey(4,SortOrder.ASCENDING);
		 if(!sorter.getSortKeys().get(0).equals(key))
		 {
			 ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
		     keys.add(key); //order by group
		     keys.add(new RowSorter.SortKey(0,SortOrder.ASCENDING));
		     keys.add( sorter.getSortKeys().get(0)); //order by order
		     sorter.setSortKeys(keys);	     
		    
		 }
	
		sorter.addRowSorterListener(l);		//reset sortorder
	}
	
	/***
	 * this method is used by the mouseListener and hides or shows entrys in the table 
	 * @param filter String that represents the libraries that are shown or hidden
	 * @param row row that is clicked by the mouse
	 */
	public void filter(String filter,int row)
	{
		if(view == GENERAL_VIEW)
		{	
			ArrayList<RowFilter<Object,Object>> filters = new ArrayList<RowFilter<Object,Object>>();
			RowFilter<Object,Object> fooBarFilter = null;
			String type = "";

			if(filter != null)
			{
				if(tModel.getValueAt(sorter.convertRowIndexToModel(row), 2) != null)
					type = tModel.getValueAt(sorter.convertRowIndexToModel(row), 2).toString();
				if(view == GENERAL_VIEW)
				{
					if(filter.equals("Executable"))
					{
						if( avail[0])
							avail[0]=false;
						else
							avail[0]=true;
					}
					
					if(filter.equals("libraries"))
					{
						if( avail[1])
							avail[1]=false;
						else
							avail[1]=true;
					}
					
					if(filter.equals("Extra Symbols"))
					{
						if( avail[2])
							avail[2]=false;
						else
							avail[2]=true;
					}
					
					
					if(tModel.getValueAt(sorter.convertRowIndexToModel(row), 0).toString().trim().equals("lib") && type != null && !type.trim().equals(""))
					{
						if(!hiddenLibs.contains(filter))
						{
							hiddenLibs.add(filter);
							((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenLibs.add(filter);
						}
						else
						{
							hiddenLibs.remove(filter);
							((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenLibs.remove(filter);
						}
					}
					
					
					if(tModel.getValueAt(sorter.convertRowIndexToModel(row), 0).toString().trim().equals("exec") && type != null && !type.trim().equals(""))
					{
						
						if(!hiddenExecs.contains(filter))
						{
							hiddenExecs.add(filter);
							((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenExecs.add(filter);
						}
						else
						{
							hiddenExecs.remove(filter);
							((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenExecs.remove(filter);
						}
					}
				}
			}
									
				if(avail[0])
					filters.add(RowFilter.regexFilter("exec",0));
				if(avail[1])
					filters.add(RowFilter.regexFilter("lib",0));
				if(avail[2])
					filters.add(RowFilter.regexFilter("own",0));
				
				filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*",0)));
				
				for(int i=0;i<hiddenLibs.size();i++)
				{
					filters.add(RowFilter.regexFilter("^"+hiddenLibs.get(i).replaceAll("\\*", "\\\\*")+"ABC9999$",2));
				}
				for(int i=0;i<hiddenExecs.size();i++)
				{
					filters.add(RowFilter.regexFilter("^"+hiddenExecs.get(i).replaceAll("\\*", "\\\\*")+"ABC9999$",2));
				}
					
				((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).avail = avail;
					
				if(filters.size() != 0)
					fooBarFilter = RowFilter.notFilter(RowFilter.orFilter(filters));
			
		
			if(isFiltering)
			{

				
				filters.clear();
		
				filters.add(curentFilter);
				filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*system",0)));
				fooBarFilter = RowFilter.andFilter(filters);
				
			
				
			}
	
			
				filters.clear();		
		//		filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*system",0)));
				filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*8$",2)));
				for(int i=0;i<hideGroups.size();i++)
				{
					filters.add(RowFilter.notFilter(RowFilter.regexFilter(hideGroups.get(i),4)));	
				}
				
				
				if(fooBarFilter != null)
					filters.add(fooBarFilter);
				
				fooBarFilter = RowFilter.andFilter(filters);
			sorter.setRowFilter(fooBarFilter);
		}
	}
	
	/***
	 * this method is used to Filter all entries that are only used in Group view
	 * @param (String) objects String array that represents the groups that are shown or hidden
	 * 
	 */
	public void setGrpFilter(Object[] objects)
	{
		if(view == GROUP_VIEW)
		{
			RowFilter<Object,Object> fooBarFilter = null;
			ArrayList<RowFilter<Object,Object>> filters = new ArrayList<RowFilter<Object,Object>>();
			
			if(objects != null)
			{
				shownGroups.clear();
				for(int i=0;i<objects.length;i++)
				{
					if(!hideGroups.contains((String) objects[i]))
						shownGroups.add((String) objects[i]);
				}
			}
			
			for(int i=0;i<shownGroups.size();i++)
			{
				filters.add(RowFilter.regexFilter(shownGroups.get(i)+"$",4));
			}
			
			if(filters.size() != 0)
				fooBarFilter = RowFilter.orFilter(filters);
			
			
			if(isFiltering)
			{
				filters.clear();
				filters.add(curentFilter);
				
				if(fooBarFilter != null)
					filters.add(fooBarFilter);
				fooBarFilter = RowFilter.andFilter(filters);
			}
			
			
			
			filters.clear();
			filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*system",0)));
			filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*8$",2)));
			for(int i=0;i<hideGroups.size();i++)
			{
				filters.add(RowFilter.notFilter(RowFilter.regexFilter(hideGroups.get(i),4)));	
			}
			
			
			if(fooBarFilter != null)
				filters.add(fooBarFilter);
			
			fooBarFilter = RowFilter.andFilter(filters);
			sorter.setRowFilter(fooBarFilter);
		}
	}
		
	/***
	 * this method is used to Filter all entries that are only used in Filter view
	 * @param filter String that represents the groups that are shown or hidden
	 */
	public void setFltFilter(String filter)
	{
		if(view == FILTER_VIEW)
		{
			RowFilter<Object,Object> fooBarFilter = null;
			ArrayList<RowFilter<Object,Object>> filters = new ArrayList<RowFilter<Object,Object>>();
			ArrayList<RowFilter<Object,Object>> filters2 = new ArrayList<RowFilter<Object,Object>>();
			
			
			
			if(filter != null)
			{
				if(!hiddenGrps.contains(filter))
				{
					hiddenGrps.add(filter);
					((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenGrps.add(filter);
				}
				else
				{
					hiddenGrps.remove(filter);
					((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenGrps.remove(filter);
				}
			}
			
			for(int i=0;i<hiddenGrps.size();i++)
			{
				filters2.add(RowFilter.regexFilter(hiddenGrps.get(i).replaceAll("\\*", "\\\\*")+"$",4));
				filters2.add(RowFilter.notFilter(RowFilter.regexFilter("agrp",0)));
				filters.add(RowFilter.notFilter(RowFilter.andFilter(filters2)));
				filters2.clear();
			}
			
			if(filters.size() != 0)
				fooBarFilter = RowFilter.andFilter(filters);
			
			
			
			if(isFiltering)
			{
				filters.clear();		
				
				
				filters.add(curentFilter);
				filters.add(RowFilter.notFilter(RowFilter.regexFilter("agrp", 0)));
				fooBarFilter = RowFilter.andFilter(filters);
			}
			
			filters.clear();
			if(fooBarFilter != null)
				filters.add(fooBarFilter);
			
			fooBarFilter = RowFilter.andFilter(filters);	
			filters.clear();
			filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*system",0)));
			filters.add(RowFilter.notFilter(RowFilter.regexFilter(".*8$",2)));
			for(int i=0;i<hideGroups.size();i++)
			{
				filters.add(RowFilter.notFilter(RowFilter.regexFilter(hideGroups.get(i),4)));	
			}
			
			
			if(fooBarFilter != null)
				filters.add(fooBarFilter);
			
			fooBarFilter = RowFilter.andFilter(filters);
			sorter.setRowFilter(fooBarFilter);
		}
		
	}	
	
	/***
	 * method hide all entries that are only used by the general view
	 */
	public void remGrpFilter()
	{
		shownGroups.clear();
		ArrayList<RowFilter<Object,Object>> filters = new ArrayList<RowFilter<Object,Object>>();
		filters.add(RowFilter.regexFilter(" ",0));
		filters.add(RowFilter.regexFilter("group",0));
		filters.add(RowFilter.regexFilter("exec",0));
		filters.add(RowFilter.regexFilter("own",0));
		filters.add(RowFilter.regexFilter("lib",0));
		RowFilter<Object,Object> fooBarFilter = RowFilter.orFilter(filters);
		
		filters.clear();
		filters.add(fooBarFilter);
		filters.add(RowFilter.notFilter(RowFilter.regexFilter("8$",2)));
		fooBarFilter = RowFilter.andFilter(filters);
		((DefaultRowSorter<?, ?>) this.getRowSorter()).setRowFilter(fooBarFilter);
	}
		
	/**
	 * method adds a symbol to the Table
	 * @param name name of the symbol
	 */
	public void addRow(String name)
	{
		if(!defGroups.compgroups.containsKey(DefaultGroups.trimSymbol(name)) && defGroups.isAllowed(name))
				addRow(name,defGroups.getGroup(name));
	}

	/**
	 * method adds a symbol to the Table
	 * @param name name of the symbol
	 * @param group name of the group
	 */
	public void addRow(String name,String group)
	{
		if(!entries.containsKey("s"+name.trim()) && !entries.containsKey("l"+name.trim()) && !entries.containsKey("g"+name.trim()) && defGroups.isAllowed(name))
		{
			this.setRowSorter(null);
			boolean addthis = true;
			if(group.equals(""))
				group = defGroups.getGroup(name.trim());
			String[] Data = {"own",name.trim(),"","",group.trim()};
			
			
			
			try{
				for(int i=0;i<tModel.getRowCount();i++)
				{
					if(tModel.getValueAt(i, 1).equals(name.trim()) &&
					  (tModel.getValueAt(i, 0).equals("own") ||
					   tModel.getValueAt(i, 0).equals("lib") ||
					   tModel.getValueAt(i, 0).equals("exec")
					  ))
						addthis=false;
				}
				
				if(addthis)
				{
					if(!simbolIsSet)
						simbolIsSet=true;
					
					tModel.addRow(Data);
					int index = tModel.getRowCount()-1;
					if(Data[2].endsWith("8"))
						entries.put("l"+Data[1], index);
					else
					{
						entries.put("s"+Data[1], index);
						changed.put("s"+Data[1], new Pair<Integer,String>(index,"add"));
					}
				}
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}

			this.setRowSorter(sorter);
			sorter.sort();
		}
	}
	
	/**
	 * method adds a symbol to the Table
	 * @param name name of the symbol
	 * @param group name of the group
	 * @param system internal value to document what kind of element it is.
	 */
	public void addRow(String name,String group,String system)
	{
		
		if(!entries.containsKey("s"+name) && !entries.containsKey("l"+name) && !entries.containsKey("g"+name) && (defGroups.isAllowed(name) || system.equals("agrp")))
		{
			this.setRowSorter(null);
			boolean addthis=true;
			if(group.equals(""))
				group = defGroups.getGroup(name);
			String[] Data = {system.trim(),name.trim(),"","",group.trim()};
			String isGroup="s";
			if(system.equals("agrp"))
				isGroup="g";
			try{
				for(int i=0;i<tModel.getRowCount();i++)
				{
					if(tModel.getValueAt(i, 1).equals(name) &&
					  (tModel.getValueAt(i, 0).equals("own") ||
					   tModel.getValueAt(i, 0).equals("lib") ||
					   tModel.getValueAt(i, 0).equals("exec") ||
					   tModel.getValueAt(i, 0).equals("grp")
					  ))
						addthis=false;
				}
				
				if(addthis)
				{
					if(!simbolIsSet)
						simbolIsSet=true;
					
					tModel.addRow(Data);
					int index = tModel.getRowCount()-1;
					if(Data[2].endsWith("8"))
						entries.put("l"+Data[1], index);
					else
					{
						entries.put(isGroup+Data[1], index);
						if(!system.trim().endsWith("system"))
							changed.put(isGroup+Data[1], new Pair<Integer,String>(index,"add"));
					}
				}
			}catch(Exception e)
			{
				Config.errorHandler(e);
			}

			this.setRowSorter(sorter);
			sorter.sort();
		}
	}
	
	/**
	 * method adds a symbol to the Table
	 * @param name name of the symbol
	 * @param group name of the group
	 * @param system internal value to document what kind of element it is.
	 * @param libtype library type, used to get the tree structure in general view for libraries 
	 */
	public void addRow(ArrayList<String> name,ArrayList<String> group,ArrayList<String> system, ArrayList<String> libtype)
	{
		this.setRowSorter(null);
		String[] Data = {"","","","",""};
		String isGroup = "s";

		
		try{
			
			for(int i=0;i<name.size();i++)
			{

				if((entries.containsKey("s"+name.get(i).trim()) || entries.containsKey("l"+name.get(i).trim()) || entries.containsKey("g"+name.get(i).trim()))
				   || (!defGroups.isAllowed(name.get(i)) && !system.get(i).equals("agrp"))
				   )
				{
					name.remove(i);
					group.remove(i);
					system.remove(i);
					libtype.remove(i);
					i--;
				}
			}
			String prefix = "";
			for(int i=0;i<name.size();i++)
			{
				Data[0] = system.get(i).trim();
				Data[1] = name.get(i).trim();
				Data[2] = libtype.get(i).trim();
				Data[4] = group.get(i).trim();
				prefix = getPrefix(Data[1],Data[0]);
				
				if(Data[2].equals("") && this.autoGrp && !prefix.equals(""))
				{
					Data[2] = prefix+"ABC9999";
				}
				if(Data[4].trim().equals(""))
					Data[4] = defGroups.getGroup(Data[1]);
				tModel.addRow(Data);
				if(!simbolIsSet)
					simbolIsSet=true;
				
				int myindex = tModel.getRowCount()-1;
				if(Data[2].endsWith("8"))
					entries.put("l"+Data[1], myindex);
				else
				{
					
					if(Data[0].equals("agrp"))
						isGroup="g";
					else
						isGroup="s";
					entries.put(isGroup+Data[1], myindex);
					if(!Data[0].trim().endsWith("system"))
					changed.put(isGroup+Data[1], new Pair<Integer,String>(myindex,"add"));
				
					if(!prefix.equals("")&&!entries.containsKey("l"+prefix)&& this.autoGrp)
					{
						String[] data = {Data[0],prefix,prefix+"ABC9998","",""};
						tModel.addRow(data);
						if(!entries.containsKey("l"+prefix.toString()))
							entries.put("l"+prefix, tModel.getRowCount()-1);
						 hiddenExecs.add(prefix);
						((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenExecs.add(prefix);
					}
					
				}
			}
			
		}catch(Exception e)
		{
			Config.errorHandler(e);
		}
		
	//	sorter.setModel(tModel);
		this.setRowSorter(sorter);
		sorter.sort();
	}
	
	/***
	 * method returns all groups 
	 * @return List of all Groups in the table
	 */
	public ArrayList<String> getGroups()
	{
		ArrayList<String> groups = new ArrayList<String>();
		for(int i=0;i<tModel.getRowCount();i++)
		{
			if(tModel.getValueAt(i, 4) != null && !groups.contains(tModel.getValueAt(i, 4).toString()) 
			&& (tModel.getValueAt(i, 2) == null || !tModel.getValueAt(i, 2).toString().trim().endsWith("8"))		
			)
				groups.add(tModel.getValueAt(i, 4).toString());
		}
		return groups;
	}
	
	/***
	 * method counts for every group the symbols
	 * @return Hashtable <String, Integer> with the groupname as String key and the count of Symbols in this group as value
	 */
	public Hashtable<String,Integer> countGroupElements(boolean advanced)
	{
		Hashtable<String,Integer> groups = new Hashtable<String, Integer>();
		int count;
		String group ="";
		for(int i=0;i<tModel.getRowCount();i++)
			{
				
				if(tModel.getValueAt(i, 4) != null && (tModel.getValueAt(i, 2) == null || !tModel.getValueAt(i, 2).toString().trim().endsWith("8")))
				{
					group = tModel.getValueAt(i, 4).toString();
					group.trim();
					if(!groups.containsKey(group) && !hideGroups.contains(group))
						groups.put(group, 1);
					else
					{
						if(!hideGroups.contains(group))
						{
							count = groups.get(group);
							count++;
							groups.remove(group);
							groups.put(group, count);
						}
					}
				}
					
			}
		
		return groups;
	}
	
	/***
	 * method is used to find entries in the table
	 * @param searchkey String that is searched for
	 */
	public void find(String searchkey)
	{
		if(searchkey == null || searchkey.trim().equals("**"))
		{
			isFiltering = false;
			c.setSearch("");
		}
		else
		{
			
			searchkey = searchkey.replaceAll("\\*", ".*");
			curentFilter = RowFilter.regexFilter("(?i)"+searchkey, 1);

			isFiltering = true;
			c.setSearch(searchkey);
			//this.requestFocus();
		}
		
		if(view == GENERAL_VIEW)
			filter(null,0);
		 if(view == GROUP_VIEW)
			 setGrpFilter(null);
		 if(view == FILTER_VIEW)
			 setFltFilter(null);
	}
	
	/***
	 * repaints this element
	 */
	public void repaintTable()
	{
		this.setRowSorter(null);
		sorter.setModel((DefaultTableModel) tModel);
		this.setRowSorter(sorter);
	}
	/***
	 * empties the table
	 */
	public void clear()
	{
		this.setRowSorter(null);
		tModel.setRowCount(0);
		changed.clear();
		entries.clear();
		this.setRowSorter(sorter);
	}


	/***
	 * sets the GrpFile path
	 * @param file path to an existing group file
	 */
	public void setGrpFile(String file)
	{
		this.GroupFile = file;
		getSymbolsFromGrpFile();
	}

	/***
	 * sets the FilterFile path
	 * @param file path to an existing group file
	 */
	public void setFilterFile(String file)
	{
		this.FilterFile = file;
		getSymbolsFromFilterFile();
	}
	
	/***
	 * parses a GroupFile and add Symbols to table
	 */
	private  void getSymbolsFromGrpFile()
	{
		try{
			File file = new File(GroupFile);
			if(file.isFile())
				{
				BufferedReader reader = new BufferedReader(new FileReader(file));	
				String line = null;
				String group = "";
				 ArrayList<String> system = new ArrayList<String>();
				 ArrayList<String> name = new ArrayList<String>();
				 ArrayList<String> libtype = new ArrayList<String>();
				 ArrayList<String> group1 = new ArrayList<String>();
				 while ((line=reader.readLine()) != null) {
					 line.trim();
					 if(line.startsWith("#"))
						 continue;
					 if(line.contains("="))
					 {
						 group = line.substring(0,line.indexOf("="));
						 line = line.substring(line.indexOf("=")+1);
						 
						 String[] symbols = line.split(";");
						 for(int i=0;i<symbols.length;i++)
						 {
							 if(!symbols[i].trim().equals("") && 
								(symbols[i].contains("\\*")|| !symbols[i].contains("*"))
							   )
							 {
								 if(!defGroups.compgroups.containsKey(DefaultGroups.trimSymbol(symbols[i])))
								 {
									   system.add("own");
									   name.add(symbols[i].trim());
									   libtype.add("");
									   group1.add(group.trim());
								 }
								 else
								 {
									 Pair<String,String> helpName = defGroups.compgroups.get(DefaultGroups.trimSymbol(symbols[i]));
									 tModel.setValueAt(group.trim(), entries.get("s"+helpName.getLeft()), 4);
									 
								 }
							 }
							 
						 }
						 addRow(name, group1, system, libtype);
					 }
				 }
				reader.close();
			}
		}catch(Exception e)
		{
			Config.errorHandler(e);
		}
	}
	
	/***
	 * parses a FilterFile and add Symbols to table
	 */
	private  void getSymbolsFromFilterFile()
	{
		try{
			File file = new File(FilterFile);
			if(file.isFile())
			{
				BufferedReader reader = new BufferedReader(new FileReader(file));	
				String line = null;
				   ArrayList<String> system = new ArrayList<String>();
				   ArrayList<String> name = new ArrayList<String>();
				   ArrayList<String> libtype = new ArrayList<String>();
				   ArrayList<String> group = new ArrayList<String>();
				 while ((line=reader.readLine()) != null) {
					 line.trim();
					 if(line.startsWith("#"))
						 continue;
					
					 if(line.contains("--"))
					 {
						 line = line.substring(0,line.indexOf("--"));
						 
						 String[] symbols = line.split(";");
						 for(int i=0;i<symbols.length;i++)
							 if(!symbols[i].trim().equals("") && 
							   (symbols[i].contains("\\*")|| !symbols[i].contains("*"))
							   )
							 {
								 if(!defGroups.compgroups.containsKey(DefaultGroups.trimSymbol(symbols[i])))
								 {
								   system.add("own");
								   name.add(symbols[i].trim());
								   libtype.add("");
								   group.add("");
							 	  }
								  
							 }
					 }
				 }
				 addRow(name, group, system, libtype);
				reader.close();
			}
		}catch(Exception e)
		{
			Config.errorHandler(e);
		}
	}
	
	/***
	 * extract symbols from executable with nm
	 * @param file name of the executable
	 */
	public  void getSymbolsFromExecutable(String file,String type,boolean first)
	{
		try{
				//tModel.getValueAt(0, column)
			if((type.equals("exec") && VtEnv.executableAnswer == 2))
			{
				;
			}
			else
			{
			//remove existing executables 
			if(type.equals("exec") && VtEnv.executableAnswer == 0)
			{
				RowSorter r = this.getRowSorter();
				this.setRowSorter(null);
				for(int i=0;i<tModel.getRowCount();i++)
				{
					if(tModel.getValueAt(i, 0).toString().trim().equals(type.trim()))
					{
						String symbol = "s"+tModel.getValueAt(i, 1).toString();
						changed.put(symbol, new Pair<Integer, String>(i,"rm"));
						
						for (Map.Entry<String,Integer> entry : entries.entrySet())
						{
							if(entry.getValue().intValue() > entries.get(symbol).intValue())
								 entries.put(entry.getKey(), entry.getValue()-1);
						}
						entries.remove(symbol);
						tModel.removeRow(i);
						i--;
					}
				}
				this.setRowSorter(r);
			}
			   Process p = Runtime.getRuntime().exec(VtEnv.nm+" "+file);  
			   if(p.getErrorStream().available() == 0)
			   {
				   BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));   
				   String line="";
				   String lib = "";
				   String na="";
				   String[] regioninfo;
				   int index = 0;
				   ArrayList<String> system = new ArrayList<String>();
				   ArrayList<String> name = new ArrayList<String>();
				   ArrayList<String> libtype = new ArrayList<String>();
				   ArrayList<String> group = new ArrayList<String>();
				   String  Symbname="";
				   
				   while ((line = br.readLine()) != null) {  
					 	 line = line.replaceAll("\t", " ");
					   while(line.contains("  "))
					    	 line = line.replaceAll("  ", " ");
					    
					   regioninfo = line.split(" ");
					   
					   if(regioninfo.length>= 3)
					   {
						   if(!"st".contains(regioninfo[1].toLowerCase().trim()))
							   continue;
						   Symbname = regioninfo[2];
					   }else{
						   if(!"st".contains(regioninfo[0].toLowerCase().trim()))
							   continue;
						   Symbname = regioninfo[1];
					   }

					   index = Symbname.indexOf("(");
						   
					    if(index > 0)
						Symbname = Symbname.substring(0,index);
						   
						if(!defGroups.compgroups.containsKey(DefaultGroups.trimSymbol(Symbname)) &&
						   !( regioninfo[2].contains("@@") &&
							  defGroups.compgroups.containsKey(DefaultGroups.trimSymbol(Symbname.substring(0,Symbname.indexOf("@@"))))
							 )
						   )
						   {
							   
							   if(regioninfo[2].contains("@@"))
							   {
								   lib = regioninfo[2].substring(Symbname.lastIndexOf("@@")+2);
								   na = regioninfo[2].substring(0,Symbname.indexOf("@@"));
								   lib = lib.trim();
								   na = na.trim();
								   
								   if(!(name.contains(na) && libtype.get(name.indexOf(na)).trim().equals(lib+"ABC9999")))
								   {
									   system.add(type);
									   name.add(na);
									   libtype.add("");
									   group.add("");
								   }
							   }
							   else
							   {
								   if(!(name.contains(Symbname) && libtype.get(name.indexOf(Symbname)).trim().equals("")))
								   {
									   system.add(type);
									   name.add(Symbname);
									   libtype.add("");
									   group.add("");
								   }
							   }
						   }
				   		}
				   
				   addRow(name, group, system, libtype);
				   
				   br.close();
			   }else{
				   if(!first)
					   JOptionPane.showMessageDialog(null, "Nm can't get symbol information from this executable!");
			   }
			}
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}
	}
	/***
	 * help method to extract a prefix for auto grouping
	 * @param name name of the symbol
	 * @param system value to make a difference of libraries symbols from executables and values used to format the entries
	 * @return returns a String that represent a prefix of the symbol or "" if no prefix is possible 
	 */
	private String getPrefix(String name, String system)
	{
		String prefix = "";
		int index=0;
		if(!this.autoGrp)
			return "";
		if(system.equals("exec"))
		{   
			name = name.toString().trim();
			index = name.indexOf("::");
			if(index > 0)
			{
				prefix = name.substring(0,index).trim();

				return prefix;
			}
			index = name.indexOf("_");
			if(index > 0)
			{
				prefix = name.substring(0,index).trim();
				return prefix;
			}
		}
		return "";
	}
	
	/***
	 * 
	 * MySorter inherits from TableRowSorter and is used to sort the table.
	 *
	 */
	public class MySorter extends TableRowSorter<DefaultTableModel>{


		/***
		 * Sorts and filters the rows in the view based on the sort keys of the columns currently being sorted and the filter,
		 * if any, associated with this sorter. An empty sortKeys list indicates that the view should unsorted, the same as the model. 
		 */
		@Override
		public void sort() {
			super.sort();
		}
		
		/***
		 * Invoked when rows have been changed in the underlying model between the specified range (inclusive). 
		 *  You normally do not call this method. This method is public to allow view classes to call it. 
		 */
		public void rowsInserted(int firstRow, int endRow) {
			int newModelRowCount = getModelWrapper().getRowCount();
			if (endRow >= newModelRowCount) {
				throw new IndexOutOfBoundsException("Invalid range");
			}
		}
		
		/***
		 * overwriting rowsUpdated to avoid exceptions
		 */
		public void rowsUpdated(int firstRow, int endRow) {;}
	}
	
	/****
	 * Comparator for the sorter class to sort alphabetically and
	 * make a difference of upper and lower case.
	 */
	class myStringComparator implements Comparator<String> {

	    /***
	     *  Comparator interface requires defining compare method.
	     */
	    public int compare(String valueA, String valueB) {
	        return valueA.compareTo(valueB); 
	    }
	}

	public void FiltCollapseExpand() {
		
		if(!hiddenGrps.isEmpty())
			hiddenGrps.clear();
		else
			hiddenGrps =  getGroups();
		((MySymbolTableRenderer)this.getDefaultRenderer(Object.class)).hiddenGrps = hiddenGrps;
		 setFltFilter(null);
		
	}
	
   /****
    * Hide default Groups
    */
	public void hideDefaultStandardGroups(boolean val)
	{
		ArrayList<String> groups = getGroups();
		if(defGroups != null)
		if(val)
		{
			for(int i=0;i<groups.size();i++)
			{
				if(defGroups.isDefaultGroup(groups.get(i)) && !groups.get(i).equals(DefaultGroups.DEFAULTGROUP))
				{
					hideGroups.add(groups.get(i));
				}
			}
		}else
		{
			for(int i=0;i<groups.size();i++)
			{
				if(defGroups.isDefaultGroup(groups.get(i)) && !defGroups.equals(DefaultGroups.DEFAULTGROUP))
				{
					hideGroups.remove(groups.get(i));
				}
			}
		}
	}
}
