/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import java.awt.event.MouseEvent;

import xmlObjects.VtEnv;


/***
 * Class to handle Mouse events to show informations in the toolTip box
 * 
 */
public class myMouseListener implements java.awt.event.MouseListener
{

		private String text = "";
		VtEnv env = null;
		
		/***
		 * set JEditorPane  to show messages in it
		 * @param toolTip JEditorPane were the text should be shown
		 */
		public void setToolTip(VtEnv env)
		{
			this.env = env;
		}
		
		
		/***
		 * set the text that should be shown in the toolTip
		 * @param text text that should be shown
		 */
		public void setText(String text)
		{
			this.text = text;
		}
		
		/***
		 * overwriting mouseClicked event with nothing
		 * @param e MouseEvent that is detected
		 */
		public void mouseClicked(MouseEvent e) {;}

		/***
		 * overwriting mouseEntered event with showing the {@link #setText(String) text} that was set
		 * @param e MouseEvent that is detected
		 */
		public void mouseEntered(MouseEvent e) {				
			
			env.ToolTipView.setText(text);
			if(env.getToolTip().getComponent(0) != env.ToolTipView)
			{
	        	env.getToolTip().removeAll();
        		env.getToolTip().add(env.ToolTipView);
			}
		}
		
		/***
		 * overwriting mouseExited event with the restoring the old text
		 * @param e MouseEvent that is detected
		 */
		public void mouseExited(MouseEvent e) {
			//toolTip.setText(this.old_text);
		}

		/***
		 * overwriting mousePressed event with nothing
		 * @param e MouseEvent that is detected
		 */
		public void mousePressed(MouseEvent e) {;}

		/***
		 * overwriting mouseReleased event with nothing
		 * @param e MouseEvent that is detected
		 */
		public void mouseReleased(MouseEvent e) {;}
		
	};