/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.Map;

import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class TestCacheModeInvalid extends AbstractCacheTestCase {

    private static OpenJPAEntityManagerFactorySPI emf = null;
    
    @Override
    public void setUp() {}
    
    public void testInvalidElement() {
        boolean exceptionCaught = false;
        try {
            Map<String, Object> propertiesMap = getPropertiesMap("openjpa.DataCache", "true",
                "openjpa.QueryCache", "true",
                "openjpa.RemoteCommitProvider", "sjvm", persistentTypes, 
                "openjpa.jdbc.JDBCListeners", new JDBCListener [] { getListener() });
            emf = (OpenJPAEntityManagerFactorySPI) OpenJPAPersistence.createEntityManagerFactory("cache-mode-invalid",
                "META-INF/caching-persistence-invalid.xml", propertiesMap );
        } catch (Throwable e) {
            exceptionCaught = true;
            assertException(e, org.apache.openjpa.util.GeneralException.class);
            String msg = e.getMessage();
            assertTrue(msg.contains("org.xml.sax.SAXException"));
        }
        assertTrue(exceptionCaught);
    }

    @Override
    public OpenJPAEntityManagerFactorySPI getEntityManagerFactory() {
        return null;
    }

    @Override
    public JDBCListener getListener() {
        return null;
    }
 
}
