/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_VIRTUAL_MACHINE_P_H_
#define _GTLCORE_VIRTUAL_MACHINE_P_H_

#include <GTLCore/Export.h>

namespace llvm {
  class GlobalVariable;
  class Module;
  class Function;
  class ExecutionEngine;
}

class DeleteVirtualMachineDeleter;

namespace GTLCore {
  class Function;
  class Value;
  /**
   * @internal
   * This is a private class to GTLCore. It gives access to the JIT/Interpreter.
   *
   * Since there can be only one instance of the JIT/Interpreter, you are not
   * allowed to instantiate this class. Instead you should use
   * \ref VirtualMachine::instance() .
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT VirtualMachine {
    friend class ::DeleteVirtualMachineDeleter;
    private:
      VirtualMachine();
      ~VirtualMachine();
    public:
      /**
       * Regiser a module to the Virtual Machine. The Virtual Machine takes
       * ownership of the Module unless the function
       * \ref unregisterModule is called.
       */
      void registerModule( llvm::Module* );
      /**
       * Unregister a module from the Virtual Machine. Deleting the module
       * and the module provider is up to the caller of this function
       */
      void unregisterModule( llvm::Module* );
      /**
       * @return a pointer to the function
       */
      void *getPointerToFunction(llvm::Function *F);
      /**
       * @param _nbParameters the number of parameters
       * @return a pointer to the function
       */
      void *getPointerToFunction(Function *F);
      void* getGlobalVariablePointer( llvm::GlobalVariable* _pointer);
#if 0
      /**
       * Set the value of a global variable.
       * @param _pointer "pointer" to the global variable
       * @param _value new value
       */
      void setGlobalVariable( llvm::GlobalVariable* _pointer, const GTLCore::Value& _value);
      /**
       * Give access to the value of a global variable.
       * @param _pointer "pointer" to the global variable
       * @return the value of the variable
       */
      GTLCore::Value getGlobalVariable( llvm::GlobalVariable *V);
#endif
      llvm::ExecutionEngine* executionEngine();
    public:
      /**
       * @return the singleton of the \ref VirtualMachine
       */
      static VirtualMachine* instance();
      static void setOptimizationLevel(int v);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
