/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OpenShiva/Source.h"

class TestSource : public GTLTest::Case {
  public:
    TestSource() : GTLTest::Case("Source") {}
    virtual void runTest()
    {
      {
        GTLCore::String sourceCodeGenerator = "\
  kernel myGenerator { \
    void evaluatePixel(out pixel result) \
    { } \
  }";
        OpenShiva::Source sourceGenerator;
        sourceGenerator.setSource(sourceCodeGenerator);
        GTLTEST_CHECK_EQUAL( sourceGenerator.source(), sourceCodeGenerator );
        GTLTEST_CHECK_EQUAL( sourceGenerator.name(), "myGenerator" );
        GTLTEST_CHECK_EQUAL( sourceGenerator.metadataCompilationErrors().size(), 0 );
        GTLTEST_CHECK_EQUAL( sourceGenerator.sourceType(), OpenShiva::Source::GeneratorKernel );
        GTLTEST_CHECK_EQUAL( sourceGenerator.outputImageType(), OpenShiva::Source::Image );
        GTLTEST_CHECK_EQUAL( sourceGenerator.countInputImages(), 0 );
        GTLTEST_CHECK_EQUAL( sourceGenerator.inputImageType(0), OpenShiva::Source::InvalidImage );
      }
      {
        GTLCore::String sourceCodeFilter = "\
  kernel myFilter { \
    float length( float2 v) \
    { \
      v *= v; \
      return sqrt( v[0] + v[1] ); \
    } \
    void evaluatePixel(image2 im1, out pixel3 result) \
    { \
      im1 = result; \
    } \
    region changed(region changed_input_region, int input_index, region input_DOD[]) \
    { \
      return changed_input_region; \
    } \
  }";
        OpenShiva::Source sourceFilter;
        sourceFilter.setSource(sourceCodeFilter);
        GTLTEST_CHECK_EQUAL( sourceFilter.source(), sourceCodeFilter );
        GTLTEST_CHECK_EQUAL( sourceFilter.name(), "myFilter" );
        GTLTEST_CHECK_EQUAL( sourceFilter.metadataCompilationErrors().size(), 0 );
        GTLTEST_CHECK_EQUAL( sourceFilter.sourceType(), OpenShiva::Source::FilterKernel );
        GTLTEST_CHECK_EQUAL( sourceFilter.outputImageType(), OpenShiva::Source::Image3 );
        GTLTEST_CHECK_EQUAL( sourceFilter.countInputImages(), 1 );
        GTLTEST_CHECK_EQUAL( sourceFilter.inputImageType(0), OpenShiva::Source::Image2 );
        GTLTEST_CHECK_EQUAL( sourceFilter.inputImageType(1), OpenShiva::Source::InvalidImage );
      }
    }
};

