/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_PROGRESS_REPORT_H_
#define _GTLCORE_PROGRESS_REPORT_H_

#include <GTLCore/Export.h>

namespace GTLCore {
  /**
   * @ingroup GTLCore
   * This class allow to get feedback on the processing of data by @ref OpenShiva::Kernel or
   * @ref OpenCTL::Program .
   */
  class GTLCORE_EXPORT ProgressReport {
    public:
      ProgressReport();
      virtual ~ProgressReport();
      /**
       * It is called when accessing a new row
       */
      virtual void nextRow() = 0;
      /**
       * It is called when accessing a new pixel
       */
      virtual void nextPixel() = 0;      
      /**
       * @return true if the processing has been interrupted and should be stopped.
       * (as of 0.9.12 it is not used)
       */
      virtual bool interrupted() const = 0;
    private:
      struct Private;
      const Private* d;
  };
};

#endif
