/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareInstallationService.h"
#include "OpenDRIM_SoftwareInstallationServiceAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderSetInstance SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderModifyInstance
#endif

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_init(const CMPIBroker* broker);

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SoftwareInstallationService> instances;
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SoftwareInstallationService> instances;
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareInstallationService instance;
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareInstallationService newInstance, oldInstance;
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, ci, newInstance);
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareInstallationService instance;
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareInstallationService instance;
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareInstallationService instance;
	SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"SystemCreationClassName", "Name", "SystemName", "CreationClassName"};
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_SoftwareInstallationService_RequestStateChange_In inArgs;
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, in, inArgs);
		OpenDRIM_SoftwareInstallationService_RequestStateChange_Out outArgs;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StartService") {
		unsigned int returnValue;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_StartService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StopService") {
		unsigned int returnValue;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_StopService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="CheckSoftwareIdentity") {
		unsigned int returnValue;
		OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_In inArgs;
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, in, inArgs);
		OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_Out outArgs;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="InstallFromSoftwareIdentity") {
		unsigned int returnValue;
		OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_In inArgs;
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, in, inArgs);
		OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_Out outArgs;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="InstallFromURI") {
		unsigned int returnValue;
		OpenDRIM_SoftwareInstallationService_InstallFromURI_In inArgs;
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(_broker, in, inArgs);
		OpenDRIM_SoftwareInstallationService_InstallFromURI_Out outArgs;
		
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_InstallFromURI(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareUpdate_OpenDRIM_SoftwareInstallationService_init FAILED: " + (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationService_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = SoftwareUpdate_OpenDRIM_SoftwareInstallationService_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareUpdate_OpenDRIM_SoftwareInstallationService_unload FAILED: " + (string) OpenDRIM_SoftwareInstallationService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define SoftwareUpdate_OpenDRIM_SoftwareInstallationService_INIT if (SoftwareUpdate_OpenDRIM_SoftwareInstallationService_init(_broker) < 0) return NULL

CMInstanceMIStub(SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProvider, SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProvider, _broker, SoftwareUpdate_OpenDRIM_SoftwareInstallationService_INIT);
CMMethodMIStub(SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProvider, SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceProvider, _broker, SoftwareUpdate_OpenDRIM_SoftwareInstallationService_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
