/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PCIDeviceControlledByPCIPort.h"

CMPIObjectPath* PCI_OpenDRIM_PCIDeviceControlledByPCIPort_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PCIDeviceControlledByPCIPort& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PCIDeviceControlledByPCIPort_classnames[0], OpenDRIM_PCIDeviceControlledByPCIPort_NAMESPACE);

	if (!instance.Antecedent_isNULL)
		op.addKey("Antecedent", instance.Antecedent);

	if (!instance.Dependent_isNULL)
		op.addKey("Dependent", instance.Dependent);

	_L_;
	return op.getHdl();
}

CMPIInstance* PCI_OpenDRIM_PCIDeviceControlledByPCIPort_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PCIDeviceControlledByPCIPort& instance) {
	_E_;
	Objectpath op(broker, PCI_OpenDRIM_PCIDeviceControlledByPCIPort_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.NegotiatedSpeed_isNULL)
		ci.setProperty("NegotiatedSpeed", instance.NegotiatedSpeed);

	if (!instance.NegotiatedDataWidth_isNULL)
		ci.setProperty("NegotiatedDataWidth", instance.NegotiatedDataWidth);

	if (!instance.AccessState_isNULL)
		ci.setProperty("AccessState", instance.AccessState);

	if (!instance.TimeOfDeviceReset_isNULL)
		ci.setPropertyDatetime("TimeOfDeviceReset", instance.TimeOfDeviceReset);

	if (!instance.NumberOfHardResets_isNULL)
		ci.setProperty("NumberOfHardResets", instance.NumberOfHardResets);

	if (!instance.NumberOfSoftResets_isNULL)
		ci.setProperty("NumberOfSoftResets", instance.NumberOfSoftResets);

	if (!instance.DeviceNumber_isNULL)
		ci.setProperty("DeviceNumber", instance.DeviceNumber);

	if (!instance.AccessMode_isNULL)
		ci.setProperty("AccessMode", instance.AccessMode);

	if (!instance.AccessPriority_isNULL)
		ci.setProperty("AccessPriority", instance.AccessPriority);

	_L_;
	return ci.getHdl();
}

void PCI_OpenDRIM_PCIDeviceControlledByPCIPort_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PCIDeviceControlledByPCIPort& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (op.getKey("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_PCIDeviceControlledByPCIPort_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PCIDeviceControlledByPCIPort& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (inst.getProperty("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	if (inst.getProperty("NegotiatedSpeed", instance.NegotiatedSpeed) == OK)
		instance.NegotiatedSpeed_isNULL = false;

	if (inst.getProperty("NegotiatedDataWidth", instance.NegotiatedDataWidth) == OK)
		instance.NegotiatedDataWidth_isNULL = false;

	if (inst.getProperty("AccessState", instance.AccessState) == OK)
		instance.AccessState_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfDeviceReset", instance.TimeOfDeviceReset) == OK)
		instance.TimeOfDeviceReset_isNULL = false;

	if (inst.getProperty("NumberOfHardResets", instance.NumberOfHardResets) == OK)
		instance.NumberOfHardResets_isNULL = false;

	if (inst.getProperty("NumberOfSoftResets", instance.NumberOfSoftResets) == OK)
		instance.NumberOfSoftResets_isNULL = false;

	if (inst.getProperty("DeviceNumber", instance.DeviceNumber) == OK)
		instance.DeviceNumber_isNULL = false;

	if (inst.getProperty("AccessMode", instance.AccessMode) == OK)
		instance.AccessMode_isNULL = false;

	if (inst.getProperty("AccessPriority", instance.AccessPriority) == OK)
		instance.AccessPriority_isNULL = false;

	_L_;
}

