<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// *** Note assumes that config.php variables have been defined ***
// *** This must be assumed so that the configuration variables ***
// *** can actually be defined somewhere in begin.inc.php, but  ***
// *** we do not have to care about where...

include_once("./functions/language.php");
include_once("./functions/utils.php");

// This is the main language.php script, which will
// be used to include the appropriate language file
// based on session information or a default language
// definition.

if($CONFIG_VARS['login.user_language_support']!==FALSE && is_legal_language($HTTP_SESSION_VARS['user_language']))
	$_OPENDB_LANGUAGE = $HTTP_SESSION_VARS['user_language'];
else
{
	if(is_legal_language($CONFIG_VARS['site.language']))
		$_OPENDB_LANGUAGE = $CONFIG_VARS['site.language'];
	else // This is the final default.
		$_OPENDB_LANGUAGE = "english";
}

// Backwards compatible
$language = $_OPENDB_LANGUAGE;

include("./lang/english.inc.php");
if($_OPENDB_LANGUAGE != 'english')
{
	include("./lang/".$_OPENDB_LANGUAGE.".inc.php");
}

// allows customisations at language level to be maintained between releases.
// Do not try to customise arrays.
if(file_exists("./lang/local.".$_OPENDB_LANGUAGE.".inc.php"))
{
	include_once("./lang/local.".$_OPENDB_LANGUAGE.".inc.php");
}

// All language packs should still work without modification.
if(is_not_empty_array($lang_var))
{
	// array_merge_recursive was added to PHP 4.0.1, so we need to make sure it
	// exists before trying to use it.
	if(is_not_empty_array($LANG_VARS) && function_exists('array_merge_recursive'))
		$LANG_VARS =& array_merge_recursive($lang_var, $LANG_VARS);
	else
		$LANG_VARS =& $lang_var;
}
?>
