<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/item_attribute.php");
include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/item_type.php");
include_once("./functions/item.php");
include_once("./functions/user.php");
include_once("./functions/import.php");
include_once("./functions/importcache.php");
include_once("./functions/parseutils.php");
include_once("./functions/ItemImportHandler.class.inc");
include_once("./functions/HTML_Listing.class.inc");

function get_item_id_range($item_id_r)
{
	$item_id_range = '';
	$start_item_id = NULL;
	$last_item_id = NULL;
	if(is_array($item_id_r))
	{
		for($i=0; $i<count($item_id_r); $i++)
		{
			$new_id = $item_id_r[$i];
			
			if($last_item_id !== NULL)
			{
				// If the new_id, has jumped a number, we need to close range, and start again
				if( ($last_item_id+1) < $new_id)
				{
					// If we actually have a range, of at least one.
					if($start_item_id < $last_item_id)
					{
						$item_id_range .= $start_item_id.'-'.$last_item_id.',';
					}
					else if(is_numeric($start_item_id))
					{
						$item_id_range .= $start_item_id.',';
					}
					$start_item_id = $new_id;
				}
				$last_item_id = $new_id;
			}
			else
			{
				$start_item_id = $new_id;
				$last_item_id = $new_id;
			}
		}
	}
	
	// Do final 
	if($start_item_id < $last_item_id)
	{
		$item_id_range .= $start_item_id.'-'.$last_item_id;
	}
	else if(is_numeric($start_item_id))
	{
		$item_id_range .= $start_item_id;
	}
	
	return $item_id_range;
}

/**
*/
function get_column_select_block($fieldname, $lookup_array, $selectedindex)
{
	// So we can access the language variables.
	global $LANG_VARS;

	$var="\n<select name=\"$fieldname\">";
	$var.="\n<option value=\"\">-- ".$LANG_VARS['none']." --";
	for ($i=0; $i<count($lookup_array); $i++)
	{
		$var .= "\n<option ".(is_numeric($selectedindex) && $selectedindex==$i?"SELECTED":"")." value=\"$i\">".$lookup_array[$i];
	}
	$var.="\n</select>";
	return $var;
}

/**
	We are using this instead of the particular input types, so
	that users can clearly see what the %value% and %display%
	columns are for the lookups, so they can match them in
	their import file.
*/
function build_select($name, $lookup_results, $value, $include_none_option=TRUE)
{	
	global $LANG_VARS;
	
	// If at least one $lookup_r['value'] is different from $lookup_r['display'] set this variable to true.
	$display_used=FALSE;
	
	$var="\n<select name=\"$name\">";
	if($include_none_option)
		$var.="\n<option value=\"\">-- ".$LANG_VARS['none']." --";
		
	while($lookup_r = mysql_fetch_array($lookup_results))
	{
		if($lookup_r['value'] === $lookup_r['display'])
			$display = $lookup_r['value'];
		else{
			$display = $lookup_r['value']." - ".$lookup_r['display'];
			if(!$display_used)
				$display_used=TRUE;
		}

		$var .= "\n<option value=\"".$lookup_r['value']."\"";

		// Only support checked_ind, where we are not displaying a None option.  If None option, it should
		// be chosen by default.		
		if( ($include_none_option!==TRUE && strlen($value)==0 && $lookup_r['checked_ind']=="Y") || 
					(strlen($value)>0 && strcasecmp($value,$lookup_r['value'])===0))
		{
			$var .= " SELECTED";
		}
		
		$var .= ">$display";
	}
	mysql_free_result($lookup_results);
	
	$var.="\n</select>";

	if($display_used)
		$var.="<br>(%value% - %display%)";
	else
		$var.="<br>(%value%)";
	return $var;
}

/**
*/
function get_row_column_mappings_table($s_item_type, $owner_id, $header_row, $field_column_r, $field_default_r, $field_initcap_r)
{
	global $LANG_VARS, $CONFIG_VARS;
	
	$buffer = "\n<table width=100% cellspacing=1 border=0>";
	$buffer .= "\n<tr><td class=\"navbar\">&nbsp;</td><td class=\"navbar\">".$LANG_VARS['column']."</td><td class=\"navbar\">".$LANG_VARS['default']."</td><td class=\"navbar\"> ".$LANG_VARS['initcap']." </td></tr>";
	
	// If the prompt for this field, matches any of the $tokens, then select that token.
	if(!is_numeric($field_column_r['s_item_type']))
	{
		for($i=0; $i<count($header_row); $i++)
		{
			if($header_row[$i] == 's_item_type' || $header_row[$i] == $LANG_VARS['s_item_type'])
			{
				$field_column_r['s_item_type'] = $i;
				break;
			}
		}
	}
							
	// If your data includes the item_type, then specify the column, so we
	// can ignore records that are not of the chosen item_type.
	$buffer .= "\n<tr>"
		.format_prompt($LANG_VARS['s_item_type'])
		.format_data(NULL, get_column_select_block("field_column[s_item_type]", $header_row, $field_column_r['s_item_type']))
		.format_data(NULL, NULL)
		.format_data(NULL, NULL, "center")
		."</tr>";
									
	// --------- Now the main input fields start....
	$results = fetch_item_attribute_type_rs($s_item_type, TRUE, TRUE);
	if($results)
	{
		while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			// purely readonly
			if($item_attribute_type_r['s_field_type'] !== 'ITEM_ID')
			{
				$widget = prc_function_spec($item_attribute_type_r['input_type']);
				$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
	
				if($item_attribute_type_r['s_field_type'] == 'STATUSTYPE')
				{
					$lookup_results = fetch_newitem_status_type_rs($owner_id);
					$default_field = build_select("field_default[$fieldname]", $lookup_results, $field_default_r[$fieldname], FALSE); // do not include 'None' option
					$initcap_field = NULL;// No initcap for these types of fields.
				}
				else if($widget['type'] !== "textarea" && 
							$widget['type'] !== "url" && 
							$widget['type'] !== "upload_or_saveurl" && 
							$widget['type'] !== "saveurl" && 
							$widget['type'] !== "upload")
				{
					// The new upload/saveurl widgets can not work as default fields! 
					// Also because of their nature, it does not make any sense to have a default field
					// for textarea widgets either!

					// Check if any lookup values for this field.
					$lookup_results = fetch_attribute_type_lookup_rs($item_attribute_type_r['s_attribute_type']);
					if($lookup_results)
					{
						$default_field = build_select("field_default[$fieldname]", $lookup_results, $field_default_r[$fieldname]);
						$initcap_field = NULL;// No initcap for these types of fields.
					}
					else //use normal input field.
					{
						$default_field = 
									get_input_field(
											"field_default[$fieldname]",
											$item_attribute_type_r['s_attribute_type'], 
											$item_attribute_type_r['prompt'], 
											$item_attribute_type_r['input_type'],
											$item_attribute_type_r['compulsory_ind'], 
											$field_default_r[$fieldname],
											FALSE);

						if($widget['type'] === 'text')
						{
							$initcap_field = 
									get_input_field(
											"field_initcap[$fieldname]",
											NULL, 
											NULL, 
											"checkbox(true,false,)",
											"N", 
											ifempty($field_initcap_r[$fieldname], ($CONFIG_VARS['import.row_import_default_initcap_checked']?"true":"false")),
											FALSE);
						}
						else //Only for text fields.
						{
							$initcap_field = NULL;
						}
					}
				}
				else
				{
					$field = NULL;
					$default_field = NULL;
					$initcap_field = NULL;
				}
										
				// If the prompt for this field, matches any of the $tokens, then select that token.
				if(!is_numeric($field_column_r[$fieldname]))
				{
					for($i=0; $i<count($header_row); $i++)
					{
						// A direct export from CSV Export, so lets match the columns for you.
						if($header_row[$i] == $fieldname || $header_row[$i] == $item_attribute_type_r['prompt'])
						{
							$field_column_r[$fieldname] = $i;
							break;
						}
					}
				}
				
				$buffer .= "\n<tr>"
					.format_prompt($item_attribute_type_r['prompt'])
					.format_data(NULL, get_column_select_block("field_column[$fieldname]", $header_row, $field_column_r[$fieldname]))
					.format_data(NULL, $default_field)
					.format_data(NULL, $initcap_field, "center")
					."</tr>";
					
			}//if($item_attribute_type_r['s_field_type'] !== 'ITEM_ID')
		}//while
		mysql_free_result($results);
	}//if($results)
	
	$buffer .= "\n</table>";
	
	return $buffer;
}

function get_import_options_table(&$importPlugin, $HTTP_VARS, $display_only = FALSE)
{
	global $LANG_VARS;
	
	$buffer = "<table border=1 cellpadding=0 cellspacing=1><tr><td><table cellspacing=1 cellpadding=3 border=0>";
	
	if($importPlugin->get_plugin_type() == 'row' && $importPlugin->is_header_row())
	{
		if($display_only)
		{
			$buffer .= format_field($LANG_VARS['include_first_line'], NULL, (strcmp($HTTP_VARS['include_header_row'],'Y')===0?$LANG_VARS['yes']:$LANG_VARS['no']));
		}
		else
		{
			$buffer .= format_field($LANG_VARS['include_first_line'], NULL, "<input type=checkbox name=\"include_header_row\" value=\"Y\"".(strcmp($HTTP_VARS['include_header_row'],'Y')===0?' CHECKED':'').">");
		}
	}
	
	if($display_only)
	{
		$buffer .= format_field($LANG_VARS['ignore_duplicate_title'], NULL, (strcmp($HTTP_VARS['ignore_duplicate_title'],'Y')===0?$LANG_VARS['yes']:$LANG_VARS['no']));
	}
	else
	{
		$buffer .= format_field($LANG_VARS['ignore_duplicate_title'], NULL, "<input type=checkbox name=\"ignore_duplicate_title\" value=\"Y\"".(strcmp($HTTP_VARS['ignore_duplicate_title'],'Y')===0?' CHECKED':'').">");
	}
	
	if($importPlugin->classname!==NULL)
	{
		if($display_only)
		{
			$buffer .= format_field($LANG_VARS['trial_run'], NULL, (strcmp($HTTP_VARS['trial_run'],'Y')===0?$LANG_VARS['yes']:$LANG_VARS['no']));
		}
		else
		{
			$buffer .= format_field($LANG_VARS['trial_run'], NULL, "<input type=checkbox name=\"trial_run\" value=\"Y\" CHECKED>");
		}
	}
	
	$buffer .= "</table></td></tr></table>";
	
	return $buffer;
}

class PreviewImportPlugin
{
	var $classname = NULL;
	
	function get_display_name()
	{
		global $LANG_VARS;
		
		return $LANG_VARS['preview'];
	}
	
	function get_plugin_type()
	{
		return 'row';
	}
	
	function is_header_row()
	{
		return TRUE;
	}

	function read_header($file_handle, &$error)
	{
		return NULL;
	}
}

/*
* This page is displayed, when file is uploaded, and various
* options are available to indicate what the next step should
* be in the upload process.  The uploaded page will also be
* loaded when a user chooses to go 'Back' during a trial
* run of the import process.
*/
function get_uploaded_form(&$importPlugin, $header_row, $HTTP_VARS)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	$buffer = "\n<form action=\"$PHP_SELF\" method=\"post\">";
	$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"import\">";
	$buffer .= "\n<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"ic_sequence_number\" value=\"".$HTTP_VARS['ic_sequence_number']."\">";
	
	$buffer .= get_import_options_table($importPlugin, $HTTP_VARS);
	$buffer .= "\n<br>";
				
	if($importPlugin->get_plugin_type() == 'row')
	{
		$buffer .= get_row_column_mappings_table(
							$HTTP_VARS['s_item_type'], 
							$HTTP_VARS['owner_id'], 
							$header_row, 
							$HTTP_VARS['field_column'],
							$HTTP_VARS['field_default'],
							$HTTP_VARS['field_initcap']);
	}
	else if($importPlugin->get_plugin_type() == 'xml')
	{
		// Include a Status Type LOV and a checkbox to indicate
		// whether the s_status_type should be used for all imports
		// ignoring any s_status_type which may be included in the
		// data.
		$buffer .= '<table cellspacing=1 cellpadding=3 border=0>';
		$buffer .= format_field($LANG_VARS['s_status_type'], NULL, status_type_input_field("s_status_type", fetch_newitem_status_type_rs($HTTP_VARS['owner_id']), $HTTP_VARS['s_status_type']));
		$buffer .= format_field($LANG_VARS['override_status_type'], NULL, "<input type=checkbox name=\"override_status_type\" value=\"Y\"".(strcmp($HTTP_VARS['override_status_type'],'Y')===0?' CHECKED':'').">");
		$buffer .= '</table>';
	}
	
	$buffer .= '<p align=center>';
	if($importPlugin->classname!==NULL)
		$buffer .= '<input type=submit value="'.$LANG_VARS['import_items'].'">';
	$buffer .= '</p>';
		
	$buffer .= '</form>';
	
	return $buffer;
}

function get_upload_form($HTTP_VARS)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	$buffer = get_validation_javascript();
	$buffer .= "\n<table border=0 frameborder=0 cellspacing=1>";
	$buffer .= "\n<form name=\"main\" action=\"$PHP_SELF\" method=\"post\" enctype=\"multipart/form-data\">";
	$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"upload\">";

	// We have already checked that the current user is an administrator if owner_id not provided.	
	if(strlen($HTTP_VARS['owner_id'])==0)
	{
		$results = fetch_user_rs(get_owner_user_types_r());
		$buffer .= format_field($LANG_VARS['owner'], NULL, custom_select('owner_id', $results, '%fullname% (%user_id%)', 1, $HTTP_SESSION_VARS['user_id'], 'user_id'));
	}
	else
	{
		$buffer .= "\n<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">";
	}
							
	$buffer .= format_field($LANG_VARS['item_type'], NULL, single_select("s_item_type", fetch_item_type_rs(TRUE), "%value% - %display%", NULL, $HTTP_VARS['s_item_type']));
	$buffer .= get_input_field("uploadfile", NULL, $LANG_VARS['file'], "upload(25,*,)");
		
	$buffer .= "\n<tr><td colspan=2><input type=submit value=\"".$LANG_VARS['import_items']."\">";
	$buffer .= "\n</td></tr>";
	$buffer .= "\n</form>";
	$buffer .= "\n</table>";
	
	return $buffer;
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session())
	{
		// Only admin user or owner user allowed to access this.
		if( ($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] && is_user_normal($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) ) || is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
		{
			if(is_file_upload_enabled() && import_cache_check_is_installed())
			{
				@set_time_limit(600);
				
				if($HTTP_VARS['op'] == 'upload')
				{
					if(is_uploaded_file($HTTP_POST_FILES['uploadfile']['tmp_name']))
					{
						if($HTTP_POST_FILES['uploadfile']['size']>0)
						{
							$importPlugin =& get_import_plugin($HTTP_POST_FILES['uploadfile'], $error);
							if($importPlugin !== NULL)
							{
								$content = read_file_contents($HTTP_POST_FILES['uploadfile']['tmp_name'], $error);
								if($content!==FALSE)
								{
									$sequence_number = import_cache_insert($HTTP_VARS['owner_id'], $importPlugin->classname, $content);
									if($sequence_number!==FALSE)
									{
										// pass this onto the next call!
										$HTTP_VARS['ic_sequence_number'] = $sequence_number;
										
										if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
											$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);			
										else
											$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);			
	
										echo(_theme_header($page_title));
										
										if($importPlugin->get_plugin_type() == 'row')
											echo ("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>\n");
										else
											echo("<h2>".$page_title."</h2>");
										
										$fileHandler =& new StringFileHandler($content);
										echo(get_uploaded_form(
													$importPlugin, 
													($importPlugin->get_plugin_type()=='row')? $importPlugin->read_header($fileHandler, $error) : NULL,
													$HTTP_VARS));
										
										if($importPlugin->get_plugin_type()=='row')
										{
											echo(format_help_block($LANG_VARS['import_row_help']));
										}
										else if($importPlugin->get_plugin_type() == 'xml')
										{
											echo(format_help_block($LANG_VARS['import_xml_help']));
										}
										echo _theme_footer();
										
										unset($fileHandler);
									}//if($sequence_number!==FALSE)
									else
									{
										if(strlen($HTTP_VARS['owner_id'])>0)
										{
											if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
												$page_title = $LANG_VARS['import_my_items'];
											else
												$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['import_items_for_name']);
										}
										else
										{
											$page_title = $LANG_VARS['import_items'];
										}
										echo(_theme_header($page_title));
										echo("<h2>".$page_title."</h2>");
										echo(format_error_block(replace_lang_var('prompt', strtoupper(get_file_ext($HTTP_POST_FILES['uploadfile']['name'])), $LANG_VARS['file_upload_error'])));
										echo(_theme_footer());
									}
								}//if(move_uploaded_file($HTTP_POST_FILES['uploadfile']['tmp_name'], $HTTP_VARS['uploaded_file']))
								else
								{
									if(strlen($HTTP_VARS['owner_id'])>0)
									{
										if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
											$page_title = $LANG_VARS['import_my_items'];
										else
											$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['import_items_for_name']);
									}
									else
									{
										$page_title = $LANG_VARS['import_items'];
									}
									echo(_theme_header($page_title));
									echo("<h2>".$page_title."</h2>");
									echo(format_error_block(replace_lang_var('prompt', strtoupper(get_file_ext($HTTP_POST_FILES['uploadfile']['name'])), $LANG_VARS['file_upload_error'])));
									echo(_theme_footer());
								}
							}//if($importPlugin !== NULL)
							else
							{
								if(strlen($HTTP_VARS['owner_id'])>0)
								{
									if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
										$page_title = $LANG_VARS['import_my_items'];
									else
										$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['import_items_for_name']);
								}
								else
								{
									$page_title = $LANG_VARS['import_items'];
								}
								echo(_theme_header($page_title));
								echo("<h2>".$page_title."</h2>");
								echo(format_error_block($error));
								echo(_theme_footer());
							}
						}//if($HTTP_POST_FILES['uploadfile']['size']>0)
						else
						{
							if(strlen($HTTP_VARS['owner_id'])>0)
							{
								if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
									$page_title = $LANG_VARS['import_my_items'];
								else
									$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['import_items_for_name']);
							}
							else
							{
								$page_title = $LANG_VARS['import_items'];
							}
							echo(_theme_header($page_title));
							echo("<h2>".$page_title."</h2>");
							echo(format_error_block(replace_lang_var('prompt', strtoupper(get_file_ext($HTTP_POST_FILES['uploadfile']['name'])), $LANG_VARS['file_upload_empty'])));
							echo(_theme_footer());
						}
					}
					else
					{
						$importPlugin = new PreviewImportPlugin();
						
						if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
							$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);			
						else
							$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);			
		
						echo(_theme_header($page_title));
						echo ("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>\n");
										
						// no upload file provided - so preview mode.
						echo(get_uploaded_form(
										$importPlugin, 
										NULL, 
										$HTTP_VARS));
		
						if($importPlugin->get_plugin_type() == 'row')
						{
							echo(format_help_block($LANG_VARS['import_row_help']));
						}
									
						echo _theme_footer();
					}
				}
				else if($HTTP_VARS['op'] == 'uploaded')
				{
					$import_cache_r = fetch_import_cache_r($HTTP_VARS['ic_sequence_number'], $HTTP_VARS['owner_id']);
					if(is_not_empty_array($import_cache_r))
					{
						if(is_import_plugin($import_cache_r['plugin_name']))
						{
							$pluginRef = $import_cache_r['plugin_name'];
							
							include_once("./import/".$pluginRef.".php");
							$importPlugin = new $pluginRef();
							if($importPlugin !== NULL)
							{
								$content = import_cache_fetch_content($HTTP_VARS['ic_sequence_number']);
								if(strlen($content)>0)
								{
									$fileHandler =& new StringFileHandler($content);
									
									if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
										$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);			
									else
										$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);			
		
									echo(_theme_header($page_title));
										
									if($importPlugin->get_plugin_type() == 'row')
										echo ("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>\n");
									else
										echo("<h2>".$page_title."</h2>");
									
									echo(get_uploaded_form(
												$importPlugin, 
												($importPlugin->get_plugin_type()=='row')? $importPlugin->read_header($fileHandler, $error) : NULL,
												$HTTP_VARS));
									
									if($importPlugin->get_plugin_type()=='row')
									{
										echo(format_help_block($LANG_VARS['import_row_help']));
									}
									else if($importPlugin->get_plugin_type() == 'xml')
									{
										echo(format_help_block($LANG_VARS['import_xml_help']));
									}
									
									unset($fileHandler);
									
									echo _theme_footer();
								}//if(strlen($content)>0)
								else
								{
									echo _theme_header($LANG_VARS['undefined_error']);
									echo _theme_error($LANG_VARS['undefined_error']);
									echo _theme_footer();
								}
							}//if($importPlugin !== NULL)
							else
							{
								echo _theme_header($LANG_VARS['undefined_error']);
								echo _theme_error($LANG_VARS['undefined_error']);
								echo _theme_footer();
							}
						}//if(is_import_plugin($import_cache_r['plugin_name']))
						else
						{
							echo _theme_header($LANG_VARS['undefined_error']);
							echo _theme_error($LANG_VARS['undefined_error']);
							echo _theme_footer();
						}
					}//if(is_not_empty_array($import_cache_r))
					else
					{
						echo _theme_header($LANG_VARS['import_cache_file_not_found']);
						echo _theme_error($LANG_VARS['import_cache_file_not_found']);
						echo _theme_footer();
					}
				}
				else if($HTTP_VARS['op'] == 'import' && $HTTP_VARS['op2'] != 'importing')
				{
					$import_cache_r = fetch_import_cache_r($HTTP_VARS['ic_sequence_number'], $HTTP_VARS['owner_id']);
					if(is_not_empty_array($import_cache_r))
					{
						if(is_import_plugin($import_cache_r['plugin_name']))
						{
							$pluginRef = $import_cache_r['plugin_name'];
							
							include_once("./import/".$pluginRef.".php");
							$importPlugin = new $pluginRef();
							if($importPlugin !== NULL)
							{
								if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
									$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);			
								else
									$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);			
			
								echo(_theme_header($page_title));
											
								if($importPlugin->get_plugin_type() == 'row')
									echo ("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>\n");
								else
									echo("<h2>".$page_title."</h2>");
												
								echo("\n<form action=\"$PHP_SELF\" method=\"post\" name=\"import_progress\">");
								echo(get_url_fields($HTTP_VARS, array('op2'=>'importing')));
								echo("<br><br><br><div class=\"colortext\" align=\"center\"><strong>".$LANG_VARS['import_progress_message']."</strong></div>");
								echo("</form>\n");
								
								echo('<script language="JavaScript">'
									.'window.onload = function loadImport(){document.forms[\'import_progress\'].submit();}'
									.'</script>');
		
								echo(_theme_footer());
								
							}//if($importPlugin !== NULL)
							else
							{
								echo _theme_header($LANG_VARS['undefined_error']);
								echo _theme_error($LANG_VARS['undefined_error']);
								echo _theme_footer();
							}
						}//if(is_import_plugin($import_cache_r['plugin_name']))
						else
						{
							echo _theme_header($LANG_VARS['undefined_error']);
							echo _theme_error($LANG_VARS['undefined_error']);
							echo _theme_footer();
						}
					}//if(is_not_empty_array($import_cache_r))
					else
					{
						echo _theme_header($LANG_VARS['import_cache_file_not_found']);
						echo _theme_error($LANG_VARS['import_cache_file_not_found']);
						echo _theme_footer();
					}
				}
				else if($HTTP_VARS['op'] == 'import' && $HTTP_VARS['op2'] == 'importing')
				{
					$import_cache_r = fetch_import_cache_r($HTTP_VARS['ic_sequence_number'], $HTTP_VARS['owner_id']);
					if(is_not_empty_array($import_cache_r))
					{
						if(is_import_plugin($import_cache_r['plugin_name']))
						{
							// This is messy - row type import will never need a default value, but for
							// now lets leave it.
							$tmp_status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
							if(is_newitem_status_type_valid($HTTP_VARS['owner_id'], $tmp_status_type_r, $errors))
							{
								$cfg_default_status_type_r = $tmp_status_type_r;
							}
							else
							{
								$cfg_default_status_type_r = fetch_status_type_r(fetch_default_status_type_for_owner($HTTP_VARS['owner_id']));
							}
							
							// We always require a valid fallback s_status_type
							if(is_not_empty_array($cfg_default_status_type_r))
							{
								$pluginRef = $import_cache_r['plugin_name'];
								
								include_once("./import/".$pluginRef.".php");
								$importPlugin =& new $pluginRef();
								if($importPlugin !== NULL)
								{
									$content = import_cache_fetch_content($HTTP_VARS['ic_sequence_number']);
									if(strlen($content)>0)
									{
										$fileHandler =& new StringFileHandler($content);

										// we want to display all items - no pagination.
										$HTTP_VARS['items_per_page'] = '';
										
										$listingObject =& 
												new HTML_Listing(
														$PHP_SELF, 
														$HTTP_VARS); 
									
										$listingObject->setPrintableLinkVisible(FALSE);
										$listingObject->setItemsPerPageControlVisible(FALSE);
										$listingObject->setNoRowsMessage($LANG_VARS['no_items_found']);
										
										//-----------------------------------------------------------------
										// Define import item callback structure here.
										//-----------------------------------------------------------------
										$cfg_ignore_duplicate_title = ( strcmp($HTTP_VARS['ignore_duplicate_title'],'Y')===0? TRUE : FALSE );
										$cfg_is_trial_run = ( strcmp($HTTP_VARS['trial_run'],'Y')===0? TRUE : FALSE );
										$cfg_override_status_type = ( strcmp($HTTP_VARS['override_status_type'],'Y')===0? TRUE : FALSE );
										//$cfg_default_status_type_r defined previously.

										$v_import_item_id_r = array();

										//Setting up data to be used by listing_item_import_result_row
										//and item_import_handler_callbac
										//-----------------------------------------------------------------
										$itemImportHandler = new ItemImportHandler(
																$HTTP_VARS['owner_id'],
																'item_import_handler_callback');
											
										if($importPlugin->get_plugin_type() == 'row')
										{
											if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
												$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);
											else
												$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);
											
											echo(_theme_header($page_title));
											echo ("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>\n");
										}
										else if($importPlugin->get_plugin_type() == 'xml')
										{
											//
											// The XML callback functions
											//
											function import_add_error($method, $error)
											{
												global $itemImportHandler;
												
												$itemImportHandler->addError($method, $error);
											}
											
											function import_start_item($s_item_type, $title = NULL, $category = NULL)
											{
												global $itemImportHandler;
												$itemImportHandler->startItem($s_item_type, $title, trim_explode(' ', $category));
											}
											
											function import_set_title($title)
											{
												global $itemImportHandler;
												$itemImportHandler->setTitle($title);
											}
											
											function import_set_category($category)
											{
												global $itemImportHandler;
												$itemImportHandler->setCategory($category);
											}
											
											function import_item_instance($s_status_type = NULL, $status_comment = NULL, $borrow_duration = NULL)
											{
												global $itemImportHandler;
												$itemImportHandler->itemInstance($s_status_type, $status_comment, $borrow_duration);
											}
											
											function import_item_attribute($s_attribute_type, $order_no, $attribute_val)
											{
												global $itemImportHandler;
												$itemImportHandler->itemAttribute($s_attribute_type, $order_no, $attribute_val);
											}
											
											function import_end_item()
											{
												global $itemImportHandler;
												$itemImportHandler->endItem();
											}
											
											if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
												$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name()), $LANG_VARS['type_import']);
											else
												$page_title = replace_lang_vars(array('type'=>get_display_import_type($importPlugin->classname), 'description'=>$importPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_import_items_for_name']);
											
											echo(_theme_header($page_title));
											echo ("<h2>".$page_title."</h2>\n");
										}
								
										echo(get_import_options_table($importPlugin, $HTTP_VARS, TRUE).'<br>');
										
										$listingObject->startListing();
								
										$listingObject->addHeaderColumn(''); // Success or Failure column
										$listingObject->addHeaderColumn($LANG_VARS['type']);
										$listingObject->addHeaderColumn($LANG_VARS['title']);
										//$listingObject->addHeaderColumn($LANG_VARS['owner']);
										$listingObject->addHeaderColumn($LANG_VARS['s_status_type']);
										$listingObject->addHeaderColumn($LANG_VARS['category']);
										$listingObject->addHeaderColumn($LANG_VARS['attributes']);
								
										if($importPlugin->get_plugin_type() == 'row')
										{
											$rowHandler = new RowImportPluginHandler($itemImportHandler, $importPlugin, $fileHandler, $HTTP_VARS['field_column'], $HTTP_VARS['field_default'], $HTTP_VARS['field_initcap']);
											if( ($resultOfImport = $rowHandler->handleImport(strcasecmp($HTTP_VARS['include_header_row'],'Y')===0, $HTTP_VARS['s_item_type']))!==TRUE)
											{
												$importError = $xmlHandler->getError();
											}
										}
										else if($importPlugin->get_plugin_type() == 'xml')
										{
											$xmlHandler = new XMLImportPluginHandler($itemImportHandler, $importPlugin, $fileHandler);
											if( ($resultOfImport = $xmlHandler->handleImport())!==TRUE)
											{
												$importError = $xmlHandler->getError();
											}
										}
								
										// Close file.
										unset($fileHandler);
									
										// TODO: any XML errors whatsoever will cause the process to completely
										// fall over.  This should be changed, to ignore errors if they are
										// occurring at item level, and try to process as many items as possible.
										// obviously any errors that occur within an item, its attributes or child
										// items should cause that entire item to be ignored.
										if($resultOfImport !== TRUE)
										{
											$listingObject->setNoRowsMessage($importError);
										}
										else
										{
											if($cfg_is_trial_run)
											{
												if($listingObject->getRowCount()>0)
												{
													$listingObject->addListOpAction($LANG_VARS['back'], NULL, 'uploaded', FALSE);
													$listingObject->addListFieldValueAction($LANG_VARS['import_items'], NULL, 'import', 'trial_run', 'N');
												}
												else
												{
													$listingObject->addListOpAction($LANG_VARS['back'], NULL, 'uploaded', FALSE);
												}
											}
											else 
											{
												if(is_not_empty_array($v_import_item_id_r))
												{
													$listingObject->addListHrefAction(replace_lang_var("count", count($v_import_item_id_r), $LANG_VARS['list_imported_items']), 'listings.php?item_id_range='.urlencode(get_item_id_range($v_import_item_id_r).'&linked_items=include'));
												}
												
												//Get rid of the file now!
												import_cache_delete($HTTP_VARS['ic_sequence_number']);
											}
										}
										
										$listingObject->endListing();
										// don't need it anymore.
										unset($listingObject);
										
										echo _theme_footer();
									}//if(strlen($content)>0)
									else
									{
										echo _theme_header($LANG_VARS['undefined_error']);
										echo _theme_error($LANG_VARS['undefined_error']);
										echo _theme_footer();
									}
								}//if($importPlugin !== NULL)
								else
								{
									echo _theme_header($LANG_VARS['undefined_error']);
									echo _theme_error($LANG_VARS['undefined_error']);
									echo _theme_footer();
								}
							}//if(is_array($cfg_default_status_type_r) && is_newitem_status_type_valid($HTTP_VARS['owner_id'], $cfg_default_status_type_r))
							else
							{
								echo _theme_header($LANG_VARS['undefined_error']);
								echo _theme_error($LANG_VARS['undefined_error']);
								echo _theme_footer();
							}
						}//if(is_import_plugin($import_cache_r['plugin_name']))
						else
						{
							echo _theme_header($LANG_VARS['undefined_error']);
							echo _theme_error($LANG_VARS['undefined_error']);
							echo _theme_footer();
						}
					}//if(is_not_empty_array($import_cache_r))
					else
					{
						echo _theme_header($LANG_VARS['import_cache_file_not_found']);
						echo _theme_error($LANG_VARS['import_cache_file_not_found']);
						echo _theme_footer();
					}
				}
				else
				{
					if(strlen($HTTP_VARS['owner_id'])>0)
					{
						if(strcmp($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']) === 0)
							$page_title = $LANG_VARS['import_my_items'];
						else
							$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['import_items_for_name']);
					}
					else
					{
						$page_title = $LANG_VARS['import_items'];
					}
					
					echo(_theme_header($page_title));
					echo("<h2>".$page_title."</h2>");
					
					echo(get_upload_form($HTTP_VARS));
	
					echo(format_help_block($LANG_VARS['import_help']));
					
					echo _theme_footer();
				}
			}
			else// if(is_file_upload_enabled() && import_check_is_installed())
			{
				if(is_file_upload_enabled())
				{
					echo _theme_header($LANG_VARS['import_not_available']);
					echo _theme_error($LANG_VARS['import_not_available']);
					
					opendb_log('Import cache table not installed.  You can install the import cache table via the Patch Facility.');
				}
				else
				{
					echo _theme_header($LANG_VARS['file_upload_not_available']);
					echo _theme_error($LANG_VARS['file_upload_not_available']);
				}
			}
		}
		else//not an administrator or own user.
		{
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
		}
	}
	else//invalid session
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>