<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/fileutils.php");

function import_cache_check_is_installed()
{
	// Only get one row, to save processing them.
	$query = "SELECT 'x' FROM import_cache LIMIT 0,1";
	
	// In this case the run_opendb_query() would return FALSE, if
    // table does not exist.
	$result = run_opendb_query($query);
	if($result)	
	{
		mysql_free_result($result);

		// The table exists (Does not have to have any records!)
		return TRUE;
	}

	//else
	return FALSE;
}

function import_cache_get_file_location($sequence_number)
{
	global $CONFIG_VARS;
	
	return $CONFIG_VARS['import.file_location'].$sequence_number.'.tmp';
}

/**
* @$include_content if TRUE, will request content as well.
*/
function fetch_import_cache_r($sequence_number, $user_id = NULL)
{
	if(is_numeric($sequence_number))
	{
		$query = "SELECT user_id, plugin_name, content_length ".
			"FROM import_cache ".
			"WHERE sequence_number = '$sequence_number'";
			
		// allows to enforce the fact that this user owns the
		// particular record.
		if(strlen($user_id)>0)
		{
			$query .= " AND user_id = '$user_id'";
		}
	
		$result = run_opendb_query($query);
		if($result && mysql_num_rows($result)>0)
		{
			$found = mysql_fetch_array($result, MYSQL_ASSOC);
			mysql_free_result($result);
			return $found;
		}
	}
	
	//else
	return FALSE;
}

function import_cache_fetch_content($sequence_number)
{
	// make sure the file still exists!
	$query = "SELECT sequence_number FROM import_cache WHERE sequence_number = '$sequence_number'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
		{
			$file_location = import_cache_get_file_location($found['sequence_number']);
			$contents = read_file_contents($file_location, $error);
			if($contents!==FALSE)
			{
				return $contents;
			}
			else
			{
				opendb_log("Failed to fetch import cache content (sequence_number=$sequence_number, file_location=".$file_location.", update_who=".$HTTP_SESSION_VARS['user_id'].") [".$error."]");
				return FALSE;
			}
		}
	}

	//else
	return FALSE;
}

function import_cache_insert($user_id, $plugin_name, $content)
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(strlen($content)>0)
	{
		$content_length = strlen($content);
		$query = "INSERT INTO import_cache(user_id, plugin_name, content_length)".
				" VALUES ('$user_id','$plugin_name','$content_length')";

		$insert = run_opendb_query($query);
		if ($insert && mysql_affected_rows() > 0)
		{
			$new_sequence_number = mysql_insert_id();
			opendb_log("Inserted import_cache record (sequence_number=$new_sequence_number, user_id=$user_id, plugin_name=$plugin_name, content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].")");
				
			$file_location = import_cache_get_file_location($new_sequence_number);
			if(write_file_contents($file_location, $content, $error)!==FALSE)
			{
				return $new_sequence_number;
			}
			else
			{
				opendb_log("Failed to save import_cache file (user_id=$user_id, plugin_name=$plugin_name, content_length=$content_length, file_location=$file_location, update_who=".$HTTP_SESSION_VARS['user_id'].") [".$error."]");
				return FALSE;
			}
		}
		else
		{
			opendb_log("Failed to insert import_cache record (user_id=$user_id, plugin_name=$plugin_name, content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Failed to insert import_cache record (user_id=$user_id, plugin_name=$plugin_name, update_who=".$HTTP_SESSION_VARS['user_id'].") [Empty content]");
		return FALSE;
	}
}

function import_cache_delete($sequence_number)
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM import_cache WHERE sequence_number = '$sequence_number'";
	$delete = run_opendb_query($query);
	if( $delete && mysql_affected_rows() > 0)
	{
		opendb_log("Deleted import_cache record (sequence_number=$sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		
		$file_location = import_cache_get_file_location($sequence_number);
		if(file_exists($file_location))
		{
			// now delete the file.
			if (@unlink($file_location) !== FALSE)
			{
				return TRUE;
			}
			else
			{
				opendb_log("Failed to delete import_cache file (sequence_number=$sequence_number, file_location=$file_location, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
				return FALSE;
			}
		}
		else
		{
			return TRUE;
		}
	}
	else
	{
		opendb_log("Failed to delete import_cache record (sequence_number=$sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

function import_cache_delete_for_user($user_id)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES import_cache WRITE"))
	{
		$query = "SELECT sequence_number FROM import_cache WHERE user_id = '$user_id'";
		$results = run_opendb_query($query);
		if($results)
		{
			while($import_cache_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				import_cache_delete($import_cache_r['sequence_number']);
			}
			mysql_free_result($results);
		}
		
		run_opendb_query("UNLOCK TABLES");
		
		return TRUE;
	}
	else
	{
		opendb_log("Could not lock import_cache for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			
		// could not lock table.
		return FALSE;
	}
}

function import_cache_deleteall()
{
	global $HTTP_SESSION_VARS;
	if(run_opendb_query("LOCK TABLES import_cache WRITE"))
	{
		$query = "SELECT sequence_number FROM import_cache";
		$results = run_opendb_query($query);
		if($results)
		{
			while($import_cache_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				import_cache_delete($import_cache_r['sequence_number']);
			}
			mysql_free_result($result);
		}
		
		run_opendb_query("UNLOCK TABLES");
	}
	else
	{
		opendb_log("Could not lock import_cache for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			
		// could not lock table.
		return FALSE;
	}
}
?>