<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");
include_once("./functions/item_type.php");
include_once("./functions/item.php");
include_once("./functions/item_attribute.php");
include_once("./functions/user.php");
include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/export.php");

// For performance we want to cache this information, so we only query whether an
// attribute is a lookup attribute type ONCE.
$_ATTRIBUTE_TYPE_STRUCTURE_RS = NULL;

function export_is_lookup_attribute_type($s_attribute_type)
{
	global $_ATTRIBUTE_TYPE_STRUCTURE_RS;
	
	// save unique s_attribute_type structure.
	if(!is_array($_ATTRIBUTE_TYPE_STRUCTURE_RS) || !is_array($_ATTRIBUTE_TYPE_STRUCTURE_RS[$s_attribute_type]))
	{
		if(is_lookup_attribute_type($s_attribute_type))
		{
			$_ATTRIBUTE_TYPE_STRUCTURE_RS[$s_attribute_type]['lookup_attribute_type'] = TRUE;
		}
		else
		{
			$_ATTRIBUTE_TYPE_STRUCTURE_RS[$s_attribute_type]['lookup_attribute_type'] = FALSE;
		}
	}
		
	// now returned cached value.
	return $_ATTRIBUTE_TYPE_STRUCTURE_RS[$s_attribute_type]['lookup_attribute_type'];
}

/*
* Export Type 
* 
* @param $linked_items - 'include' or 'exclude'
*/
function export_type_items(&$exportPlugin, $send_as_format, $page_title, $s_item_type, $item_id, $instance_no, $owner_id, $include_linked_items)
{
	$itemresults = fetch_export_item_rs($s_item_type, $item_id, $owner_id);
	if($itemresults)
	{
		send_header($exportPlugin, $send_as_format, $page_title);
		while($item_r = mysql_fetch_array($itemresults, MYSQL_ASSOC))
		{
			send_data(
					$send_as_format, 
					get_export_type_item(
								$exportPlugin, 
								$item_r['item_id'],
								$instance_no,
								$item_r['s_item_type'],
								$item_r['title'],
								$item_r['category'],
								$owner_id,
								$include_linked_items));
		}
		mysql_free_result($itemresults);
		
		send_footer($exportPlugin, $send_as_format);
		return TRUE;
	}
	else
		return FALSE;
}

/*
* This function exports a single Item, and will
* be recursively called for child items.  Child
* items do not have children.
*/
function get_export_type_item(&$exportPlugin, $item_id, $instance_no, $s_item_type, $title, $category, $owner_id, $include_linked_items=NULL, $isChild=FALSE)
{
	$buffer = '';
	
	$buffer .= $exportPlugin->start_item($item_id, $s_item_type, $title, explode(' ', $category));
	if($isChild!==TRUE)
	{
		if(is_numeric($instance_no))
		{
			$item_instance_r = fetch_item_instance_r($item_id, $instance_no);
			if(is_not_empty_array($item_instance_r))
				$buffer .= $exportPlugin->item_instance($item_instance_r['item_id'], $item_instance_r['instance_no'], $item_instance_r['owner_id'], $item_instance_r['borrow_duration'], $item_instance_r['s_status_type'], $item_instance_r['status_comment']);
		}
		else
		{
			$iiresults = fetch_item_instance_rs($item_id, $owner_id);
			if($iiresults)
			{
				while($item_instance_r = mysql_fetch_array($iiresults, MYSQL_ASSOC))
				{
					$buffer .= $exportPlugin->item_instance($item_instance_r['item_id'], $item_instance_r['instance_no'], $item_instance_r['owner_id'], $item_instance_r['borrow_duration'], $item_instance_r['s_status_type'], $item_instance_r['status_comment']);
				}
				mysql_free_result($iiresults);
			}
		}
		
		if($include_linked_items!==FALSE)
		{
			$childresults = fetch_child_item_rs($item_id);
			if($childresults)
			{
				while($child_item_r = mysql_fetch_array($childresults, MYSQL_ASSOC))
				{
					// recursive call.
					$buffer .= get_export_type_item($exportPlugin, $child_item_r['item_id'], NULL, $child_item_r['s_item_type'], $child_item_r['title'], explode(' ', $child_item_r['category']), NULL, NULL, TRUE);
				}
			
				mysql_free_result($childresults);
			}
		}
	}
		
	//export attributes.
	$attresults = fetch_item_attribute_type_rs($s_item_type, FALSE, TRUE);
	if($attresults)
	{
		while($item_attribute_type_r = mysql_fetch_array($attresults, MYSQL_ASSOC))
		{
			// Only attribute specific s_field_type's should be exported as XML.
			if(strlen($item_attribute_type_r['s_field_type'])==0 || (
						$item_attribute_type_r['s_field_type'] != 'TITLE' && 
						$item_attribute_type_r['s_field_type'] != 'DURATION' &&
						$item_attribute_type_r['s_field_type'] != 'STATUSTYPE' && 
						$item_attribute_type_r['s_field_type'] != 'STATUSCMNT' &&
						$item_attribute_type_r['s_field_type'] != 'CATEGORY' && 
						$item_attribute_type_r['s_field_type'] != 'ITEM_ID') )
			{
				if(export_is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
				{
					$item_lookup_attribute_val_r = fetch_lookup_attribute_val_r($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
					if(is_not_empty_array($item_lookup_attribute_val_r))
					{
						$buffer .= $exportPlugin->item_lookup_attributes($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_lookup_attribute_val_r);
					}
				}
				else
				{
					$item_attribute_type_r['attribute_val'] = fetch_attribute_val($item_id, $item_attribute_type_r['s_attribute_type'],  $item_attribute_type_r['order_no']);
					if($item_attribute_type_r['attribute_val']!==FALSE)
					{
						$buffer .= $exportPlugin->item_attribute($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['attribute_val']);
					}
				}
			}
		}
		mysql_free_result($attresults);
	}
	
	$buffer .= $exportPlugin->end_item($item_id);
	return $buffer;
}

/**
* Row Export
*/
function export_row_items(&$exportPlugin, $send_as_format, $page_title, $include_header, $export_columns, $s_item_type, $owner_id, $include_linked_items)
{
	$iiresults = fetch_export_item_instance_rs($s_item_type, $owner_id);
	if($iiresults)
	{
		send_header($exportPlugin, $send_as_format, $page_title);

		if($include_header == 'Y')
		{
			if(method_exists($exportPlugin, 'prompt_header'))
			{
				$row = get_header_row('prompt', $export_columns, $s_item_type);
				if(is_not_empty_array($row))
				{
					send_data($send_as_format, $exportPlugin->prompt_header($row));
				}
			}
			else if(method_exists($exportPlugin, 'data_header'))
			{
				$row = get_header_row('data', $export_columns, $s_item_type);
				if(is_not_empty_array($row))
				{
					send_data($send_as_format, $exportPlugin->data_header());
				}
			}
		}
		
		$item_instance_r2 = NULL;
		while($item_instance_r = mysql_fetch_array($iiresults, MYSQL_ASSOC))
		{
			// If we have changed item_id's then we need to do the child items, before continuing.
			if($include_linked_items!==FALSE && $item_instance_r2!=NULL && $item_instance_r2['item_id'] != $item_instance_r['item_id'])
			{
				send_data($send_as_format, export_linked_row_items($exportPlugin, $send_as_format, $export_columns, strlen($s_item_type)==0, $item_instance_r2['item_id']));
			}							
			
			$row = get_item_row(
						$export_columns,
						strlen($s_item_type)==0,
						$item_instance_r['item_id'], 
						$item_instance_r['instance_no'],
						$item_instance_r['owner_id'],
						NULL,
						$item_instance_r['s_item_type'],
						$item_instance_r['title'],
						$item_instance_r['category'],
						$item_instance_r['borrow_duration'],
						$item_instance_r['s_status_type'],
						$item_instance_r['status_comment']);

			if(is_not_empty_array($row))
			{
				send_data($send_as_format, $exportPlugin->item_row($row));
			}
						
			$item_instance_r2 = $item_instance_r;
		}
		
		// If we have changed item_id's then we need to do the child items, before continuing.
		if($include_linked_items!==FALSE && $item_instance_r!=NULL)
		{
			export_linked_row_items($exportPlugin, $send_as_format, $export_columns, strlen($s_item_type)==0, $item_instance_r2['item_id']);
		}
		
		mysql_free_result($iiresults);
		
		if(method_exists($exportPlugin, 'close'))
		{
			send_data($send_as_format, $exportPlugin->close());
		}
		
		send_footer($exportPlugin, $send_as_format);
		return TRUE;
	}
	else
		return FALSE;
}

function export_linked_row_items(&$exportPlugin, $send_as_format, $export_columns, $is_all_item_types, $item_id)
{
	$childresults = fetch_child_item_rs($item_id);
	if($childresults)
	{
		while($child_item_r = mysql_fetch_array($childresults, MYSQL_ASSOC))
		{
			$row = get_item_row(
						$export_columns,
						$is_all_item_types,
						$child_item_r['item_id'], 
						NULL, 
						NULL, 
						$item_id,
						$child_item_r['s_item_type'],
						$child_item_r['title'],
						$child_item_r['category'],
						NULL,
						NULL,
						NULL);
			
			if(is_not_empty_array($row))
			{
				send_data($send_as_format, $exportPlugin->item_row($row));
			}
		}
		mysql_free_result($childresults);
	}
}

function get_item_row($export_columns, $is_all_item_types, $item_id, $instance_no, $owner_id, $parent_id, $s_item_type, $title, $category, $borrow_duration, $s_status_type, $status_comment)
{
	if(!is_array($export_columns) || $export_columns['item_id'] == 'Y')
	{
		$row[] = $item_id;
	}
	
	if(!is_array($export_columns) || $export_columns['instance_no'] == 'Y')
	{
		$row[] = $instance_no;
	}
	
	if(!is_array($export_columns) || $export_columns['owner_id'] == 'Y')
	{
		$row[] = $owner_id;
	}
	
	if(!is_array($export_columns) || $export_columns['parent_id'] == 'Y')
	{
		$row[] = $parent_id;
	}
	
	if(!is_array($export_columns) || $export_columns['s_item_type'] == 'Y')
	{
		$row[] = $s_item_type;
	}
	
	if($is_all_item_types !== TRUE)
	{
		$results = fetch_item_attribute_type_rs($s_item_type, TRUE, TRUE);
		if($results)
		{
			while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
				if(!is_array($export_columns) || $export_columns[$fieldname] == 'Y')
				{
					if($item_attribute_type_r['s_field_type'] != 'ITEM_ID')
					{
						if($item_attribute_type_r['s_field_type'] == 'TITLE')
						{
							$row[] = $title;
						}
						else if($item_attribute_type_r['s_field_type'] == 'DURATION')
						{
							$row[] = $borrow_duration;
						}
						else if($item_attribute_type_r['s_field_type'] == 'STATUSTYPE')
						{
							$row[] = $s_status_type;
						}
						else if($item_attribute_type_r['s_field_type'] == 'STATUSCMNT')
						{
							$row[] = $status_comment;
						}
						else if($item_attribute_type_r['s_field_type'] == 'CATEGORY')
						{
							// the plugins will have to handle a array, and format it appropriately.
							$row[] = explode(' ', $category);
						}
						else 
						{
							if(export_is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
							{
								$item_lookup_attribute_val_r = fetch_lookup_attribute_val_r($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
								
								if(is_not_empty_array($item_lookup_attribute_val_r))
								{
									// the plugins will have to handle a array, and format it appropriately.
									$row[] = $item_lookup_attribute_val_r;
								}
								else
								{
									$row[] = ''; // nothing.
								}
							}
							else
							{
								$item_attribute_type_r['attribute_val'] = fetch_attribute_val($item_id, $item_attribute_type_r['s_attribute_type'],  $item_attribute_type_r['order_no']);
								if($item_attribute_type_r['attribute_val']!==FALSE)
								{
									$row[] = $item_attribute_type_r['attribute_val'];
								}
								else
								{
									$row[] = ''; // nothing.
								}
							}
						}
					}
				}
			}
			mysql_free_result($results);
		}
	}
	else
	{
		if(!is_array($export_columns) || $export_columns['title'] == 'Y')
		{
			$row[] = $title;
		}
		
		if(!is_array($export_columns) || $export_columns['category'] == 'Y')
		{
			$row[] = $category;
		}
	}
	
	return $row;
}

function get_header_row($header_type, $export_columns, $s_item_type)
{
	global $LANG_VARS;
	
	if(!is_array($export_columns) || $export_columns['item_id'] == 'Y')
	{
		if($header_type == 'data')
			$headings[] = 'item_id';
		else
			$headings[] = $LANG_VARS['item_id'];
	}
	
	if(!is_array($export_columns) || $export_columns['instance_no'] == 'Y')
	{
		if($header_type == 'data')
			$headings[] = 'instance_no';
		else
			$headings[] = $LANG_VARS['instance_no'];
	}
	
	if(!is_array($export_columns) || $export_columns['owner_id'] == 'Y')
	{
		if($header_type == 'data')
			$headings[] = 'owner_id';
		else
			$headings[] = $LANG_VARS['owner_id'];
	}
	
	if(!is_array($export_columns) || $export_columns['parent_id'] == 'Y')
	{
		if($header_type == 'data')
			$headings[] = 'parent_id';
		else
			$headings[] = $LANG_VARS['parent_id'];
	}
	
	if(!is_array($export_columns) || $export_columns['s_item_type'] == 'Y')
	{
		if($header_type == 'data')
			$headings[] = 's_item_type';
		else
			$headings[] = $LANG_VARS[ 's_item_type'];
	}
	
	if(strlen($s_item_type)>0)
	{
		// Get the item_attribute headings.
		$results = fetch_item_attribute_type_rs($s_item_type, TRUE, TRUE);
		if($results)
		{
			while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				// Only legal s_field_type's - ignore ITEM_ID!!!
				if(strlen($item_attribute_type_r['s_field_type'])==0 || 
							$item_attribute_type_r['s_field_type'] == 'TITLE' || 
							$item_attribute_type_r['s_field_type'] == 'DURATION' ||
							$item_attribute_type_r['s_field_type'] == 'STATUSTYPE' ||
							$item_attribute_type_r['s_field_type'] == 'STATUSCMNT' ||
							$item_attribute_type_r['s_field_type'] == 'CATEGORY' || 
							$item_attribute_type_r['s_field_type'] == 'IMAGE')
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
					if(!is_array($export_columns) || $export_columns[$fieldname] == 'Y')
					{
						if($header_type == 'data')
						{
							$headings[] = $fieldname;
						}
						else //if($header_type == 'prompt')
						{
							$headings[] = $item_attribute_type_r['prompt'];
						}
					}
				}
			}
			mysql_free_result($results);
		}
	}
	else
	{
		if(!is_array($export_columns) || $export_columns['title'] == 'Y')
		{
			if($header_type == 'data')
				$headings[] = 'title';
			else
				$headings[] = $LANG_VARS['title'];
		}
		
		if(!is_array($export_columns) || $export_columns['category'] == 'Y')
		{
			if($header_type == 'data')
				$headings[] = 'category';
			else
				$headings[] = $LANG_VARS['category'];
		}
	}
	return $headings;
}

/*
* Output content, in correct 'send_as_format'.  if the
* Send_as_format is not 'attachment' we assume it should be
* streamed directly to the browser.
*/
function send_data($send_as_format, $buffer)
{
	if(strlen($buffer))
	{
		if($send_as_format == 'attachment')
			echo($buffer);
		else
			echo(str_replace("\t", str_repeat("&nbsp;",8), htmlspecialchars($buffer)));
			
		// do explicit flush
		flush();
	}
}

function send_header(&$exportPlugin, $send_as_format, $page_title)
{
	if($send_as_format == 'attachment')
	{
		// hard code for now
		$filename_prefix = 'export';
	
		if(method_exists($exportPlugin, 'get_file_extension'))
		{
			$filename = $filename_prefix.'.'.$exportPlugin->get_file_extension();
		}
		else
		{
			$filename = $filename_prefix.'.txt';
		}
			
		if(method_exists($exportPlugin, 'get_file_content_type'))
		{
			$content_type = $exportPlugin->get_file_content_type();
		}
		else
		{
			$content_type = 'text/plain';
		}
		
		if(method_exists($exportPlugin, 'http_header'))
		{
			$exportPlugin->http_header(ifempty($send_as_format, 'inline'), $filename, $content_type);
		}
		else
		{
			header("Cache-control: no-store");
			header("Pragma: no-store");
			header("Expires: 0");
			header("Content-disposition: ".ifempty($send_as_format, 'inline')."; filename=$filename");
			header("Content-type: $content_type");
		}
		
		if(method_exists($exportPlugin, 'file_header'))
		{
			send_data($send_as_format, $exportPlugin->file_header($page_title));
		}
	}
	else
	{
		echo(_theme_header($page_title));
		echo("<h2>".$page_title."</h2>");

		echo("<pre>");
	}			
}

function send_footer(&$exportPlugin, $send_as_format)
{
	if($send_as_format == 'attachment')
	{
		if(method_exists($exportPlugin, 'file_footer'))
		{
			send_data($send_as_format, $exportPlugin->file_footer());
		}
	}
	else
	{
		echo("</pre>");
		echo(_theme_footer());
	}
}

function get_row_export_column_form(&$exportPlugin, $HTTP_VARS)
{
	global $LANG_VARS;
	global $PHP_SELF;
	
	$buffer .= get_setcheckboxes_javascript();
	
	$buffer .= "\n<form method=\"POST\" action=\"$PHP_SELF\">";
	$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"export\">";
	$buffer .= "\n<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"send_as_format\" value=\"".$HTTP_VARS['send_as_format']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"linked_items\" value=\"".$HTTP_VARS['linked_items']."\">";
	$buffer .= "\n<input type=\"hidden\" name=\"plugin\" value=\"".($exportPlugin!==NULL?$exportPlugin->classname:"")."\">";
	
	if(method_exists($exportPlugin, 'prompt_header') || method_exists($exportPlugin, 'data_header'))
	{		
		$buffer .= "<table border=1 cellpadding=0 cellspacing=1><tr><td><table cellspacing=1 cellpadding=3 border=0>";
		$buffer .= format_field($LANG_VARS['include_header'], NULL, "<input type=checkbox name=\"include_header\" value=\"Y\" CHECKED>");
		$buffer .= "</table></td></tr></table><br>";
	}
	
	$buffer .= "\n<table border=0 frameborder=0 cellspacing=1 cellpadding=3>";
	
	$buffer .= "\n<tr>";
	$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['item_id'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[item_id]" value="Y"'.($HTTP_VARS['linked_items']=='include'?' CHECKED':'').'></td>';
	$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['instance_no'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[instance_no]" value="Y"'.($HTTP_VARS['linked_items']=='include'?' CHECKED':'').'></td>';
	$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['owner_id'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[owner_id]" value="Y"'.(strlen($HTTP_VARS['owner_id'])==0?' CHECKED':'').'></td>';
	
	$buffer .= "</tr>\n<tr>";
	$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['parent_id'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[parent_id]" value="Y"'.($HTTP_VARS['linked_items']=='include'?' CHECKED':'').'></td>';
	$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['s_item_type'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[s_item_type]" value="Y" CHECKED></td>';
	
	if(strlen($HTTP_VARS['s_item_type'])>0)
	{
		$column_count = 2;
		// Get the item_attribute headings.
		$results = fetch_item_attribute_type_rs($HTTP_VARS['s_item_type'], TRUE, TRUE);
		if($results)
		{
			while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				if($column_count == 3)
				{
					$buffer .= "</tr>\n<tr>";
					$column_count = 0;
				}
			
				// Only legal s_field_type's - ignore ITEM_ID!!!
				if(strlen($item_attribute_type_r['s_field_type'])==0 || 
							$item_attribute_type_r['s_field_type'] == 'TITLE' || 
							$item_attribute_type_r['s_field_type'] == 'DURATION' ||
							$item_attribute_type_r['s_field_type'] == 'STATUSTYPE' ||
							$item_attribute_type_r['s_field_type'] == 'STATUSCMNT' ||
							$item_attribute_type_r['s_field_type'] == 'CATEGORY' || 
							$item_attribute_type_r['s_field_type'] == 'IMAGE')
				{
					$buffer .= '<td class="prompt" align=right>'.$item_attribute_type_r['prompt'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns['.get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']).']" value="Y"';
					
					// work out what columns to have checked by default.
					if( $item_attribute_type_r['s_field_type'] == 'TITLE' || 
								$item_attribute_type_r['s_field_type'] == 'CATEGORY' || 
								$item_attribute_type_r['s_field_type'] == 'IMAGE' || 
								(strlen($item_attribute_type_r['s_field_type'])==0 && strcasecmp(get_function_type(ifempty($item_attribute_type_r['display_type'],$item_attribute_type_r['input_type'])), "hidden")!==0) )
					{
						$buffer .= ' CHECKED';
					}
					
					$buffer .= '></td>';
					$column_count++;
				}
			}
			mysql_free_result($results);
		}
	
		for($i=$column_count; $i<3; $i++)
		{
			$buffer .= '<td class="data" colspan=2>&nbsp;</td>';
		}
	}
	else
	{
		$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['title'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[title]" value="Y" CHECKED></td>';
		$buffer .= "</tr>\n<tr>";
		$buffer .= '<td class="prompt" align=right>'.$LANG_VARS['category'].':&nbsp;</td><td class="data"><input type="checkbox" name="export_columns[category]" value="Y" CHECKED></td>';
		$buffer .= '<td class="data" colspan=2>&nbsp;</td>';
		$buffer .= '<td class="data" colspan=2>&nbsp;</td>';
	}
	
	$buffer .= "\n<tr><td colspan=6 class=\"data\">".
							"<input type=button value=\"".$LANG_VARS['check_all']."\" onClick=\"setCheckboxes(this.form, 'export_columns', true);\">&nbsp;".
							"<input type=button value=\"".$LANG_VARS['uncheck_all']."\" onClick=\"setCheckboxes(this.form, 'export_columns', false);\">&nbsp;".
							"<input type=reset value=\"".$LANG_VARS['reset']."\">".
							"</td></tr>";

	$buffer .= '</tr><tr><td align=left colspan=2>'
			.'<input type=submit value="'.$LANG_VARS['export_items'].'">'
			.'</td></tr>';
							
	$buffer .= '</table></form>';
	
	return $buffer;
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session())
	{
		// Either owner_id not specified, in which case we would export for current user, or owner_id is specified
		// and is the same as current user or user is admin, where no item_id specified.
		if( is_numeric($HTTP_VARS['item_id']) || 
					( $HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] && 
							is_user_normal($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) ) || 
					is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
		{
			if($HTTP_VARS['op'] == 'export')
			{
				if(is_export_plugin($HTTP_VARS['plugin']))
				{
					$pluginRef = $HTTP_VARS['plugin'];
							
					include_once("./export/".$pluginRef.".php");
					$exportPlugin =& new $pluginRef();
					if($exportPlugin !== NULL)
					{
						// only allow inline if content type is text based.
						if($HTTP_VARS['send_as_format'] != 'attachment')
						{
							if(!starts_with($exportPlugin->get_file_content_type(), 'text/'))
							{
								$HTTP_VARS['send_as_format'] = 'attachment';
							}
						}
									
						if(strlen($HTTP_VARS['s_item_type'])==0 || is_valid_item_type_structure($HTTP_VARS['s_item_type']))
						{
							if($exportPlugin->get_plugin_type() == 'row')
							{
								// Work out page title.
								if(strlen($HTTP_VARS['owner_id'])>0)
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id'], 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_name_item_type']);
								else if(strlen($HTTP_VARS['s_item_type'])>0)
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_item_type']);
								else
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name()), $LANG_VARS['type_export']);
								
								if(is_not_empty_array($HTTP_VARS['export_columns']))
								{
									if($HTTP_VARS['send_as_format'] != 'attachment' && $HTTP_VARS['op2'] != 'exporting')
									{
										echo(_theme_header($page_title));
										echo("<h2>".$page_title."</h2>");
										echo("\n<form action=\"$PHP_SELF\" method=\"post\" name=\"export_progress\">");
										echo(get_url_fields($HTTP_VARS, array('op2'=>'exporting')));
										echo("<br><br><br><div class=\"colortext\" align=\"center\"><strong>".$LANG_VARS['export_progress_message']."</strong></div>");
										echo("</form>\n");
										
										echo('<script language="JavaScript">'
											.'window.onload = function loadExport(){document.forms[\'export_progress\'].submit();}'
											.'</script>');
											
										echo(_theme_footer());
									}
									else
									{
										@set_time_limit(600);
										if(!export_row_items($exportPlugin, $HTTP_VARS['send_as_format'], $page_title, $HTTP_VARS['include_header'], $HTTP_VARS['export_columns'], $HTTP_VARS['s_item_type'], $HTTP_VARS['owner_id'], $HTTP_VARS['linked_items']!='exclude'))
										{
											echo _theme_header($page_title);
											echo("<h2>".$page_title."</h2>");
											echo format_error_block(array('error'=>$LANG_VARS['no_records_found'],'detail'=>''));
											echo _theme_footer();
										}
									}
								}
								else
								{
									echo _theme_header($page_title);
									echo("<h2>".$page_title."</h2>");
									
									echo("<h3>".$LANG_VARS['choose_export_columns']."</h3>");
										
									echo(get_row_export_column_form($exportPlugin, $HTTP_VARS));
										
									echo _theme_footer();
								}
							}
							else if($exportPlugin->get_plugin_type() == 'item')
							{
								// Work out page title.
								if(strlen($HTTP_VARS['owner_id'])>0 || is_numeric($HTTP_VARS['item_id']))
								{
									if(strlen($HTTP_VARS['owner_id'])>0 && strlen($HTTP_VARS['s_item_type'])>0)
										$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id'], 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_name_item_type']);
									else if(strlen($HTTP_VARS['s_item_type'])>0)
										$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_item_type']);
									else if(is_numeric($HTTP_VARS['item_id']) && is_numeric($HTTP_VARS['instance_no']))
									{
										$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
										$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 'item_id'=>$HTTP_VARS['item_id'],'instance_no'=>$HTTP_VARS['instance_no'],'title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['type_export_for_item_instance']);
									}
									else if(is_numeric($HTTP_VARS['item_id']))
									{
										// Not really a child item, but we are not interested in the instance, so use this.  It still
										// returns the right data anyway.
										$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
										$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 'item_id'=>$HTTP_VARS['item_id'],'title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['type_export_for_item']);
									}
									else
									{
										$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name(), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_export_for_name']);
									}
								}//if(strlen($HTTP_VARS['owner_id'])>0 || is_numeric($HTTP_VARS['item_id']))
								else
								{
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name()), $LANG_VARS['type_export']);
								}
								
								if($HTTP_VARS['send_as_format'] != 'attachment' && $HTTP_VARS['op2'] != 'exporting')
								{
									echo(_theme_header($page_title));
									echo("<h2>".$page_title."</h2>");
									echo("\n<form action=\"$PHP_SELF\" method=\"post\" name=\"export_progress\">");
									echo(get_url_fields($HTTP_VARS, array('op2'=>'exporting')));
									echo("<br><br><br><div class=\"colortext\" align=\"center\"><strong>".$LANG_VARS['export_progress_message']."</strong></div>");
									echo("</form>\n");
										
									echo('<script language="JavaScript">'
										.'window.onload = function loadExport(){document.forms[\'export_progress\'].submit();}'
										.'</script>');
											
									echo(_theme_footer());
								}
								else
								{
									@set_time_limit(600);
									if(!export_type_items($exportPlugin, $HTTP_VARS['send_as_format'], $page_title, $HTTP_VARS['s_item_type'], $HTTP_VARS['item_id'], $HTTP_VARS['instance_no'], $HTTP_VARS['owner_id'], $HTTP_VARS['linked_items']!='exclude'))
									{
										echo _theme_header($page_title);
										echo("<h2>".$page_title."</h2>");
										echo format_error_block(array('error'=>$LANG_VARS['no_records_found'],'detail'=>''));
										echo _theme_footer();
									}
								}
							}//get_plugin_type() not supported.
							else
							{
								echo _theme_header($LANG_VARS['undefined_error']);
								echo _theme_error($LANG_VARS['undefined_error']);
								echo _theme_footer();
							}
						}//if(strlen($HTTP_VARS['s_item_type'])==0 || is_valid_item_type_structure($HTTP_VARS['s_item_type']))
						else
						{
							$page_title = replace_lang_vars(array('type'=>get_display_export_type($pluginRef), 'description'=>$exportPlugin->get_display_name()), $LANG_VARS['type_export']);
							echo _theme_header($page_title);
							echo("<h2>".$page_title."</h2>");
							echo(format_error_block(array('error'=>replace_lang_var("s_item_type", $HTTP_VARS['s_item_type'], $LANG_VARS['invalid_item_type_structure']),'detail'=>'')));
							echo _theme_footer();
						}
					}//if($importPlugin !== NULL)
					else
					{
						echo _theme_header($LANG_VARS['undefined_error']);
						echo _theme_error($LANG_VARS['undefined_error']);
						echo _theme_footer();
					}
				}
				else //if(is_export_plugin($HTTP_VARS['plugin']))
				{
					echo _theme_header($LANG_VARS['undefined_error']);
					echo _theme_error($LANG_VARS['undefined_error']);
					echo _theme_footer();
				}
			}
			else
			{
				// A custom title.
				if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && strlen($HTTP_VARS['owner_id'])==0)
					$page_title = $LANG_VARS['export_items'];
				else if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || strlen($HTTP_VARS['owner_id'])==0)
					$page_title = $LANG_VARS['export_my_items'];
					
				echo _theme_header($page_title);
				echo("<h2>".$page_title."</h2>");
				
				echo("<form method=\"get\" action=\"$PHP_SELF\">");
				echo("<table border=0 frameborder=0 cellspacing=1>");
				echo("\n<input type=hidden name=\"op\" value=\"export\">");
				
				// Item Type select block.
				echo format_field(
						$LANG_VARS['item_type'], 
						NULL,
						"<select name=\"s_item_type\">".
							"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
							custom_select(
									's_item_type', 
									fetch_item_type_rs(),
									'%s_item_type% - %description%',
									'NA',
									NULL,
									's_item_type').
						"\n</select>"
					);
					
				if($CONFIG_VARS['item_input.linked_item_support']!==FALSE)
				{
					echo format_field(
						$LANG_VARS['linked_item(s)'],
						NULL,
							"\n<input type=radio name=\"linked_items\" value=\"include\">".$LANG_VARS['include']."&nbsp;&nbsp;".
	 							"<input type=radio name=\"linked_items\" value=\"exclude\" CHECKED>".$LANG_VARS['exclude']);
				}
							
				// Do not show OwnerID field, if not an admin user.
				if($HTTP_VARS['owner_id'] != $HTTP_SESSION_VARS['user_id'] && is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
				{
					// Item Type field.
					echo format_field(
							$LANG_VARS['owner'], 
							NULL,
							"\n<select name=\"owner_id\">".
								"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
								custom_select(
									'owner_id', 
									fetch_user_rs(get_owner_user_types_r()), 
									'%fullname% (%user_id%)',
									'NA',
									NULL,
									'user_id'
								).
								"\n</select>"
							);
				}
				else
				{
					echo("<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");
				}
				
				$field = "\n<select name=\"plugin\">\n";
				$export_type_r = get_export_r();
				if(is_array($export_type_r))
				{
					while(list(,$pluginRef) = @each($export_type_r))
					{
						include_once("./export/".$pluginRef.".php");
						$exportPlugin = new $pluginRef();
						if($exportPlugin !== NULL)
						{
							if(strcmp($pluginRef, $exportPlugin->classname) === 0)
							{
								$field .= '<option value="'.$exportPlugin->classname.'">'.get_display_export_type($exportPlugin->classname).' - '.$exportPlugin->get_display_name()."\n";
							}
							else
							{
								opendb_log('Export class \''.$pluginRef.'\' does not have a valid \'var $classname\' ('.$exportPlugin->classname.').');
							}
						}
					}
				}
				$field .= "</select>";
				
				echo format_field(
					$LANG_VARS['type'], 
					NULL, 
					$field
				);
				
				echo format_field(
					$LANG_VARS['send_as_file'],
					NULL,
					"<input type=\"checkbox\" name=\"send_as_format\" value=\"attachment\" CHECKED>");
				
				echo("<tr><td align=left colspan=2>");
				echo("<input type=submit value=\"".$LANG_VARS['export_items']."\">");
				echo("</td></tr>");
		
				echo("</table>");
				echo("</form>");
				
				echo _theme_footer();
			}
		}
		else//no guests or borrowers allowed!
		{
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
			echo _theme_footer();
		}	
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
