// 2DBasicView.h : interface of the C2DBasicView2D class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_2DBASICVIEW2D_H__147EAB5E_1BF1_11D2_8E0D_0800369C8A03_2D_INCLUDED_)
#define AFX_2DBASICVIEW2D_H__147EAB5E_1BF1_11D2_8E0D_0800369C8A03_2D_INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <OCC_2dView.h>

#include "OCC_2dDoc.h"
#include "Resource2d/RectangularGrid.h"
#include "Resource2d/CircularGrid.h"


class C2DBasicView2D : public OCC_2dView
{
protected: // create from serialization only
	C2DBasicView2D();
	DECLARE_DYNCREATE(C2DBasicView2D)

// Attributes
public:
	OCC_2dDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(C2DBasicView2D)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
    //}}AFX_VIRTUAL

// Implementation
public:
	virtual ~C2DBasicView2D();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(C2DBasicView2D)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
    afx_msg void OnFileExportImage();
   	afx_msg void OnBUTTONGridRectLines();
	afx_msg void OnBUTTONGridRectPoints();
	afx_msg void OnBUTTONGridCircLines();
	afx_msg void OnBUTTONGridCircPoints();
	afx_msg void OnBUTTONGridValues();
    afx_msg void OnUpdateBUTTONGridValues(CCmdUI* pCmdUI);
	afx_msg void OnBUTTONGridCancel();
	afx_msg void OnUpdateBUTTONGridCancel(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBUTTONFitAll();
	afx_msg void OnBUTTONGlobPanning();
	afx_msg void OnBUTTONPanning();
	afx_msg void OnBUTTONZoomProg();
	afx_msg void OnBUTTONZoomWin();
	afx_msg void OnUpdateBUTTON2DGlobPanning(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTON2DPanning(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTON2DZoomProg(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTON2DZoomWin(CCmdUI* pCmdUI);
	afx_msg void OnChangeBackground();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    CurrentAction2d myCurrentMode;
    Standard_Integer myXmin;
    Standard_Integer myYmin;
    Standard_Integer myXmax;
    Standard_Integer myYmax;
    Quantity_Factor myCurZoom;

private:
	enum LineStyle { Solid, Dot, ShortDash, LongDash, Default };
	CPen*  m_Pen;
    virtual void DrawRectangle2D (const Standard_Integer  MinX  ,
    					        const Standard_Integer  MinY  ,
                                const Standard_Integer  MaxX  ,
				    	        const Standard_Integer  MaxY  ,
					            const Standard_Boolean  Draw  ,
                                const LineStyle aLineStyle = Default  );


private :

    void DragEvent2D       (const Standard_Integer  x       ,
	    			        const Standard_Integer  y       ,
		    		        const Standard_Integer  TheState);
    void InputEvent2D      (const Standard_Integer  x       ,
	    			        const Standard_Integer  y       );  
    void MoveEvent2D       (const Standard_Integer  x       ,
                            const Standard_Integer  y       ); 
    void MultiMoveEvent2D  (const Standard_Integer  x       ,
                            const Standard_Integer  y       ); 
    void MultiDragEvent2D  (const Standard_Integer  x       ,
	    				    const Standard_Integer  y       ,
		    			    const Standard_Integer  TheState); 
    void MultiInputEvent2D (const Standard_Integer  x       ,
	    				    const Standard_Integer  y       ); 
    void Popup2D           (const Standard_Integer  x       ,
		    			    const Standard_Integer  y      ); 


private:
  CRectangularGrid TheRectangularGridDialog;
  CCircularGrid    TheCircularGridDialog;

};

#ifndef _DEBUG  // debug version in 2DBasicView.cpp
inline OCC_2dDoc* C2DBasicView2D::GetDocument()
   { return (OCC_2dDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_2DBASICVIEW2D_H__147EAB5E_1BF1_11D2_8E0D_0800369C8A03_2D_INCLUDED_)
