// TopologyAnalysisDoc.cpp : implementation of the CTopologyAnalysisDoc class
//

#include "stdafx.h"

#include "TopologyAnalysisDoc.h"

#include "TopologyAnalysisApp.h"
#include "ResultDialog.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CTopologyAnalysisDoc

IMPLEMENT_DYNCREATE(CTopologyAnalysisDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyAnalysisDoc, OCC_3dDoc)
	//{{AFX_MSG_MAP(CTopologyAnalysisDoc)
	ON_COMMAND(ID_VALID, OnValid)
	ON_COMMAND(ID_LINEAR, OnLinear)
	ON_COMMAND(ID_VOLUME, OnVolume)
	ON_COMMAND(ID_SURFACE, OnSurface)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyAnalysisDoc construction/destruction

CTopologyAnalysisDoc::CTopologyAnalysisDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyAnalysisDoc::~CTopologyAnalysisDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyAnalysisDoc diagnostics

#ifdef _DEBUG
void CTopologyAnalysisDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyAnalysisDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CTopologyAnalysisDoc::OnValid() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S = BRepPrimAPI_MakeBox(200.,300.,150.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S = BRepPrimI_MakeBox(200.,300.,150.);\n\
Standard_Boolean theShapeIsValid = BRepAlgo::IsValid(S);\n\
if ( theShapeIsValid )\n\
{\n\
  MessageBox(\"The Shape Is Valid !! \",\"Checking Shape\");\n\
}\n\
else\n\
{\n\
  MessageBox(\"The Shape Is NOT Valid !! \",\"Checking Shape\");\n\
}\n\
\n");
	PocessTextInDialog("Check a shape", Message);

	Standard_Boolean theShapeIsValid = BRepAlgo::IsValid(S);
	if ( theShapeIsValid )
	{
		MessageBox(0,"The Shape Is Valid !! ","Checking Shape",MB_OK);
	}
	else
	{
		MessageBox(0,"The Shape Is NOT Valid !! ","Checking Shape",MB_OK);
	}


}


void CTopologyAnalysisDoc::OnLinear() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}


	TColgp_Array1OfPnt Points1(1,4);
	Points1.SetValue(1,gp_Pnt(0,0,0));
	Points1.SetValue(2,gp_Pnt(2,1,0));
	Points1.SetValue(3,gp_Pnt(4,0,0));
	Points1.SetValue(4,gp_Pnt(6,2,0));
	GeomAPI_PointsToBSpline PTBS1(Points1);
	Handle(Geom_BSplineCurve) BSC1 = PTBS1.Curve();
	TopoDS_Edge S = BRepBuilderAPI_MakeEdge(BSC1).Edge();

	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	Fit();


	GProp_GProps System;
	BRepGProp::LinearProperties(S,System);
	gp_Pnt G = System.CentreOfMass ();
	Standard_Real Length = System.Mass();
	gp_Mat I = System.MatrixOfInertia();

	TCollection_AsciiString string("Length Of all the Edges =");
	TCollection_AsciiString string1(Length);
	
	string += string1;
	string += "\nCenterOfMass : \n   X=";
	string1 = G.X();
	string += string1;
	string += " Y=";
	string1 = G.Y();
	string += string1;
	string += " Z=";
	string1 = G.Z();
	string += string1;
	string +="\n";

	string += "Matrix of Inertia :\n     ";
	string1 = I(1,1);
	string += string1;
	string += " " ;
	string1 = I(1,2);
	string += string1;
	string += " " ;
	string1 = I(1,3);
	string += string1;
	string += "\n     " ;
	string1 = I(2,1);
	string += string1;
	string += " " ;
	string1 = I(2,2);
	string += string1;
	string += " " ;
	string1 = I(2,3);
	string += string1;
	string += "\n     " ;
	string1 = I(3,1);
	string += string1;
	string += " " ;
	string1 = I(3,2);
	string += string1;
	string += " " ;
	string1 = I(3,3);
	string += string1;
	string += "\n" ;
	Standard_CString CSTR = string.ToCString();
	TCollection_AsciiString Message ("\
		\n\
TColgp_Array1OfPnt Points1(1,4);\n\
Points1.SetValue(1,gp_Pnt(0,0,0));\n\
Points1.SetValue(2,gp_Pnt(2,1,0));\n\
Points1.SetValue(3,gp_Pnt(4,0,0));\n\
Points1.SetValue(4,gp_Pnt(6,2,0));\n\
GeomAPI_PointsToBSpline PTBS1(Points1);\n\
Handle(Geom_BSplineCurve) BSC1 = PTBS1.Curve();\n\
TopoDS_Shape S = BRepBuilderAPI_MakeEdge(BSC1).Edge();\n\
GProp_GProps System;\n\
BRepGProp::LinearProperties(S,System);\n\
gp_Pnt G = System.CentreOfMass ();\n\
Standard_Real Length = System.Mass();\n\
gp_Mat I = System.MatrixOfInertia();\n\
\n");
	PocessTextInDialog("Linear Properties", Message);
	MessageBox(0,CSTR,"Linear Properties",MB_OK);

}

void CTopologyAnalysisDoc::OnSurface() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TColgp_Array1OfPnt Pnts1(1,3);
	TColgp_Array1OfPnt Pnts2(1,3);
	TColgp_Array1OfPnt Pnts3(1,3);
	TColgp_Array1OfPnt Pnts4(1,3);

	Pnts1(1) = gp_Pnt(0,0,0);
	Pnts1(2) = gp_Pnt(5,0,0);
	Pnts1(3) = gp_Pnt(10,10,0);

	Pnts2(1) = gp_Pnt(10,10,0);
	Pnts2(2) = gp_Pnt(5,12,4);
	Pnts2(3) = gp_Pnt(0,15,10);

	Pnts3(1) = gp_Pnt(0,15,10);
	Pnts3(2) = gp_Pnt(-12,10,11);
	Pnts3(3) = gp_Pnt(-10,5,13);

	Pnts4(1) = gp_Pnt(-10,5,13);
	Pnts4(2) = gp_Pnt(-2,-2,2);
	Pnts4(3) = gp_Pnt(0,0,0);
	
	GeomAPI_PointsToBSpline PTBS1(Pnts1);
	GeomAPI_PointsToBSpline PTBS2(Pnts2);
	GeomAPI_PointsToBSpline PTBS3(Pnts3);
	GeomAPI_PointsToBSpline PTBS4(Pnts4);
	Handle(Geom_BSplineCurve) C1 = PTBS1.Curve();
	Handle(Geom_BSplineCurve) C2 = PTBS2.Curve();
	Handle(Geom_BSplineCurve) C3 = PTBS3.Curve();
	Handle(Geom_BSplineCurve) C4 = PTBS4.Curve();

	GeomFill_BSplineCurves fill; 
	fill.Init(C1,C2,C3,C4,GeomFill_CoonsStyle);
	Handle(Geom_BSplineSurface) BSS = fill.Surface();

	TopoDS_Shape S = BRepBuilderAPI_MakeFace(BSS).Face();

	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	Fit();


	GProp_GProps System;
	BRepGProp::SurfaceProperties(S,System);
	gp_Pnt G = System.CentreOfMass ();
	Standard_Real Area = System.Mass();
	gp_Mat I = System.MatrixOfInertia();

	TCollection_AsciiString string("Area Of the Face =");
	TCollection_AsciiString string1(Area);
	
	string += string1;
	string += "\nCenterOfMass : \n   X=";
	string1 = G.X();
	string += string1;
	string += " Y=";
	string1 = G.Y();
	string += string1;
	string += " Z=";
	string1 = G.Z();
	string += string1;
	string +="\n";

	string += "Matrix of Inertia :\n     ";
	string1 = I(1,1);
	string += string1;
	string += " " ;
	string1 = I(1,2);
	string += string1;
	string += " " ;
	string1 = I(1,3);
	string += string1;
	string += "\n     " ;
	string1 = I(2,1);
	string += string1;
	string += " " ;
	string1 = I(2,2);
	string += string1;
	string += " " ;
	string1 = I(2,3);
	string += string1;
	string += "\n     " ;
	string1 = I(3,1);
	string += string1;
	string += " " ;
	string1 = I(3,2);
	string += string1;
	string += " " ;
	string1 = I(3,3);
	string += string1;
	string += "\n" ;
	Standard_CString CSTR = string.ToCString();
	TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S = BRepBuilderAPI_MakeFace(BSplineSurf).Face();\n\
GProp_GProps System;\n\
BRepGProp::SurfaceProperties(S,System);\n\
gp_Pnt G = System.CentreOfMass ();\n\
Standard_Real Area = System.Mass();\n\
gp_Mat I = System.MatrixOfInertia();\n\
\n");
	PocessTextInDialog("Surface Properties", Message);
	MessageBox(0,CSTR,"Surface Properties",MB_OK);

}

void CTopologyAnalysisDoc::OnVolume() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	

	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	Fit();


	GProp_GProps System;
	BRepGProp::VolumeProperties(S,System);
	gp_Pnt G = System.CentreOfMass ();
	Standard_Real Volume = System.Mass();
	gp_Mat I = System.MatrixOfInertia();

	TCollection_AsciiString string("Volume Of all the Shape =");
TCollection_AsciiString string1(Volume);
	
	string += string1;
	string += "\nCenterOfMass : \n   X=";
	string1 = G.X();
	string += string1;
	string += " Y=";
	string1 = G.Y();
	string += string1;
	string += " Z=";
	string1 = G.Z();
	string += string1;
	string +="\n";

	string += "Matrix of Inertia :\n     ";
	string1 = I(1,1);
	string += string1;
	string += " " ;
	string1 = I(1,2);
	string += string1;
	string += " " ;
	string1 = I(1,3);
	string += string1;
	string += "\n     " ;
	string1 = I(2,1);
	string += string1;
	string += " " ;
	string1 = I(2,2);
	string += string1;
	string += " " ;
	string1 = I(2,3);
	string += string1;
	string += "\n     " ;
	string1 = I(3,1);
	string += string1;
	string += " " ;
	string1 = I(3,2);
	string += string1;
	string += " " ;
	string1 = I(3,3);
	string += string1;
	string += "\n" ;
		Standard_CString CSTR = string.ToCString();
	TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.);;\n\
GProp_GProps System;\n\
BRepGProp::VolumeProperties(S,System);\n\
gp_Pnt G = System.CentreOfMass ();\n\
Standard_Real Volume = System.Mass();\n\
gp_Mat I = System.MatrixOfInertia();\n\
\n");
	PocessTextInDialog("Volume Properties", Message);
	MessageBox(0,CSTR,"Volume Properties",MB_OK);

}
