// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_Printer_HeaderFile
#define _Message_Printer_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Message_Printer_HeaderFile
#include <Handle_Message_Printer.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Message_Gravity_HeaderFile
#include <Message_Gravity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class TCollection_ExtendedString;
class TCollection_AsciiString;


//! Abstract interface class defining printer as output context for <br>
//!          text messages <br>
//! <br>
//!          The message, besides being text string, has associated gravity <br>
//!          level, which can be used by printer to decide either to process <br>
//!          a message or ignore it. <br>
class Message_Printer : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Send a string message with specified trace level. <br>
//!          The parameter putEndl specified whether end-of-line <br>
//!          should be added to the end of the message. <br>
//!          This method must be redefined in descentant. <br>
Standard_EXPORT virtual  void Send(const TCollection_ExtendedString& theString,const Message_Gravity theGravity,const Standard_Boolean putEndl) const = 0;

//! Send a string message with specified trace level. <br>
//!          The parameter putEndl specified whether end-of-line <br>
//!          should be added to the end of the message. <br>
//!          Default implementation calls first method Send(). <br>
Standard_EXPORT virtual  void Send(const Standard_CString theString,const Message_Gravity theGravity,const Standard_Boolean putEndl) const;

//! Send a string message with specified trace level. <br>
//!          The parameter putEndl specified whether end-of-line <br>
//!          should be added to the end of the message. <br>
//!          Default implementation calls first method Send(). <br>
Standard_EXPORT virtual  void Send(const TCollection_AsciiString& theString,const Message_Gravity theGravity,const Standard_Boolean putEndl) const;
//Standard_EXPORT ~Message_Printer();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
