// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepToIGES_BRShell_HeaderFile
#define _BRepToIGES_BRShell_HeaderFile

#ifndef _BRepToIGES_BREntity_HeaderFile
#include <BRepToIGES_BREntity.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class BRepToIGES_BREntity;
class IGESData_IGESEntity;
class TopoDS_Shape;
class TopoDS_Shell;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the transfer of Shape Entities from Geom <br>
//!          To IGES. These can be : <br>
//!            . Vertex <br>
//!            . Edge <br>
//!            . Wire <br>
class BRepToIGES_BRShell  : public BRepToIGES_BREntity {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepToIGES_BRShell();


Standard_EXPORT BRepToIGES_BRShell(const BRepToIGES_BREntity& BR);

//!  Transfert an Shape entity from TopoDS to IGES <br>
//!            This entity must be a Face or a Shell. <br>
//!            If this Entity could not be converted, this member returns a NullEntity. <br>
Standard_EXPORT   Handle_IGESData_IGESEntity TransferShell(const TopoDS_Shape& start) ;

//!  Transfert an Shell entity from TopoDS to IGES <br>
//!            If this Entity could not be converted, this member returns a NullEntity. <br>
Standard_EXPORT   Handle_IGESData_IGESEntity TransferShell(const TopoDS_Shell& start) ;

//!  Transfert a Face entity from TopoDS to IGES <br>
//!            If this Entity could not be converted, this member returns a NullEntity. <br>
Standard_EXPORT   Handle_IGESData_IGESEntity TransferFace(const TopoDS_Face& start) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
