# Coming into this file, the make variable CURRENT should have been defined.

# On VMS we frequently need to be able to switch between VMS and UNIX
# syntax so we will be doing stuff like the following quite a bit:

TOP_V=$(SUBST ..,-,$(TOP))
TOP_V=$(SUBST /,.,$(TOP_V))
TOP_V=[$(SUBST .-,-,$(TOP_V))]

MK_V=$(SUBST ..,-,$(TOP)/mk)
MK_V=$(SUBST /,.,$(MK_V))
MK_V=[$(SUBST .-,-,$(MK_V))]

# Either uncomment out one of the platform lines below or use the autoconfig
# mechanism by uncommenting out this line

autoconfig=1

#platform=OpenVMS_Alpha_6_2	# OpenVMS Alpha 6.2 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_1	# OpenVMS Alpha 7.1 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_2	# OpenVMS Alpha 7.2 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_3	# OpenVMS Alpha 7.2 DEC/Compaq/HP C++ 6.x

# Also enable the following (if autoconfig is not used):
# CXX6=1	# Compaq C++ 6.x compiler (Alpha only)

# Enable one of the following for the release version of the libraries.  (Note
# that /Debug=all may seem odd for release builds, but could be useful for
# running PCA or analyzing crash dumps).

# RELEASE_DEBUG=/NoDebug
# RELEASE_DEBUG=/Debug=all
RELEASE_DEBUG=/Debug=trace

# enable this to link against shareable images
USE_SHAREABLE_IMAGES=1

# Set the verification level of compilations here.  I.e., if you want only brief
# messages ("Compiling foo.cc...") set this to 0 or comment it out.
# COMPILE_VERIFY=1
.ifdef COMPILE_VERIFY
.else
VERBOSITY=@
.endif

# If you want to exclude BOA support in the COS library, uncomment the
# following:
# COS_NO_BOA=1

EXPORT_TREE =  $(TOP)

IMPORT_TREES = $(TOP)

# Macro to indicate whether the current directory has been initialized.
CURRENT_ID_=$(SUBST /,_,$(CURRENT))
dir_initialized=_$(CURRENT_ID_)_initialized_

# If the directory has been initialized then $(dir_initialized) will be defined
# in the following.

.include $(TOP)/mk/dirs.mms

# If the directory has been initialized then go ahead and build

.ifdef $(dir_initialized)

.ifdef autoconfig
.include $(TOP)/mk/platform.mms
.endif

.include $(TOP)/mk/beforedir.mms
.include dir.mms
.include dependencies.d

# otherwise initialize the directory, add $(dir_initialized)=1 to
# $(TOP)/mk/dirs.mms then recurse.

.else

.default
	$(VERBOSITY) ! $@

.ifdef VERBOSITY
premakeverbosity=,VERBOSITY="$(VERBOSITY)"
.endif

.ifdef COMPILE_VERIFY
premakecompileverify=,COMPILE_VERIFY="$(COMPILE_VERIFY)"
.endif

premakemacroqual=/macro=(dir.mms,MK_V="$(MK_V)"\
,dir_initialized="$(dir_initialized)"$(premakeverbosity)$(premakecompileverify))

premake ::
	$(VERBOSITY) mms /extended$(premakemacroqual)/descr=$(MK_V)premake.mms

all :: premake
	$(VERBOSITY) $(mms) $(mmsqualifiers) $(mmstargets)

export :: all

.endif

.include $(MK_V)afterdir.mms
