#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "unit.h"
#include "units_info.h"
#include "parse_input.h"
#include "version.h"
#include "sim.h"
#include "random.h"
#include "report.h"

int main(int argc, char **argv)
{
  sim_info * sim = parse_input(argc, argv);
  
  // инициализируем рандом-генератор числом
  // зависящим от текущего времени
  time_t t;
  srandom( time(&t) );
  sims_result * sres=simulator(sim);

  print_report(sres);

  free(sim); free(sres);
  return 0;
}
