// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "globals.h"
#include "ftglfontmanager.h"
#include "figure.h"

#include <sstream>

FTGLFontManager& FTGLFontManager::Instance()
{
  static FTGLFontManager tm;
  return tm;
}

//! Deletes all fonts associated with a handle. Usually called when the
// handle is invalidated (i.e. figure closes)
void FTGLFontManager::DeleteHandleFonts(ocpl::Handle hnd)
{
  std::stringstream strhnd;

  strhnd << "|" << hnd ;
  
  FontIter font;
  for( font = fonts.begin(); font != fonts.end(); font++) {
    if( font->first.find(strhnd.str()) != std::string::npos ) {
      delete font->second;
      fonts.erase(font);
    }
  }
}

FontType* FTGLFontManager::GetFont( const char *filename, int size, ocpl::Handle hnd)
{
  std::stringstream fontKey;
  String& dir = Get<String>( (ocpl::Handle) 0 , "DefaultFontDir");

  fontKey << filename << size << "|" << hnd;

  FontIter result = fonts.find( fontKey.str());
  if( result != fonts.end()) {
    return result->second;
  }
        
  std::stringstream fullpath;

  fullpath << dir() << "/" << filename ;

  FontType* font = new FontType(fullpath.str().c_str());

  if( !font || font->Error() )
  {
    cout << "Font " << fullpath.str() << " failed to open\n";
    delete font;
    return NULL;
  }
            
  if( !font->FaceSize( size))
  {
    cout <<  "Font " << fullpath.str() << " failed to set size " << size << "\n";
    delete font;
    return NULL;
  }
     
  fonts[fontKey.str()] = font;

  return font;
        
}

