

%  This example demonstrates the use of vtkSTLReader to load data into
%  VTK 
%  its graphical representation of the data to maintain interactive
%  performance.

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Create the reader and read a data file.  Connect the mapper and
%  actor.
sr = vtkSTLReader();
sr.SetFileName(strcat(VTK_DATA_ROOT,"/Data/42400-IDGH.stl"));

stlMapper = vtkPolyDataMapper();
stlMapper.SetInput(sr.GetOutput());

stlActor = vtkLODActor();
stlActor.SetMapper(stlMapper);

%  Create the Renderer, RenderWindow, and RenderWindowInteractor
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the render; set the background and size
ren.AddActor(stlActor);
ren.SetBackground(0.1, 0.2, 0.4);
renWin.SetSize(500, 500);

%  Zoom in closer
cam1 = ren.GetActiveCamera();
cam1.Zoom(1.4);


% renWin.Render();
vtkInitializeInteractor(iren);
