

%  Perform psuedo volume rendering in a structured grid by compositing
%  translucent cut planes. This same trick can be used for unstructured
%  grids. Note that for better results, more planes can be created. Also,
%  if your data is vtkImageData, there are much faster methods for volume
%  rendering.

vtk_init;
vtkColors;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Create pipeline. Read structured grid data.
pl3d = vtkPLOT3DReader();
pl3d.SetXYZFileName(strcat(VTK_DATA_ROOT,"/Data/combxyz.bin"));
pl3d.SetQFileName(strcat(VTK_DATA_ROOT,"/Data/combq.bin"));
pl3d.SetScalarFunctionNumber(100);
pl3d.SetVectorFunctionNumber(202);
pl3d.Update();

%  A convenience, use this filter to limit data for experimentation.
extract = vtkExtractGrid();
extract.SetVOI(1, 55, -1000, 1000, -1000, 1000);
extract.SetInput(pl3d.GetOutput());

%  The (implicit) plane is used to do the cutting
plane = vtkPlane();
plane.SetOrigin(0, 4, 2);
plane.SetNormal(0, 1, 0);

%  The cutter is set up to process each contour value over all cells
%  (SetSortByToSortByCell). This results in an ordered output of polygons
%  which is key to the compositing.
cutter = vtkCutter();
cutter.SetInput(extract.GetOutput());
cutter.SetCutFunction(plane);
cutter.GenerateCutScalarsOff();
cutter.SetSortByToSortByCell();

clut = vtkLookupTable();
clut.SetHueRange(0, .67);
clut.Build();

cutterMapper = vtkPolyDataMapper();
cutterMapper.SetInput(cutter.GetOutput());
cutterMapper.SetScalarRange(.18, .7);
cutterMapper.SetLookupTable(clut);

cut = vtkActor();
cut.SetMapper(cutterMapper);

%  Add in some surface geometry for interest.
iso = vtkContourFilter();
iso.SetInput(pl3d.GetOutput());
iso.SetValue(0, .22);
normals = vtkPolyDataNormals();
normals.SetInput(iso.GetOutput());
normals.SetFeatureAngle(45);
isoMapper = vtkPolyDataMapper();
isoMapper.SetInput(normals.GetOutput());
isoMapper.ScalarVisibilityOff();
isoActor = vtkActor();
isoActor.SetMapper(isoMapper);
isoActor.GetProperty().SetDiffuseColor(tomato);
isoActor.GetProperty().SetSpecularColor(white);
isoActor.GetProperty().SetDiffuse(.8);
isoActor.GetProperty().SetSpecular(.5);
isoActor.GetProperty().SetSpecularPower(30);

outline = vtkStructuredGridOutlineFilter();
outline.SetInput(pl3d.GetOutput());
outlineTubes = vtkTubeFilter();
outlineTubes.SetInput(outline.GetOutput());
outlineTubes.SetRadius(.1);

outlineMapper = vtkPolyDataMapper();
outlineMapper.SetInput(outlineTubes.GetOutput());
outlineActor = vtkActor();
outlineActor.SetMapper(outlineMapper);

%  Create the RenderWindow, Renderer and Interactor
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(outlineActor);
outlineActor.GetProperty().SetColor(banana);
ren.AddActor(isoActor);
isoActor.VisibilityOn();
ren.AddActor(cut);
opacity = .1;
cut.GetProperty().SetOpacity(1);
ren.SetBackground(1, 1, 1);
renWin.SetSize(640, 480);

cam1 = ren.GetActiveCamera();
cam1.SetClippingRange(3.95297, 50);
cam1.SetFocalPoint(9.71821, 0.458166, 29.3999);
cam1.SetPosition(2.7439, -37.3196, 38.7167);
cam1.ComputeViewPlaneNormal();
cam1.SetViewUp(-0.16123, 0.264271, 0.950876);

		plane.SetNormal(cam1.GetViewPlaneNormal());
    plane.SetOrigin(cam1.GetFocalPoint());
    cutter.GenerateValues(20, -5, 5);
    clut.SetAlphaRange(opacity, opacity);
    % renWin.Render();


% renWin.Render();
vtkInitializeInteractor(iren);
