## Copyright (C) 2004-2011 David Legland <david.legland@grignon.inra.fr>
## Copyright (C) 2004-2011 INRA - CEPIA Nantes - MIAJ (Jouy-en-Josas)
## Copyright (C) 2012 Adapted to Octave by Juan Pablo Carbajal <carbajal@ifi.uzh.ch>
## All rights reserved.
## 
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are met:
## 
##     1 Redistributions of source code must retain the above copyright notice,
##       this list of conditions and the following disclaimer.
##     2 Redistributions in binary form must reproduce the above copyright
##       notice, this list of conditions and the following disclaimer in the
##       documentation and/or other materials provided with the distribution.
## 
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ''AS IS''
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
## ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
## DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
## SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
## CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
## OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
## OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

function spheres(varargin)
#SPHERES Description of functions operating on 3D spheres
#
#   Spheres are represented by their center and their radius:
#   S = [xc yc zc r];
#
#   An ellipsoid is defined by:
#   ELL = [XC YC ZC A B C PHI THETA PSI]
#   where [XC YC ZY] is the center, [A B C] are length of semi-axes (in
#   decreasing order), and [PHI THETA PSI] are euler angles representing
#   the ellipsoid orientation.
#
#   See also
#   createSphere, inertiaEllipsoid
#   intersectLineSphere, intersectPlaneSphere, sphericalVoronoiDomain
#   drawSphere, drawEllipsoid
#   drawSphericalEdge, drawSphericalTriangle, drawSphericalPolygon
#   fillSphericalTriangle, fillSphericalPolygon
#
# ------
# Author: David Legland
# e-mail: david.legland@grignon.inra.fr
# Created: 2008-10-13,    using Matlab 7.4.0.287 (R2007a)
# Copyright 2008 INRA - BIA PV Nantes - MIAJ Jouy-en-Josas.
