/* File generated from gstreamer_idl.idl */

#include <stddef.h>
#include <string.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include <caml/fail.h>
#include <caml/callback.h>
#ifdef Custom_tag
#include <caml/custom.h>
#include <caml/bigarray.h>
#endif
#include <caml/camlidlruntime.h>

#include "gstreamer_inc.h"
void camlidl_ml2c_gstreamer_idl_guint(value _v1, guint * _c2, camlidl_ctx _ctx)
{
  (*_c2) = Int_val(_v1);
}

value camlidl_c2ml_gstreamer_idl_guint(guint * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = Val_int((*_c2));
  return _v1;
}

void camlidl_ml2c_gstreamer_idl_gint(value _v1, gint * _c2, camlidl_ctx _ctx)
{
  (*_c2) = Int_val(_v1);
}

value camlidl_c2ml_gstreamer_idl_gint(gint * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = Val_int((*_c2));
  return _v1;
}

void camlidl_ml2c_gstreamer_idl_gchar(value _v1, gchar * _c2, camlidl_ctx _ctx)
{
  (*_c2) = Int_val(_v1);
}

value camlidl_c2ml_gstreamer_idl_gchar(gchar * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = Val_int((unsigned char)((*_c2)));
  return _v1;
}

void camlidl_ml2c_gstreamer_idl_gboolean(value _v1, gboolean * _c2, camlidl_ctx _ctx)
{
  (*_c2) = Int_val(_v1);
}

value camlidl_c2ml_gstreamer_idl_gboolean(gboolean * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = Val_int((*_c2));
  return _v1;
}

void ocaml_gst_init (int argc, char **argv) { gst_init(&argc, &argv); }
value camlidl_gstreamer_idl_ocaml_gst_init(
	value _v_argc,
	value _v_argv)
{
  int argc; /*in*/
  char **argv; /*in*/
  value _v1;
  mlsize_t _c2;
  mlsize_t _c3;
  value _v4;
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  argc = Int_val(_v_argc);
  if (_v_argv == Val_int(0)) {
    argv = NULL;
  } else {
    _v1 = Field(_v_argv, 0);
    _c2 = Wosize_val(_v1);
    argv = camlidl_malloc((_c2 + 1) * sizeof(char *), _ctx);
    for (_c3 = 0; _c3 < _c2; _c3++) {
      _v4 = Field(_v1, _c3);
      argv[_c3] = String_val(_v4);
    }
    argv[_c2] = 0;
  }
  ocaml_gst_init(argc, argv);
  camlidl_free(_ctx);
  return Val_unit;
}

value camlidl_gstreamer_idl_gst_version(value _unit)
{
  guint *major; /*out*/
  guint *minor; /*out*/
  guint *micro; /*out*/
  guint *nano; /*out*/
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  guint _c1;
  guint _c2;
  guint _c3;
  guint _c4;
  value _vresult;
  value _vres[4] = { 0, 0, 0, 0, };

  major = &_c1;
  minor = &_c2;
  micro = &_c3;
  nano = &_c4;
  gst_version(major, minor, micro, nano);
  Begin_roots_block(_vres, 4)
    _vres[0] = camlidl_c2ml_gstreamer_idl_guint(&*major, _ctx);
    _vres[1] = camlidl_c2ml_gstreamer_idl_guint(&*minor, _ctx);
    _vres[2] = camlidl_c2ml_gstreamer_idl_guint(&*micro, _ctx);
    _vres[3] = camlidl_c2ml_gstreamer_idl_guint(&*nano, _ctx);
    _vresult = camlidl_alloc_small(4, 0);
    Field(_vresult, 0) = _vres[0];
    Field(_vresult, 1) = _vres[1];
    Field(_vresult, 2) = _vres[2];
    Field(_vresult, 3) = _vres[3];
  End_roots()
  camlidl_free(_ctx);
  return _vresult;
}

value camlidl_gstreamer_idl_gst_version_string(value _unit)
{
  gchar *_res;
  value _vres;

  _res = gst_version_string();
  _vres = copy_string(_res);
  return _vres;
}

void check_null_pointer(void *p) { if (p == NULL) caml_raise_constant(*caml_named_value("gst_exn_null_pointer"));  }
void gst_finalize_element(pGstElement *o) { gst_object_unref(*o); }
void gst_finalize_bin(pGstBin *o) { gst_object_unref(*o); }
void gst_finalize_caps(pGstCaps *o) { gst_object_unref(*o); }
void camlidl_ml2c_gstreamer_idl_pGstElement(value _v1, pGstElement * _c2, camlidl_ctx _ctx)
{
  *_c2 = *((pGstElement *) Data_custom_val(_v1));
}

static void camlidl_finalize_gstreamer_idl_pGstElement(value v)
{
  gst_finalize_element((pGstElement *) Data_custom_val(v));
}
struct custom_operations camlidl_cops_gstreamer_idl_pGstElement = {
  NULL,
  camlidl_finalize_gstreamer_idl_pGstElement,
  custom_compare_default,
  custom_hash_default,
  custom_serialize_default,
  custom_deserialize_default
};

value camlidl_c2ml_gstreamer_idl_pGstElement(pGstElement * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = alloc_custom(&camlidl_cops_gstreamer_idl_pGstElement, sizeof(pGstElement), 0, 1);
  *((pGstElement *) Data_custom_val(_v1)) = *_c2;
  return _v1;
}

void camlidl_ml2c_gstreamer_idl_pGstBin(value _v1, pGstBin * _c2, camlidl_ctx _ctx)
{
  *_c2 = *((pGstBin *) Data_custom_val(_v1));
}

static void camlidl_finalize_gstreamer_idl_pGstBin(value v)
{
  gst_finalize_bin((pGstBin *) Data_custom_val(v));
}
struct custom_operations camlidl_cops_gstreamer_idl_pGstBin = {
  NULL,
  camlidl_finalize_gstreamer_idl_pGstBin,
  custom_compare_default,
  custom_hash_default,
  custom_serialize_default,
  custom_deserialize_default
};

value camlidl_c2ml_gstreamer_idl_pGstBin(pGstBin * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = alloc_custom(&camlidl_cops_gstreamer_idl_pGstBin, sizeof(pGstBin), 0, 1);
  *((pGstBin *) Data_custom_val(_v1)) = *_c2;
  return _v1;
}

void camlidl_ml2c_gstreamer_idl_pGstCaps(value _v1, pGstCaps * _c2, camlidl_ctx _ctx)
{
  *_c2 = *((pGstCaps *) Data_custom_val(_v1));
}

static void camlidl_finalize_gstreamer_idl_pGstCaps(value v)
{
  gst_finalize_caps((pGstCaps *) Data_custom_val(v));
}
struct custom_operations camlidl_cops_gstreamer_idl_pGstCaps = {
  NULL,
  camlidl_finalize_gstreamer_idl_pGstCaps,
  custom_compare_default,
  custom_hash_default,
  custom_serialize_default,
  custom_deserialize_default
};

value camlidl_c2ml_gstreamer_idl_pGstCaps(pGstCaps * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = alloc_custom(&camlidl_cops_gstreamer_idl_pGstCaps, sizeof(pGstCaps), 0, 1);
  *((pGstCaps *) Data_custom_val(_v1)) = *_c2;
  return _v1;
}

void set_element_property_string (pGstElement e, char *n, char *v) { g_object_set (e, n, v, NULL); }
value camlidl_gstreamer_idl_set_element_property_string(
	value _v_e,
	value _v_n,
	value _v_v)
{
  pGstElement e; /*in*/
  char *n; /*in*/
  char *v; /*in*/
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_e, &e, _ctx);
  n = String_val(_v_n);
  v = String_val(_v_v);
  set_element_property_string(e, n, v);
  camlidl_free(_ctx);
  return Val_unit;
}

void set_element_property_bool (pGstElement e, char *n, gboolean v) { g_object_set (e, n, v, NULL); }
value camlidl_gstreamer_idl_set_element_property_bool(
	value _v_e,
	value _v_n,
	value _v_v)
{
  pGstElement e; /*in*/
  char *n; /*in*/
  gboolean v; /*in*/
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_e, &e, _ctx);
  n = String_val(_v_n);
  camlidl_ml2c_gstreamer_idl_gboolean(_v_v, &v, _ctx);
  set_element_property_bool(e, n, v);
  camlidl_free(_ctx);
  return Val_unit;
}

void set_element_property_int (pGstElement e, char *n, gint v) { g_object_set (e, n, v, NULL); }
value camlidl_gstreamer_idl_set_element_property_int(
	value _v_e,
	value _v_n,
	value _v_v)
{
  pGstElement e; /*in*/
  char *n; /*in*/
  gint v; /*in*/
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_e, &e, _ctx);
  n = String_val(_v_n);
  camlidl_ml2c_gstreamer_idl_gint(_v_v, &v, _ctx);
  set_element_property_int(e, n, v);
  camlidl_free(_ctx);
  return Val_unit;
}

void set_element_caps (pGstElement e, pGstCaps c) { g_object_set (e, "caps", c, NULL); }
value camlidl_gstreamer_idl_set_element_caps(
	value _v_e,
	value _v_c)
{
  pGstElement e; /*in*/
  pGstCaps c; /*in*/
  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_e, &e, _ctx);
  camlidl_ml2c_gstreamer_idl_pGstCaps(_v_c, &c, _ctx);
  set_element_caps(e, c);
  camlidl_free(_ctx);
  return Val_unit;
}

value camlidl_gstreamer_idl_gst_element_link(
	value _v_src,
	value _v_dest)
{
  pGstElement src; /*in*/
  pGstElement dest; /*in*/
  gboolean _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_src, &src, _ctx);
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_dest, &dest, _ctx);
  _res = gst_element_link(src, dest);
  _vres = camlidl_c2ml_gstreamer_idl_gboolean(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

int camlidl_transl_table_gstreamer_idl_enum_1[5] = {
  GST_STATE_VOID_PENDING,
  GST_STATE_NULL,
  GST_STATE_READY,
  GST_STATE_PAUSED,
  GST_STATE_PLAYING,
};

void camlidl_ml2c_gstreamer_idl_GstState(value _v1, GstState * _c2, camlidl_ctx _ctx)
{
  (*_c2) = camlidl_transl_table_gstreamer_idl_enum_1[Int_val(_v1)];
}

value camlidl_c2ml_gstreamer_idl_GstState(GstState * _c2, camlidl_ctx _ctx)
{
value _v1;
  _v1 = camlidl_find_enum((*_c2), camlidl_transl_table_gstreamer_idl_enum_1, 5, "typedef GstState: bad enum  value");
  return _v1;
}

int camlidl_transl_table_gstreamer_idl_enum_2[4] = {
  GST_STATE_CHANGE_FAILURE,
  GST_STATE_CHANGE_SUCCESS,
  GST_STATE_CHANGE_ASYNC,
  GST_STATE_CHANGE_NO_PREROLL,
};

void camlidl_ml2c_gstreamer_idl_GstStateChangeReturn(value _v1, GstStateChangeReturn * _c2, camlidl_ctx _ctx)
{
  (*_c2) = camlidl_transl_table_gstreamer_idl_enum_2[Int_val(_v1)];
}

value camlidl_c2ml_gstreamer_idl_GstStateChangeReturn(GstStateChangeReturn * _c2, camlidl_ctx _ctx)
{
value _v1;
  switch((*_c2)) {
  case GST_STATE_CHANGE_FAILURE: _v1 = Val_int(0); break;
  case GST_STATE_CHANGE_SUCCESS: _v1 = Val_int(1); break;
  case GST_STATE_CHANGE_ASYNC: _v1 = Val_int(2); break;
  case GST_STATE_CHANGE_NO_PREROLL: _v1 = Val_int(3); break;
  default: invalid_argument("typedef GstStateChangeReturn: bad enum  value");
  }
  return _v1;
}

value camlidl_gstreamer_idl_gst_element_set_state(
	value _v_element,
	value _v_state)
{
  pGstElement element; /*in*/
  GstState state; /*in*/
  GstStateChangeReturn _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_element, &element, _ctx);
  camlidl_ml2c_gstreamer_idl_GstState(_v_state, &state, _ctx);
  _res = gst_element_set_state(element, state);
  _vres = camlidl_c2ml_gstreamer_idl_GstStateChangeReturn(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_element_factory_make(
	value _v_factoryname,
	value _v_name)
{
  gchar const *factoryname; /*in*/
  gchar const *name; /*in*/
  pGstElement _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  factoryname = String_val(_v_factoryname);
  name = String_val(_v_name);
  _res = gst_element_factory_make(factoryname, name);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstElement(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_pipeline_new(
	value _v_name)
{
  gchar const *name; /*in*/
  pGstElement _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  name = String_val(_v_name);
  _res = gst_pipeline_new(name);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstElement(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

pGstBin gst_bin_of_element(pGstElement e) { gst_object_ref(e); return (pGstBin)e; };
value camlidl_gstreamer_idl_gst_bin_of_element(
	value _v_e)
{
  pGstElement e; /*in*/
  pGstBin _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_e, &e, _ctx);
  _res = gst_bin_of_element(e);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstBin(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_bin_add(
	value _v_bin,
	value _v_element)
{
  pGstBin bin; /*in*/
  pGstElement element; /*in*/
  gboolean _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstBin(_v_bin, &bin, _ctx);
  camlidl_ml2c_gstreamer_idl_pGstElement(_v_element, &element, _ctx);
  _res = gst_bin_add(bin, element);
  _vres = camlidl_c2ml_gstreamer_idl_gboolean(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_bin_get_by_name(
	value _v_bin,
	value _v_name)
{
  pGstBin bin; /*in*/
  gchar const *name; /*in*/
  pGstElement _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstBin(_v_bin, &bin, _ctx);
  name = String_val(_v_name);
  _res = gst_bin_get_by_name(bin, name);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstElement(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_caps_to_string(
	value _v_caps)
{
  pGstCaps caps; /*in*/
  gchar *_res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  camlidl_ml2c_gstreamer_idl_pGstCaps(_v_caps, &caps, _ctx);
  _res = gst_caps_to_string(caps);
  _vres = copy_string(_res);
  camlidl_free(_ctx);
  return _vres;
}

value camlidl_gstreamer_idl_gst_caps_from_string(
	value _v_string)
{
  gchar const *string; /*in*/
  pGstCaps _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  string = String_val(_v_string);
  _res = gst_caps_from_string(string);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstCaps(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

GstElement* parse_launch(const gchar *pipeline_description) { GError *err = NULL; GstElement *e; e = gst_parse_launch(pipeline_description, &err); if (err != NULL) { value s = caml_copy_string(err->message); if (e) { gst_object_unref(e); } g_error_free(err); caml_raise_with_arg(*caml_named_value("gst_exn_gerror"), s);  } return e; };
value camlidl_gstreamer_idl_parse_launch(
	value _v_pipeline_description)
{
  gchar const *pipeline_description; /*in*/
  pGstElement _res;
  value _vres;

  struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL };
  camlidl_ctx _ctx = &_ctxs;
  pipeline_description = String_val(_v_pipeline_description);
  _res = parse_launch(pipeline_description);
  check_null_pointer(_res);
  _vres = camlidl_c2ml_gstreamer_idl_pGstElement(&_res, _ctx);
  camlidl_free(_ctx);
  return _vres;
}

 value caml_app_sink_pull_buffer(value as){ GstBuffer *gstbuf; GstElement *e; struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL }; camlidl_ctx _ctx = &_ctxs; camlidl_ml2c_gstreamer_idl_pGstElement(as, &e, _ctx); caml_enter_blocking_section(); gstbuf = gst_app_sink_pull_buffer(GST_APP_SINK(e)); if (!gstbuf) { caml_leave_blocking_section(); caml_raise_constant(*caml_named_value("gst_exn_failure")); } intnat len = gstbuf->size; char *data = malloc(len); memcpy(data, gstbuf->data, len); gst_buffer_unref (gstbuf); caml_leave_blocking_section(); value ba = caml_ba_alloc(CAML_BA_MANAGED | CAML_BA_C_LAYOUT | CAML_BA_UINT8, 1, data, &len); return ba; }
 value caml_app_sink_pull_buffer_string(value as){ GstBuffer *gstbuf; GstElement *e; struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL }; camlidl_ctx _ctx = &_ctxs; camlidl_ml2c_gstreamer_idl_pGstElement(as, &e, _ctx); caml_enter_blocking_section(); gstbuf = gst_app_sink_pull_buffer(GST_APP_SINK(e)); if (!gstbuf) { caml_leave_blocking_section(); caml_raise_constant(*caml_named_value("gst_exn_failure")); } intnat len = gstbuf->size; caml_leave_blocking_section(); value s = caml_alloc_string(len); memcpy(String_val(s), gstbuf->data, len); gst_buffer_unref (gstbuf); return s; }
 value caml_app_src_push_buffer_string(value as, value buf){ int buflen = caml_string_length(buf); GstBuffer *gstbuf = gst_buffer_new_and_alloc(buflen); memcpy(GST_BUFFER_DATA(gstbuf), String_val(buf), buflen); GstFlowReturn ret; GstElement *e; struct camlidl_ctx_struct _ctxs = { CAMLIDL_TRANSIENT, NULL }; camlidl_ctx _ctx = &_ctxs; camlidl_ml2c_gstreamer_idl_pGstElement(as, &e, _ctx); caml_enter_blocking_section(); ret = gst_app_src_push_buffer(GST_APP_SRC(e), gstbuf); if (ret != GST_FLOW_OK) { caml_leave_blocking_section(); caml_raise_constant(*caml_named_value("gst_exn_failure")); } caml_leave_blocking_section(); return Val_unit; }
