<?php
///////////////////////////////////////////////////////////////////////////////
// OBM - File : odt_index.inc
//     - Desc : odt Main file
// 2006-02-04 Aliacom - Pierre Baudracco
///////////////////////////////////////////////////////////////////////////////
// $Id: odt_index.php 1200 2006-10-09 14:26:32Z vincentc $
///////////////////////////////////////////////////////////////////////////////
// Actions :
// - index (default)    
// - export                --             -- display a odt
// - export_multiple       --                -- display a multiple bar odt
///////////////////////////////////////////////////////////////////////////////

$path = "..";
$module = "odt";
$obminclude = getenv("OBM_INCLUDE_VAR");
if ($obminclude == "") $obminclude = "obminclude";
include("$obminclude/global.inc");

if ($action == "") $action = "index";
$odt = get_param_odt();

///////////////////////////////////////////////////////////////////////////////
// Main program
///////////////////////////////////////////////////////////////////////////////

if ($action == "index" || $action == "") {
///////////////////////////////////////////////////////////////////////////////

} elseif ($action == "export") {
///////////////////////////////////////////////////////////////////////////////
  include_once("$obminclude/lib/TBS/tbs_class.php");
  include_once("$obminclude/lib/TBS/tbsooo_class.php");
  $template_full_path = get_document_disk_full_path($odt["template"]);
  
  
  $template_mime_type = get_document_mime_type($odt["template"]);
  export2odt($template_full_path, $template_mime_type, $odt["data"], true);

}



//////////////////////////////////////////////////////////////////////////////
// Create OpenDocument from template and data
// Parameters:
//   - $template_full_path : path to the template
//   - $data : associative array containing data :  variables (TBS 'var') and blocks (TBS 'block')
//   - $display : boolean TRUE if odt created must be displayed, FALSE if not
//   - $save_path : location where odt must be saved (if $display == FALSE)
// Returns
//   - TRUE if successfull
//   - FALSE if it fails (with error ???) 
//////////////////////////////////////////////////////////////////////////////
function export2odt($template_full_path, $template_mime_type, $data, $display, $save_path=""){
  
  $data_vars = $data["data_vars"];
  $data_blocks = $data["data_blocks"];
 
  // instantiate a TBS OOo class
  $OOo = new clsTinyButStrongOOo; 
  
  // setting the object
  if ($OOo->SetZipBinary('zip', true) == false) {
    // erreur zip non prsent
  }
  if ($OOo->SetUnzipBinary('unzip', true) == false) {
    // erreur unzip non prsent
  }
  if ($OOo->SetProcessDir('/tmp/') == false) {
    // erreur /tmp inaccessible
  }

  // create a new openoffice document from the template with an unique id
 
 $OOo->NewDocFromTpl($template_full_path);
 
 // merge data with OOo file content.xml
  $OOo->LoadXmlFromDoc('content.xml');
  
  
  // load Data
  foreach($data_vars as $key => $value){
    $GLOBALS[$key] = $value;
  }

  
  // Merge Data
  foreach ($data_blocks as $key => $value) {
    $OOo->MergeBlock($key, $value);
  }
  $OOo->SaveXmlToDoc();
  
  if ($display){
   
      if ($template_mime_type == "")
        $template_mime_type = $OOo->GetMimetypeDoc();
      if ($template_mime_type == "")
        $template_mime_type = "sxw";
     
      header('Content-type: '.$template_mime_type);
      header('Content-Length: '.filesize($OOo->GetPathnameDoc())); 
      header('Content-Disposition: inline; filename=cv.'.$template_mime_type);
      $OOo->FlushDoc();
      $OOo->RemoveDoc(); 
  }
  else {
    if ($save_path != "") {
      rename($OOo->GetPathnameDoc(), $save_path);
      // affichage des document sauvs ?????
    }
  }
}

///////////////////////////////////////////////////////////////////////////////
// Calculate the real disk path of a document 
// Parameters:
//   - $id   : document id
// Returns:
//   real full disk path
///////////////////////////////////////////////////////////////////////////////
function get_document_disk_full_path($id) {
  global $cdocument_root;

  // The document disk path set in the subdirectory named "last id number"
  // Get the last number from Id
  $rel = substr($id, -1, 1);

  $disk_path = $cdocument_root . "/" . $rel . "/" . $id;
  
  return $disk_path; 
}


/////////////////////////////////////////////////////////////////////////////////
// Returns a document mime type extension
// Parameter :
//   - $id : document id
// Returns :
//    document mime type if ok, null string if undefined
/////////////////////////////////////////////////////////////////////////////////

function get_document_mime_type($id) {
  global $cdg_sql;
  
  $query = "SELECT documentmimetype_extension
            FROM Document
            JOIN DocumentMimeType ON document_mimetype_id = documentmimetype_id
            WHERE document_id = '$id'";
            
  
  display_debug_msg($query, $cdg_sql);
  $obm_q = new DB_OBM;
  $obm_q->query($query);
  
  if ($obm_q->num_rows() == 1){
    $obm_q->next_record();
    return $obm_q->f("documentmimetype_extension");
  }
  else 
    return "";
}

///////////////////////////////////////////////////////////////////////////////
// Stores Odt parameters transmitted in $odt hash
// returns : $odthash with parameters set
///////////////////////////////////////////////////////////////////////////////
function get_param_odt() {
  $odt = array();

  $odt["template"] = $_POST["template"];
  $odt["save_path"] = stripslashes($_POST["save_path"]);
  $odt["data"] = unserialize(urldecode(stripslashes($_POST["data"])));
  $odt["action"] = $_POST["action"];
  
  display_debug_param($odt);

  return $odt;
}
?>
