// 
// Copyright (c) 2004-2006 Jaroslaw Kowalski <jaak@jkowalski.net>
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer. 
// 
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution. 
// 
// * Neither the name of Jaroslaw Kowalski nor the names of its 
//   contributors may be used to endorse or promote products derived from this
//   software without specific prior written permission. 
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.
// 

using System;
using System.Net;

using NUnit.Framework;

namespace NLog.UnitTests.Web
{
	public class NLogWebTestBase
	{
        public string WebTestDir;
        public string NLogTestBaseUrl = "http://localhost/nlogtest/";

        protected void ClearASPNetTrace()
        {
            DownloadUrl("Trace.axd?clear=1");
        }

        protected string GetFirstASPNetTrace()
        {
            return DownloadUrl("Trace.axd?id=0");
        }

        protected string DownloadUrl(string url)
        {
            WebClient wc = new WebClient();
            byte[] data = wc.DownloadData(NLogTestBaseUrl + url);
            return System.Text.Encoding.ASCII.GetString(data);
        }

        protected void AssertContains(string trace, string substr)
        {
            Assert.IsTrue(trace.IndexOf(substr) >= 0, "Trace doesn't contain a '" + substr + "' text.");
            Console.WriteLine("Trace contains '{0}' text.", substr);

        }
    }
}
