using NLog;

namespace Firma.Komponent
{
    public class Klasa {
        private static Logger logger = LogManager.GetLogger("Firma.Komponent.Klasa");
        // private static Logger logger = LogManager.GetCurrentClassLogger();

        static void Main()
        {
            logger.Info("Informacja");
            logger.Warn("Ostrzeenie {0}", "testowe");
            logger.Error("Bd");
            logger.Fatal("Bd krytyczny");

            // w przypadku duej liczby parametrw warto sprawdzi
            // czy komunikat ma szans by gdziekolwiek zapisany
            if (logger.IsDebugEnabled) {
                int x = 3;
                int y = 5;
                
                logger.Debug("x={0}, y={1}", x, y);
            }

            // formatowanie w stylu Console.WriteLine()
            logger.Debug("Wynik {0} {1}", 1 + 2, "zzz");

            // formatowanie z uyciem IFormatProvider
            logger.Debug(CultureInfo.InvariantCulture, 
                    "Bieca data {0}", DateTime.Now);
        }
    }
}
