# -*- coding: utf-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#  Copyright (C) 2002-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003-2005 by Shun-ichi TAHARA <jado@flowernet.gr.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import signal
import sys
import socket

from ninix.home import search_plugins


def send_script(sender, script, if_ghost=None):
    try:
        port = int(os.environ.get("NINIX_SSTP_PORT", "none"))
    except ValueError:
        raise SystemExit, 'NINIX_SSTP_PORT not found.'
    address = ("", port)
    sstp = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sstp.connect(address)
    except socket.error:
        raise SystemExit, 'cannot connect to the SSTP server.'
    message = ''.join(('SEND SSTP/1.4\r\n',
                       'Sender: ', sender, '\r\n',
                       'Script: ', script, '\r\n',
                       'Charset: UTF-8\r\n'))
    if if_ghost is not None:
        message = ''.join((message, 'IfGhost: ', if_ghost, '\r\n'))
    message = ''.join((message, '\r\n'))
    sstp.send(message)
    sstp.recv(1024)
    sstp.close()


class PluginControler:

    def __init__(self, callback):
        self.plugin_pids = []
        self.get_sstp_port = callback['get_sstp_port']

    def get_plugin_list(self):
        plugin_list = []
        self.plugins = search_plugins()
        for i, plugin in enumerate(self.plugins):
            plugin_name = plugin[0]
            menu_items = plugin[3]
            if not menu_items:
                continue
            item = {}
            item['name'] = plugin_name
            item['icon'] = None
            item_list = []
            for j, menu_item in enumerate(menu_items):
                label = menu_item[0]
                value = (i, j)
                item_list.append((label, value))
            item['items'] = item_list
            plugin_list.append(item)
        return plugin_list

    def select_plugin(self, event, item):
        i, j = item
        plugin_name, plugin_dir, startup, menu_items = self.plugins[i]
        label, argv = menu_items[j]
        self.exec_plugin(plugin_dir, argv)

    def terminate_plugin(self, signum, frame):
        for pid in self.plugin_pids[:]:
            try:
                (pid, status) = os.waitpid(pid, os.WNOHANG)
            except OSError:
                ##print 'Process %d not found.' % pid
                self.plugin_pids.remove(pid)
            if pid > 0:
                ##print 'Process %d terminated.' % pid
                self.plugin_pids.remove(pid)
        ##print 'Running subprocesses:', self.plugin_pids

    def exec_plugin(self, plugin_dir, argv):
        ##print 'exec_plugin:', ' '.join(argv)
        if not os.path.exists(argv[0]):
            return
        port = self.get_sstp_port()
        if port is None:
            port = 'none'
        environ = os.environ.copy()
        environ['NINIX_PID'] = str(os.getpid())
        environ['NINIX_SSTP_PORT'] = str(port)
        environ['NINIX_PLUGIN_DIR'] = plugin_dir
        try:
            pid = os.fork()
        except OSError:
            sys.stderr.write('Error: %s failed (ignored)\n' % argv[0])
            return
        if pid == 0:
            os.chdir(plugin_dir)
            try:
                os.execve(argv[0], argv, environ)
            except OSError:
                raise SystemExit, 'Error: %s failed (abort)\n' % argv[0]
        self.plugin_pids.append(pid)

    def start_plugins(self):
        try:
            os.setpgid(0, 0)
        except OSError:
            pass
        plugins = search_plugins()
        for plugin_name, plugin_dir, startup, menu_items in plugins:
            if startup is not None:
                self.exec_plugin(plugin_dir, startup)
