# -*- coding: utf-8 -*-
#
#  communicate.py - ghost-to-ghost communication mechanism
#  Copyright (C) 2002-2010 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#


class Communicate:

    def __init__(self):
        self.__ghosts = {}

    def rebuild_ghostdb(self, sakura, name='', s0=0, s1=10):
        if sakura in self.__ghosts.keys():
            del self.__ghosts[sakura]
        if name is None:
            return
        else:
            self.__ghosts[sakura] = (name, s0, s1)

    def get_otherghostname(self, name):
        otherghostname = []
        for value in self.__ghosts.itervalues():
            if value[0] != name:
                otherghostname.append(chr(1).join(value))
        return otherghostname

    def send_message(self, name, sender, sentence):
        if name == "__SYSTEM_ALL_GHOST__":
            for sakura in self.__ghosts.iterkeys():
                sakura.enqueue_event('OnCommunicate', sender, sentence)
        elif chr(1) in name:
            to = name.split(chr(1))
            for sakura, value in self.__ghosts.iteritems():
                if value[0] in to:
                    sakura.enqueue_event('OnCommunicate', sender, sentence)
                    to.remove(value[0])
                    if not to:
                        break
        else:
            for sakura, value in self.__ghosts.iteritems():
                if value[0] == name:
                    sakura.enqueue_event('OnCommunicate', sender, sentence)
                    break
