/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.UserError;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import nice.tools.code.SpecialArray;

public class Instanceof
extends Procedure2
implements Inlineable {
    private final boolean option;
    public static final Instanceof instance = new Instanceof(false);
    public static final Instanceof optionInstance = new Instanceof(true);

    public static Instanceof create(String param) {
        if ("option".equals(param)) {
            return optionInstance;
        }
        return instance;
    }

    private Instanceof(boolean option) {
        this.option = option;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        Expression value = args[0];
        Expression typeExp = args[1];
        if (typeExp instanceof QuoteExp && ((QuoteExp)typeExp).getValue() instanceof Type) {
            this.compile(value, (Type)((QuoteExp)typeExp).getValue(), comp, exp);
        } else {
            this.compile(value, typeExp, comp);
        }
        target.compileFromStack(comp, Type.boolean_type);
    }

    private void compile(Expression value, Type type, Compilation comp, Expression applyExp) {
        CodeAttr code = comp.getCode();
        if (type == Type.boolean_type) {
            type = Type.boolean_ctype;
        }
        if (type instanceof PrimType) {
            throw new UserError(applyExp, "instanceof cannot be used with primitive types");
        }
        value.compile(comp, Target.pushObject);
        if (type == SpecialArray.wrappedType() && code.topType().isArray()) {
            if (this.option) {
                code.emitPushBoolean(true);
            } else {
                code.emitIfNull();
                code.emitPushBoolean(false);
                code.emitElse();
                code.emitPushBoolean(true);
                code.emitFi();
            }
        } else {
            if (this.option) {
                code.emitDup();
                code.emitIfNull();
                code.emitPop(1);
                code.emitPushBoolean(true);
                code.emitElse();
            }
            code.emitInstanceof(type);
            if (this.option) {
                code.emitFi();
            }
        }
    }

    private void compile(Expression value, Expression type, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (this.option) {
            code.emitDup();
            code.emitIfNull();
            code.emitPop(1);
            code.emitPushBoolean(true);
            code.emitElse();
        }
        type.compile(comp, Target.pushObject);
        value.compile(comp, Target.pushObject);
        code.emitInvoke(ClassType.make("java.lang.Class").getDeclaredMethod("isInstance", 1));
        if (this.option) {
            code.emitFi();
        }
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.boolean_type;
    }

    @Override
    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

