/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.Content;
import bossa.modules.Package;
import bossa.modules.SourceContent;
import bossa.util.Located;
import bossa.util.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import nice.tools.util.System;

class DirectorySourceContent
extends SourceContent {
    private File[] sources;
    private Package pkg;
    private File directory;
    static final String sourceExtension = ".nice";

    static DirectorySourceContent create(Package pkg, File directory) {
        if (!directory.exists()) {
            return null;
        }
        DirectorySourceContent res = new DirectorySourceContent(pkg, directory);
        if (res.isValid()) {
            return res;
        }
        return null;
    }

    static DirectorySourceContent create(Package pkg, URL url) {
        if (!url.getProtocol().equals("file")) {
            User.error("Cannot use " + url + " to get sources for package " + pkg);
        }
        return DirectorySourceContent.create(pkg, new File(url.getFile()));
    }

    DirectorySourceContent(Package pkg, File directory) {
        this.pkg = pkg;
        this.directory = directory;
        this.sources = this.getSources();
        this.lastModification = this.maxLastModification(this.sources);
    }

    private boolean isValid() {
        return this.sources.length > 0;
    }

    @Override
    Content.Unit[] getDefinitions() {
        if (this.sources.length == 0) {
            User.error((Located)this.pkg.name, "Package " + this.pkg.getName() + " has no source file in " + System.prettyPrint(this.directory));
        }
        this.sourcesRead = true;
        Content.Unit[] res = new Content.Unit[this.sources.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Content.Unit(this.read(this.sources[i]), this.sources[i]);
        }
        return res;
    }

    private long maxLastModification(File[] files) {
        long res = 0L;
        for (int i = 0; i < files.length; ++i) {
            long time = files[i].lastModified();
            if (time <= res) continue;
            res = time;
        }
        return res;
    }

    private File[] getSources() {
        File[] res = this.directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getPath().endsWith(DirectorySourceContent.sourceExtension) && f.isFile();
            }
        });
        if (res == null) {
            User.error((Located)this.pkg, "Could not list source files in " + this.getName());
        }
        if (this.pkg.name.toString().equals("nice.lang")) {
            for (int i = 0; i < res.length; ++i) {
                if (!res[i].getName().equals("prelude.nice")) continue;
                File tmp = res[i];
                res[i] = res[0];
                res[0] = tmp;
                break;
            }
        }
        return res;
    }

    private BufferedReader read(File f) {
        try {
            String encoding = this.pkg.compilation.sourceEncoding;
            if (encoding != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
                    return new BufferedReader(isr);
                }
                catch (UnsupportedEncodingException badEncoding) {
                    User.warning("Encoding '" + encoding + "' was rejected while reading " + System.prettyPrint(f));
                }
            }
            return new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            User.error(System.prettyPrint(f) + " of package " + this.pkg.getName() + " could not be found");
            return null;
        }
    }

    @Override
    File getOutputDirectory() {
        return this.directory;
    }

    @Override
    public String getName() {
        return System.prettyPrint(this.directory);
    }

    @Override
    public String toString() {
        return "Source files in: " + this.getName();
    }
}

