/*  VER 014   TAB P   $Id: path.c,v 1.3.2.2 2002/10/31 11:51:39 egil Exp $
 *
 *  process path stuff
 *
 *  copyright 1998 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: path.c,v $
 *  Revision 1.3.2.2  2002/10/31 11:51:39  egil
 *  Fix for bug #133, bang_paths
 *
 *  Revision 1.3.2.1  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.3  1999/03/24 03:53:00  src
 *  Implemented "newsx" as magic exclude pattern
 *
 *  Revision 1.2  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.1  1998/09/11 09:18:38  src
 *  Path consistency and length checks
 *
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

#define PATH_DEBUG 0 /* BUG: find something better... */

/* list of exclusions */
struct ex_s {
    struct ex_s *e_next;
    char *e_name;
} *exclusion;

/*
 *  add name to allowed path
 */
void
add_exclusion(char *path)
{
    struct ex_s *e;

    if (PATH_DEBUG) fprintf(stderr,"Add exclusion: %s\n",path);

    e = malloc_perfect(sizeof(struct ex_s));
    e->e_next = exclusion;
    e->e_name = strdup_perfect(path);
    exclusion = e;
}

/*
 *  get name of exclusion
 *  return the first name on the list
 *  (which, as it happens, is at the bottom of our list)
 */
char *
get_exclusion(void)
{
    struct ex_s *e;
    char *p = "";

    for (e = exclusion; e; e = e->e_next) {
	p = e->e_name;
    }
    return p;
}

/*
 *  look at an item of the path part of an incoming message
 *  see if this matches the path(s) in sys/newsfeeds
 */
int
path_match(char *path)
{
    struct ex_s *e;
    if (!*path) return 0;

    if (PATH_DEBUG) fprintf(stderr,"Path: %s\n",path);

    for (e = exclusion; e; e = e->e_next) {
	if (strcmp(path,e->e_name) == 0) {
	    /* BUG: case is not significant? */
	    if (PATH_DEBUG) fprintf(stderr,"Found path: %s\n",path);
	    return 1;
	}
    }
    return 0;
}

/*
 *  count the number of elements in a path
 *  returns the number of exclamation marks
 */
int
path_bangs(char *path,int len)
{
    char *p = path;
    int bangs = 0;
    while (p < path+len
	&& (p = memchr(p,'!',(path+len) - p))) {
	++bangs;
	++p;
    }
    return bangs;
}

/*
 *  travers the path part of an incoming message, 
 *  and look for an exclusion
 *  return 0 or 1
 *  BUG: Make function to calculate path length too
 */
int
traverse_path(char *path)
{
    char c,*p;
    int ok;

    path = skipsp(path);

    do {
	p = path;
	while ((c=*p) && c!='\n' && c!='\r' && c!='!') ++p;
	*p = '\0';
	ok = path_match(path);
	*p = c;
	if (ok) return 1;
	path = p+1;
    } while (c=='!');
    return 0;
}
