/*  VER 013   TAB P   $Id: dbz.c,v 1.12 1999/03/05 11:20:33 src Exp $
 *
 *  dbz version 6
 *
 *  $Log: dbz.c,v $
 *  Revision 1.12  1999/03/05 11:20:33  src
 *  Delayed decision of dbz v3 vz. 6 to runtime.
 *
 *  Revision 1.11  1999/03/04 17:18:36  src
 *  Split between dbz v3 and v6 improved
 *
 *  Revision 1.10  1999/03/04 16:19:48  src
 *  Renamed dbz v3, and introduced DBZ_READONLY
 *
 *  Revision 1.9  1998/09/21 10:33:32  src
 *  Getting rid of some warnings.
 *
 *  Revision 1.8  1998/09/06 06:38:59  src
 *  Moved HAVE_LIBINN to Makefile.am, where it belongs
 *
 *  Revision 1.7  1998/09/06 06:20:17  src
 *  Build libdbz.a only if not HAVE_LIBINN
 *
 *  Revision 1.6  1998/09/03 02:49:26  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.5  1998/07/12 09:39:19  src
 *  NewsX version 1.0
 */

#include "common.h"

/*
 *  use dbz v6 in read/only mode
 */
#define DBZ_READONLY 1

#if DBZ_READONLY /*EK*/
#  define fopen_W(n,m) NULL
#else
#  define fopen_W(n,m) fopen(n,m)
#endif
#define CloseOnExec(fd, mode)    /* can be safely ignored in this context */

/*
 *  integrate DBZ debug mode
 */
extern int debug_opt;
#define DEBUG(msg) if (debug_opt >= 5) debug_dbz msg

#if HAVE_VPRINTF
#  if USE_VA_ALIST
void 
debug_dbz();
/* debug_dbz(va_alist);*/
#  else
void 
debug_dbz(char *fmt, ...);
#  endif
#else
void 
debug_dbz();
/* debug_dbz(char *fmt, char *arg1,char *arg2,char *arg3,char *arg4); */
#endif

/*
 *  v6
 */
#include "dbz-v6.c"

