/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef PKI_ERR_H
	#define PKI_ERR_H

	#include <NewPKI.h>
	#include <string.h>
	#include <mString.h>


	/*!
	  This enumeration defines the possible error messages header
	*/
	typedef enum en_HEADER_TYPE
	{
		SQL_ERROR_TXT		= 1, //!< A sql error
		PKI_ERROR_TXT		= 2, //!< A pki error
		OCSP_ERROR_TXT		= 3, //!< An ocsp error
		CLIENT_ERROR_TXT	= 4, //!< A client error
		CRYPTO_ERROR_TXT	= 5, //!< An internal crypto error
		PHP_ERROR_TXT		= 6	 //!< A php errorr
	}HEADER_TYPE;
	
	/*!
	  This enumeration defines the possible error messages
	*/
	typedef enum en_ERROR_CODE
	{
		ERROR_DB_INIT					= 2001, //!< Error during db init
		ERROR_DB_CONNECT				= 2002, //!< Error during server connect
		ERROR_DB_SELECT_DB				= 2003, //!< Error during SELECT
		ERROR_DB_SELECT					= 2004, //!< Error during db selection
		ERROR_DB_NUMROWS				= 2005, //!< Error during request num-rows
		ERROR_DB_FETCHROWS				= 2006, //!< Error during request fetch-rows
		ERROR_DB_NUMFIELDS				= 2007, //!< Error during request num-fields
		ERROR_DB_FETCHFIELD				= 2008, //!< Error during request fetch-fields
		ERROR_DB_FIELDNAME				= 2009, //!< Error during request fieldname
		ERROR_UNKNOWN					= 3000, //!< Ulnown error
		ERROR_BAD_PARAM					= 3001, //!< One or more, param(s) is invalid
		ERROR_MALLOC					= 3002, //!< No more memory
		ERROR_GET_DN_SPECIF				= 3003, //!< Invalid DN specs
		ERROR_DN_FIELD_UNPRESENT		= 3004, //!< One field of the DN is unpresent
		ERROR_GENERATE_CSR				= 3006, //!< Could not create a CSR
		ERROR_CONVERT_X509REQ_CSR		= 3007, //!< Error when converting a CSR
		ERROR_CONVERT_CSR_X509REQ		= 3008, //!< Error when converting a CSR
		ERROR_BAD_POLICY_FORMAT			= 3009, //!< Error when a policy format is invalid
		ERROR_CONVERT_KEY_EVP_PKEY		= 3012, //!< Error when converting a private key
		ERROR_GENERATE_BIKEY			= 3014, //!< Error when generating a RSA Key
		ERROR_BAD_CSR_SIGNATURE			= 3015, //!< Error when a CSR signature is invalid
		ERROR_CERTIFY_CSR				= 3017, //!< Error when signing a CSR
		ERROR_CERT_ALREADY_SIGNED_DN	= 3018, //!< Error when a cert with the same DN has already be signed
		ERROR_UNKNOWN_NID				= 3019, //!< Error when an ASN.1 Object is unknown
		ERROR_NO_CERT					= 3021, //!< Error when the specified CRT could not be found
		ERROR_BAD_CERT_STATE			= 3022, //!< Error when trying to revoke a CRT with a state different from CERT_STATE_ACTIF
		ERROR_BAD_EXT_SYNTAX			= 3023, //!< Error when the syntax of an extension is invalid
		ERROR_GEN_CRL					= 3025, //!< Error when generating a CRL
		ERROR_ABORT						= 3026, //!< Aborting because of previous error(s)
		ERROR_BAD_PKI_COMMAND			= 3029, //!< Error when a command is invalid
		ERROR_BAD_UNKNOWN_USER			= 3030, //!< Unknown user or bad password
		ERROR_CONNECT_FAILED			= 3031, //!< Connexion to PKI server failed
		ERROR_BAD_SOCKET				= 3032, //!< Problem with the socket layer
		ERROR_CONNECTION_LOST			= 3033, //!< Problem with the socket layer
		ERROR_NO_CONNECTION				= 3034, //!< Not connected to PKI
		ERROR_BAD_DATAS					= 3037, //!< Error when datas type is improper
		ERROR_NOT_ALLOWED				= 3039, //!< Error when user tries to do an user-right limited action
		ERROR_LOAD_KEY					= 3040, //!< Error when failing to load a private key from a file
		ERROR_BAD_DATAS_FORMAT			= 3044, //!< Error when datas aren't proper 
		ERROR_NO_ENGINE					= 3045, //!< Error when trying a not-loaded engine
		ERROR_MISMATCH_KEYS				= 3046, //!< Error when cert's public and private keys don't match
		ERROR_GEN_P12					= 3047, //!< Error during the p1�generation
		ERROR_INIT_SSL					= 3048, //!< Error when initializing the SSL layer
		ERROR_UNKNOWN_ENTITY			= 3049, //!< The specified entity is unknown
		ERROR_NO_PKI_SSL				= 3050, //!< Error when there is not SSL cert for the PKI Server
		ERROR_INVALID_P12_PWD			= 3055, //!< Erreur le mdp du p12 est invalide
		ERROR_RESOURCE_BUSY				= 3059, //!< Error when a user tries to used a locked resource
		ERROR_NO_MIGRATION_FUNC			= 3060, //!< Error when there is no migration function for the database
		ERROR_BAD_AUTH_LIB				= 3063, //!< Error when an authentification module lib is invalid
		ERROR_ENTITY_EXISTS				= 3065,	//!< Error when creating an entity that already exists
		ERROR_BAD_RESPONSE_SIGNATURE	= 3066,	//!< Error when the signature of a response is invalid
		ERROR_CONVERT_X509CRL_CRL		= 3067, //!< Error when converting a CRL
		ERROR_CONVERT_CRL_X509CRL		= 3068, //!< Error when converting a CRL
		ERROR_NO_REPOSITORY				= 3069,	//!< Error when creating an entity without any reps
		ERROR_ENTITY_NOT_READY			= 3071,	//!< Error when an entity is not ready
		ERROR_UNEXPECTED_CERT			= 3072,	//!< Error when a certificate isn't the one expected
		ERROR_MAIL_SERVER_NOT_SET		= 3073,	//!< Error when a the mail server is not configured
		ERROR_BAD_ENTRY_SIGNATURE		= 3074,	//!< Error when the signature of an entry is invalid
		ERROR_BAD_RA_CA_LINK_REP		= 3075,	//!< Error when a RA or a CA is not connected to at least one Repository
		ERROR_BAD_PLUG_LIB				= 3076,	//!< Error when an plug module lib is invalid
		ERROR_GROUP_ALREADY_EXISTS		= 3077,	//!< Error when a group already exists
		ERROR_GROUP_UNKNOWN				= 3078,	//!< Error when a group is not found
		ERROR_LAST_ENTITY_REPOSITORY	= 3080,	//!< Error when revoking an entity that is the only one known to other entities
		ERROR_NOT_UNIQUE_PROFILE		= 3081,	//!< Error when importing a profile that already exists
		ERROR_DN_FIELD_BAD_MATCH		= 3082, //!< Error when a DN field doesn't respect the match value
		ERROR_BAD_PASSWORD_LEN			= 3083, //!< Error when a password len is to short
		ERROR_BAD_KEY_LEN				= 3084, //!< Error when a key len is to short
		ERROR_CA_NOT_CONFIGURED			= 3085, //!< Error when a CA is trying to be used although it hasn't been configured
		ERROR_LDAP						= 3086, //!< Error connecting to LDAP
		ERROR_LDAP_NOT_CONFIGURED		= 3087, //!< Error when usinq a ldap feature and that LDAP is not configured
		ERROR_GROUP_USED_RA_LDAP_SYNCH	= 3088  //!< Error when deleting a group used by a RA ldap auto synch
	}ERROR_CODE;
	#define ERR_LIB_NEWPKI ERR_LIB_USER+39
	#define NEWPKIerr(f,r)  ERR_PUT_error(ERR_LIB_NEWPKI,(f),(r),__FILE__,__LINE__)
	#define NEWPKIerrGetStr(x) ERR_reason_error_string(ERR_PACK(ERR_LIB_NEWPKI, 0, x))

	/*! \brief This function loads NewPKI's error strings into OpenSSL's error system.
	 */
	void ERR_load_NEWPKI_strings(void);

	/*! \brief This function transforms OpenSSL's stack of errors into a readable string
	 *  \param error [OUT] The error.
	 *  \param OnlyString [IN] Return only the errors string.
	 */
	void ERR_to_mstring(mString & error, bool OnlyString = false);
#endif //PKI_ERR_H
