/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PkiEnroll.h: interface for the PkiEnroll class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(PKIENROLL_H) && defined(_WIN32)
#define PKIENROLL_H

#include <windows.h>
#include <wincrypt.h>
#include <HashTable/HashTable_Dn.h>
#include <ASN1/Asn1Resp.h>
#include <PEM_DER.h>

#include <openssl/x509.h>
#include <mString.h>

class PkiEnroll  
{
public:
	PkiEnroll();
	virtual ~PkiEnroll();

	bool ImportCert(const char *Cert);
	char * CreatePkcs10(HashTable_Dn * Dn, const char * ProviderName, int RsaLen);
	X509_PUBKEY * GeneratePrivateKey(const char * ProviderName, int RsaLen);
	void DestroyContainer();
	DWORD GetEnrollLastError();
	bool import_PKCS12toCSP(const char * provider, const PKI_PKCS12 & p12);

private:
	bool ImportSearchCert(PCCERT_CONTEXT pCert);
	void GenerateContainerName();
	char * PemCsr;
	DWORD LastError;

	BSTR StringToUnicode(char * buffer);
	
	PCCERT_CONTEXT ConvertCertFromX509(X509 * x509);
	bool GetPkcs1KDatas(const RSA * rsakey, BYTE * pbData, DWORD * pbDataLen);
	HCRYPTPROV ConvertKeyFromRSA(const RSA * Key);

	bool ImportCertToMY(PCCERT_CONTEXT CertificateContext, HCRYPTPROV hProv);
	bool ImportCertToCSP(PCCERT_CONTEXT CertificateContext, HCRYPTPROV hProv);

	HCRYPTPROV FindKey(PCCERT_CONTEXT pCert, char * ProviderName);
	bool GetContainerPubKeyInfo(HCRYPTPROV hProv, PCERT_PUBLIC_KEY_INFO PubKeyInfo, DWORD * PubKeyInfoLen);
	bool GenerateCSR(PCERT_NAME_INFO pCertname, DWORD KeyLen);
	mString m_ContainerName;
	mString m_ProviderName;
};

#endif

