/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef ERROR_H
#define ERROR_H

#include <wx/wx.h>
#include <wx/window.h>

#include <stdio.h>
#include "Functions.h"



#ifdef _WIN32
	#define CODE_ERROR GetLastError() 
#else
	#define CODE_ERROR errno
#endif

#define HandleError(m, w) ErrorHandler(m, w, CODE_ERROR, __FILE__, __LINE__)
#define HandleErrorResult(m, w, e) ErrorHandler(m, w, e, __FILE__, __LINE__)

#ifdef _WIN32
	void ErrorHandler(const char * Message, wxWindow * wParent, unsigned long error_code, char * Filename, int Line);
#else
	void ErrorHandler(const char * Message, wxWindow * wParent, int error_code, char * Filename, int Line);
#endif


#endif

