/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgSetLogFilters.cpp: implementation of the DlgSetLogFilters class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgSetLogFilters.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgSetLogFilters, wxDialog)
    EVT_BUTTON(IDC_OK, DlgSetLogFilters::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgSetLogFilters::OnCancel)
	EVT_CHECKBOX(IDC_CHK_TYPE, DlgSetLogFilters::OnChkType)
	EVT_CHECKBOX(IDC_CHK_DATE, DlgSetLogFilters::OnChkDate)
	EVT_CHECKBOX(IDC_CHK_STATUS, DlgSetLogFilters::OnChkStatus)
	EVT_CHECKBOX(IDC_CHK_USER, DlgSetLogFilters::OnChkOpId)
	EVT_CHECKBOX(IDC_CHK_OBJECT, DlgSetLogFilters::OnChkObject)
END_EVENT_TABLE()


DlgSetLogFilters::DlgSetLogFilters(wxWindow * wParent, const mVector<unsigned long> & Types, const AdminReqEnumLogs & Filters):wxDialog(wParent, (wxWindowID)-1, _("Log filters"), wxDefaultPosition)
{
	m_IsOK = false;
	m_Filters = Filters;

	
	m_DateFromCtrl = new wxCalendarCtrl(this, IDC_DATE_FROM);
	if(!m_DateFromCtrl) return;
	m_DateFromCtrl->Enable(FALSE);

	m_DateToCtrl = new wxCalendarCtrl(this, IDC_DATE_TO);
	if(!m_DateToCtrl) return;
	m_DateToCtrl->Enable(FALSE);

	DlgSetLogFilters_SetWindow(this);


	((wxComboBox *)FindWindow(IDC_TYPE))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_STATUS))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_USER))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(FALSE);


	wxCommandEvent event;
	size_t i;
	int selection = 0;
	wxDateTime mdate;

	for(i=0; i < Types.size(); i++)
	{
		((wxComboBox *)FindWindow(IDC_TYPE))->Append(ASN1_logs_get_TypeString((LOG_MESSAGE_TYPE)Types[i]), (void*)Types[i]);
		if(m_Filters.get_type() == Types[i])
		{
			selection = i;
		}
	}
	((wxComboBox *)FindWindow(IDC_TYPE))->SetSelection(selection);
	if(m_Filters.get_type())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->SetValue(true);
		OnChkType(event);
	}


	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_REQUEST), (void*)LOG_STATUS_TYPE_REQUEST);
	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_SUCCESS), (void*)LOG_STATUS_TYPE_SUCCESS);
	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_FAILURE), (void*)LOG_STATUS_TYPE_FAILURE);
	switch(m_Filters.get_status())
	{
		case LOG_STATUS_TYPE_REQUEST:
			selection = 0;
			break;
		case LOG_STATUS_TYPE_SUCCESS:
			selection = 1;
			break;
		case LOG_STATUS_TYPE_FAILURE:
			selection = 2;
			break;
		default:
			selection = 0;
			break;
	}
	((wxComboBox *)FindWindow(IDC_STATUS))->SetSelection(selection);
	if(m_Filters.get_status())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->SetValue(true);
		OnChkStatus(event);
	}

	if(m_Filters.get_user().size())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_USER))->SetValue(true);
		((wxTextCtrl *)FindWindow(IDC_USER))->SetValue(m_Filters.get_user().c_str());
	}

	if(m_Filters.get_object().size())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->SetValue(true);
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->SetValue(m_Filters.get_object().c_str());
	}

	if(m_Filters.get_dateFrom())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_DATE))->SetValue(true);
		mdate.Set((time_t)m_Filters.get_dateFrom());
		m_DateFromCtrl->SetDate(mdate);
		m_DateFromCtrl->Enable(TRUE);
	}

	if(m_Filters.get_dateTo())
	{
		((wxCheckBox *)FindWindow(IDC_CHK_DATE))->SetValue(true);
		mdate.Set((time_t)m_Filters.get_dateTo());
		m_DateToCtrl->SetDate(mdate);
		m_DateToCtrl->Enable(TRUE);
	}
	
	CenterOnScreen();
	ShowModal();
}

DlgSetLogFilters::~DlgSetLogFilters()
{
}


bool DlgSetLogFilters::IsOK()
{
	return m_IsOK;
}

void DlgSetLogFilters::OnOk(wxCommandEvent& event)
{
	wxString value;
	wxComboBox * cmb;
	
	m_Filters.Clear();

	if( ((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->GetValue())
	{
		cmb = (wxComboBox *)FindWindow(IDC_TYPE);
		m_Filters.set_type((unsigned long)cmb->GetClientData(cmb->GetSelection()));
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->GetValue())
	{
		cmb = (wxComboBox *)FindWindow(IDC_STATUS);
		m_Filters.set_status((unsigned long)cmb->GetClientData(cmb->GetSelection()));
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_USER))->GetValue())
	{
		value = ((wxTextCtrl *)FindWindow(IDC_USER))->GetValue();
		if(value.Len())
			m_Filters.set_user(value.GetData());
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->GetValue())
	{
		value = ((wxTextCtrl *)FindWindow(IDC_OBJECT))->GetValue();
		if(value.Len())
			m_Filters.set_object(value.GetData());
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_DATE))->GetValue() )
	{	
		m_Filters.set_dateFrom(m_DateFromCtrl->GetDate().GetTicks());
		m_Filters.set_dateTo(m_DateToCtrl->GetDate().GetTicks());
	}

	m_IsOK = true;
	Close(TRUE);
}
void DlgSetLogFilters::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

void DlgSetLogFilters::OnChkType(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->GetValue() )
	{	
		((wxComboBox *)FindWindow(IDC_TYPE))->Enable(TRUE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_TYPE))->Enable(FALSE);
	}
}
void DlgSetLogFilters::OnChkDate(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_DATE))->GetValue() )
	{	
		m_DateFromCtrl->Enable(TRUE);
		m_DateToCtrl->Enable(TRUE);
	}
	else
	{
		m_DateFromCtrl->Enable(FALSE);
		m_DateToCtrl->Enable(FALSE);
	}
}
void DlgSetLogFilters::OnChkStatus(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->GetValue() )
	{	
		((wxComboBox *)FindWindow(IDC_STATUS))->Enable(TRUE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_STATUS))->Enable(FALSE);
	}
}
void DlgSetLogFilters::OnChkOpId(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_USER))->GetValue() )
	{	
		((wxTextCtrl *)FindWindow(IDC_USER))->Enable(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_USER))->Enable(FALSE);
	}
}
void DlgSetLogFilters::OnChkObject(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->GetValue() )
	{	
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(FALSE);
	}
}

const AdminReqEnumLogs & DlgSetLogFilters::GetFilters()
{
	return m_Filters;
}
