/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgServerAdmin.cpp: implementation of the DlgServerAdmin class.
//
//////////////////////////////////////////////////////////////////////
#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include "DlgAddPkiEntity.h"
#include "DlgAddRepEntity.h"
#include "DlgAddCaEntity.h"
#include "DlgAddEEEntity.h"
#include "DlgAddRaEntity.h"
#include "DlgAddPublicationEntity.h"
#include "DlgAddKeyStoreEntity.h"
#include "DlgManageUsers.h"
#include "DlgCertProperties.h"

#include "DlgServerAdmin.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include "DlgGetNewPassword.h"
#include <sys/stat.h>
#include <fstream>
using namespace std;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgServerAdmin, wxFrame)
	EVT_MENU(IDM_QUIT, DlgGUI::OnQuit)
    EVT_BUTTON(IDC_ADD_PKI, DlgServerAdmin::OnAddPkiEntity)
    EVT_BUTTON(IDC_ADD_CA, DlgServerAdmin::OnAddCaEntity)
    EVT_BUTTON(IDC_ADD_RA, DlgServerAdmin::OnAddRaEntity)
    EVT_BUTTON(IDC_ADD_REP, DlgServerAdmin::OnAddRepositoryEntity)
    EVT_BUTTON(IDC_ADD_KEY, DlgServerAdmin::OnAddKeyStoreEntity)
    EVT_BUTTON(IDC_ADD_EE, DlgServerAdmin::OnAddEEEntity)
    EVT_BUTTON(IDC_ADD_PUB, DlgServerAdmin::OnAddPublicationEntity)
    EVT_MENU(IDM_DELETE_ENTITY, DlgServerAdmin::OnDelEntity)
    EVT_MENU(IDM_LOAD_ENTITY, DlgServerAdmin::OnLoadEntity)
    EVT_MENU(IDM_UNLOAD_ENTITY, DlgServerAdmin::OnUnloadEntity)
    EVT_MENU(IDM_ABOUT, DlgGUI::OnAbout)
    EVT_MENU(IDM_RELOAD, DlgServerAdmin::OnReload)
    EVT_MENU(IDM_SHOW_LOGS, DlgGUI::OnShowLogs)
    EVT_MENU(IDM_RECONNECT, DlgGUI::OnReconnect)
    EVT_MENU(IDM_SHOW_SSL_CERT, DlgGUI::ShowSSL_Certificate)
    EVT_MENU(IDM_SHOW_ENTITY_CERT, DlgGUI::ShowEntity_Certificate)
    EVT_MENU(IDM_MANAGE_USERS, DlgServerAdmin::OnManageUsers)
    EVT_MENU(IDM_SHOW_CERT, DlgServerAdmin::OnShowEntityCert)
	EVT_MENU(IDM_INIT_ENTITY, DlgServerAdmin::OnInitEntity)
	EVT_MENU(IDM_CHANGE_PASSWORD, DlgServerAdmin::OnChangePassword)
END_EVENT_TABLE()


BEGIN_EVENT_TABLE(DlgServerAdminTreeCtrl, wxTreeCtrl)
    EVT_TREE_ITEM_RIGHT_CLICK(IDC_ENTITIES, DlgServerAdminTreeCtrl::OnTreeItemRightClick)
END_EVENT_TABLE()


DlgServerAdmin * m_DlgServerAdminParent;

#ifdef _WIN32

wxBitmap DlgServerAdminTreeCtrlhPic = Backgrounds_GetBitmap(0);

long DlgServerAdminTreeCtrloldProc;
int DlgServerAdminTreeCtrlcenterX;
int DlgServerAdminTreeCtrlcenterY;
bool DlgServerAdminTreeCtrlinProc = false;

LRESULT CALLBACK DlgServerAdminTreeCtrllstvProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT rRect;
	PAINTSTRUCT ps;
	HDC hDC;
	HDC hDCParent;
	HBITMAP bmp;
	HBITMAP bmpOld;
				
	switch (message) 
	{
	case WM_PAINT:
		GetClientRect(hwnd,&rRect);
		
		if(DlgServerAdminTreeCtrlinProc)
		{
			DlgServerAdminTreeCtrlinProc = false;
			InvalidateRect(hwnd, &rRect, TRUE);
			return TRUE;
		}
		DlgServerAdminTreeCtrlinProc = true;
		
		
		CallWindowProcA((WNDPROC)DlgServerAdminTreeCtrloldProc, hwnd, message, wParam, lParam);		
		
		BeginPaint(hwnd, &ps);
		
		hDC=GetDC(hwnd);
		hDCParent=CreateCompatibleDC(hDC);
		bmp = (HBITMAP)DlgServerAdminTreeCtrlhPic.GetHBITMAP();
		
		
		bmpOld = (HBITMAP)SelectObject(hDCParent, bmp);
		
		
		DlgServerAdminTreeCtrlcenterX = ((rRect.right - rRect.left) - DlgServerAdminTreeCtrlhPic.GetWidth()) / 2;
		DlgServerAdminTreeCtrlcenterY = ((rRect.bottom - rRect.top) - DlgServerAdminTreeCtrlhPic.GetHeight())  / 2;
		
		
		BitBlt(hDC,DlgServerAdminTreeCtrlcenterX, DlgServerAdminTreeCtrlcenterY, DlgServerAdminTreeCtrlhPic.GetWidth(),DlgServerAdminTreeCtrlhPic.GetHeight(), hDCParent, 0, 0,SRCAND );
		
		ReleaseDC(hwnd,hDC);
		SelectObject(hDCParent, bmpOld);
		DeleteDC(hDCParent);
		
		EndPaint(hwnd, &ps);
		return TRUE;
		
	default:
		return CallWindowProcA((WNDPROC)DlgServerAdminTreeCtrloldProc, hwnd, message, wParam, lParam);
	}
	return FALSE;
}

#endif

DlgServerAdminTreeCtrl::DlgServerAdminTreeCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos, const wxSize& size, long style):wxTreeCtrl(parent, id, pos, size, style)
{
	#ifdef _WIN32
		DlgServerAdminTreeCtrloldProc = SetWindowLong((HWND)GetHWND(), GWL_WNDPROC, (long)DlgServerAdminTreeCtrllstvProc);
	#endif
}

void DlgServerAdminTreeCtrl::OnTreeItemRightClick(wxTreeEvent& event)
{
	m_DlgServerAdminParent->OnTreeItemRightClick(event);
}



DlgServerAdmin::DlgServerAdmin(wxWindow * wParent, char * EntityName, char * UserName, char * Password, PkiClient * ClientPki):DlgGUI(wParent, ClientPki, EntityName, UserName, Password)
{
	m_DlgServerAdminParent = this;

	wxString mTitle;
	mTitle.sprintf("Server Admin (%s) [%s:%d]", UserName, ClientPki->GetRemoteServer().c_str(), ClientPki->GetRemotePort());
	SetTitle(mTitle);

	SetMenuBar(DlgServerAdmin_GetMenu());
	DlgServerAdmin_SetWindow(this);
	CenterOnScreen();

	m_imageListSmall = new wxImageList(16, 16, TRUE);

	
	m_treeCtrl = (wxTreeCtrl*)FindWindow(IDC_ENTITIES);
	if(!m_treeCtrl) return;

	((wxBitmapButton*)FindWindow(IDC_ADD_KEY))->Enable(FALSE);


	wxIcon ico;
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_PKI_SMALL));
	PkiIconId = m_imageListSmall->Add( ico );
	
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_CA_SMALL));
	CaIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_RA_SMALL));
	RaIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_REP_SMALL));
	RepositoryIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_PUB_SMALL));
	PublicationIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_KEY_SMALL));
	KeyIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_EE_SMALL));
	EEIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_UNKNOWN_SMALL));
	UnknownIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_COMP_SMALL));
	ServerIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_UNLOADED_ENTITY));
	UnloadedIconId = m_imageListSmall->Add( ico );

	m_treeCtrl->SetImageList(m_imageListSmall);
	
	LoadEntitiesList();
}

DlgServerAdmin::~DlgServerAdmin()
{
	if(m_treeCtrl) m_treeCtrl->DeleteAllItems();
	if(m_imageListSmall) delete m_imageListSmall;
}


bool DlgServerAdmin::LoadEntitiesList()
{
	size_t i;
	wxTreeItemId theRootItem;
	wxTreeItemId theItem;
	DlgServerAdminItemData * datas;
	int IconId;

	entities.clear();

	m_treeCtrl->DeleteAllItems();
	theRootItem = m_treeCtrl->AddRoot("Local server", ServerIconId, ServerIconId);

	m_DlgMsg->wShow(_("Loading Configuration..."));

	if(!m_ClientPki->EnumEntities(entities))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	m_DlgMsg->wHide();

	for(i=0; i < entities.size(); i++)
	{
		if(!entities[i].get_loaded())
		{
			IconId = UnloadedIconId;
		}
		else
		{
			switch(entities[i].get_type())
			{
				case ENTITY_TYPE_PKI:
					IconId = PkiIconId;
					break;
				case ENTITY_TYPE_RA:
					IconId = RaIconId;
					break;
				case ENTITY_TYPE_CA:
					IconId = CaIconId;
					break;
				case ENTITY_TYPE_REPOSITORY:
					IconId = RepositoryIconId;
					break;
				case ENTITY_TYPE_PUBLICATION:
					IconId = PublicationIconId;
					break;
				case ENTITY_TYPE_KEY_STORE:
					IconId = KeyIconId;
					break;
				case ENTITY_TYPE_EE:
					IconId = EEIconId;
					break;
				default:
					IconId = UnknownIconId;
					break;
			}
		}

		theItem = m_treeCtrl->AppendItem(theRootItem, entities[i].get_name().c_str(), IconId, IconId);

		datas = new DlgServerAdminItemData(entities[i]);
		if(datas)
		{
			m_treeCtrl->SetItemData(theItem, datas);
		}
		
		if(theItem) m_treeCtrl->EnsureVisible(theItem);
	}
	return true;
}

void DlgServerAdmin::OnAddPkiEntity(wxCommandEvent& event)
{
	DlgAddPkiEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddCaEntity(wxCommandEvent& event)
{
	DlgAddCaEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddEEEntity(wxCommandEvent& event)
{
	DlgAddEEEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddRaEntity(wxCommandEvent& event)
{
	DlgAddRaEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddRepositoryEntity(wxCommandEvent& event)
{
	DlgAddRepEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddPublicationEntity(wxCommandEvent& event)
{
	DlgAddPublicationEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnAddKeyStoreEntity(wxCommandEvent& event)
{
	DlgAddKeyStoreEntity dlg(this, m_ClientPki);
	if(dlg.IsOK())
		LoadEntitiesList();
}


void DlgServerAdmin::OnReload(wxCommandEvent& event)
{
	LoadEntitiesList();
}


void DlgServerAdmin::OnDelEntity(wxCommandEvent& event)
{
	wxTreeItemId hEntity;
	wxString EntityName;

	hEntity = m_treeCtrl->GetSelection();
	if(!hEntity.IsOk()) return;

	EntityName = m_treeCtrl->GetItemText(hEntity);
	if(!EntityName.Len()) return;

	if(DisplayMessage(this, _("Are you sure to want to delete the Entity ?"), wxYES_NO) == wxNO) return;

	m_DlgMsg->wShow(_("Deleting Entity..."));
	if(!m_ClientPki->DeleteEntity(EntityName.GetData()))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
	LoadEntitiesList();
}

void DlgServerAdmin::OnLoadEntity(wxCommandEvent& event)
{
	wxTreeItemId hEntity;
	wxString EntityName;

	hEntity = m_treeCtrl->GetSelection();
	if(!hEntity.IsOk()) return;

	EntityName = m_treeCtrl->GetItemText(hEntity);
	if(!EntityName.Len()) return;

	if(DisplayMessage(this, _("Are you sure to want to load the Entity ?"), wxYES_NO) == wxNO) return;

	m_DlgMsg->wShow(_("Loading Entity..."));
	if(!m_ClientPki->LoadEntity(EntityName.GetData()))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
	LoadEntitiesList();
}

void DlgServerAdmin::OnUnloadEntity(wxCommandEvent& event)
{
	wxTreeItemId hEntity;
	wxString EntityName;

	hEntity = m_treeCtrl->GetSelection();
	if(!hEntity.IsOk()) return;

	EntityName = m_treeCtrl->GetItemText(hEntity);
	if(!EntityName.Len()) return;

	if(DisplayMessage(this, _("Are you sure to want to unload the Entity ?"), wxYES_NO) == wxNO) return;

	m_DlgMsg->wShow(_("Unloading Entity..."));
	if(!m_ClientPki->UnloadEntity(EntityName.GetData()))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
	LoadEntitiesList();
}

void DlgServerAdmin::OnTreeItemRightClick(wxTreeEvent& event)
{
	DlgServerAdminItemData * entity;
	wxTreeItemId hEntity;
	wxMenu * menu;

	wxMenuBar * menu_b = DlgServerAdmin_GetPopup();
	if(!menu_b) return;

	m_treeCtrl->SelectItem(event.GetItem());

	if(m_treeCtrl->GetParent(event.GetItem()))
	{
		menu = menu_b->GetMenu(0);
		if(menu)
		{
			hEntity = m_treeCtrl->GetSelection();
			if(!hEntity.IsOk())
			{
				delete menu_b;
				return;
			}

			entity = (DlgServerAdminItemData *)m_treeCtrl->GetItemData(hEntity);
			if(!entity)
			{
				delete menu_b;
				return;
			}

			if(entity->GetInfo().get_loaded())
			{
				menu->Enable(IDM_LOAD_ENTITY, false);
				menu->Enable(IDM_UNLOAD_ENTITY, true);
				if(entity->GetInfo().get_certificate())
				{
					menu->Enable(IDM_INIT_ENTITY, false);
					menu->Enable(IDM_SHOW_CERT, true);
				}
				else
				{
					menu->Enable(IDM_INIT_ENTITY, true);
					menu->Enable(IDM_SHOW_CERT, false);
				}
			}
			else
			{
				menu->Enable(IDM_LOAD_ENTITY, true);
				menu->Enable(IDM_UNLOAD_ENTITY, false);
				menu->Enable(IDM_INIT_ENTITY, false);
				menu->Enable(IDM_SHOW_CERT, false);
			}
			m_treeCtrl->PopupMenu(menu, event.GetPoint().x, event.GetPoint().y);
		}
	}
	delete menu_b;
}

void DlgServerAdmin::OnManageUsers(wxCommandEvent &event)
{
	DlgManageUsers Dlg(this, m_ClientPki);
}

void DlgServerAdmin::OnShowEntityCert(wxCommandEvent &event)
{
	DlgServerAdminItemData * entity;
	wxTreeItemId hEntity;
	PKI_CERT entityCert;

	hEntity = m_treeCtrl->GetSelection();
	if(!hEntity.IsOk()) return;

	entity = (DlgServerAdminItemData *)m_treeCtrl->GetItemData(hEntity);
	if(!entity) return;

	DlgCertProperties Dlg(this, entity->GetInfo().get_certificate());
}

void DlgServerAdmin::OnInitEntity(wxCommandEvent &event)
{
	EntitySignatureResp resp;
	EntityInitReq req;
	wxTreeItemId hEntity;
	wxString EntityName;
	
	hEntity = m_treeCtrl->GetSelection();
	if(!hEntity.IsOk()) return;
	
	EntityName = m_treeCtrl->GetItemText(hEntity);
	if(!EntityName.Len()) return;

	
	wxFileDialog dialog(this, _("Open Entity signing response"), "", "", _("Entity signing response File (*.esp)|*.esp"), wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	
	ifstream rd(dialog.GetPath());
	if(!rd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	struct stat  info;
	char * buffer;
	stat(dialog.GetPath(), &info);

	if(!(buffer = (char*)malloc(info.st_size+1)))
	{
		HandleErrorResult(NULL, this, errno);
		return;
	}
	rd.read(buffer, info.st_size);
	buffer[info.st_size] = 0;

	if(!resp.from_PEM(buffer))
	{
		HandleErrorResult(NULL, this, 0);
		free(buffer);
		return;
	}
	free(buffer);

	req.set_name(EntityName.GetData());
	req.set_signResp(resp);

	m_DlgMsg->wShow(_("Initializing Entity..."));
	if(!m_ClientPki->InitEntity(req))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
	LoadEntitiesList();
}

bool DlgServerAdmin::ReloadConf()
{
	return LoadEntitiesList();
}

void DlgServerAdmin::OnChangePassword(wxCommandEvent &event)
{
	ChangePasswd NewPwd;
	
	DlgGetNewPassword Dlg(this);
	if(!Dlg.IsOK()) return;

	
	NewPwd.get_password() = Dlg.GetPassword();
	if(!NewPwd.get_password().size()) return;

	m_DlgMsg->wShow(_("Updating Password..."));
	if(!m_ClientPki->ChangePassword(NewPwd))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
}
