/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgPublishCSR.cpp: implementation of the DlgPublishCSR class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgPublishCSR.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgPublishCSR, wxDialog)
    EVT_BUTTON(IDC_SHOW, DlgPublishCSR::OnShow)
    EVT_BUTTON(IDC_OK, DlgPublishCSR::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgPublishCSR::OnCancel)
    EVT_BUTTON(IDC_FILE_IMPORT, DlgPublishCSR::OnImport)
END_EVENT_TABLE()


DlgPublishCSR::DlgPublishCSR(wxWindow * wParent, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Publish CSR"), wxDefaultPosition)
{
	m_ClientPki = ClientPki;
	m_IsOk=false;

	DlgPublishCSR_SetWindow(this);
	CenterOnScreen();

	ShowModal();
}

DlgPublishCSR::~DlgPublishCSR()
{
}

void DlgPublishCSR::OnCancel(wxCommandEvent& event)
{
	m_IsOk=true;
	Close(TRUE);
}



void DlgPublishCSR::OnOk(wxCommandEvent& event)
{
	wxString Csr;
	DlgMessage Msg(this);
	PKI_P7B resultCerts;
	long days;
	const char * cn;

	if(DisplayMessage(this, _("Are you sure, you want to sign this request ?"), wxYES_NO) == wxNO) return;

	Csr = ((wxTextCtrl *)FindWindow(IDC_CSR))->GetValue();
	if(!Csr.Len()) return;

	if(!mCsr.SetCSR((char*)Csr.GetData()))
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}

	Csr = ((wxTextCtrl *)FindWindow(IDC_DAYS))->GetValue();
	if(!Csr.Len()) return;
	Csr.ToLong(&days);

	Csr = ((wxTextCtrl *)FindWindow(IDC_UID))->GetValue();

	Msg.wShow(_("Publishing Certificate Request..."));

	if(!m_ClientPki->SignCSR(mCsr, days, Csr.GetData(), resultCerts))
	{
		Msg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Msg.wHide();

	if( (days = mCsr.GetRequestDN().SeekEntryName("commonName", HASHTABLE_NOT_FOUND)) != HASHTABLE_NOT_FOUND)
	{
		cn = mCsr.GetRequestDN().Get(days);
	}
	else
	{
		cn = NULL;
	}
	if(!cn)
		cn="";

	Csr = cn;
	Csr.Replace("\\", "_");
	Csr.Replace("/", "_");
	Csr.Replace("*", "_");
	Csr.Replace("?", "_");
	Csr.Replace(":", "_");
	Csr.Replace("\"", "_");
	Csr.Replace("<", "_");
	Csr.Replace(">", "_");
	Csr.Replace("|", "_");

	wxFileDialog dialog(this, _("Save PKCS#7"), "", Csr, _("PKCS#7 File (*.p7b)|*.p7b"), wxSAVE | wxOVERWRITE_PROMPT);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}	
	BIO * wd = BIO_new_file(dialog.GetPath(), "wb");
	if(!wd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	
	if(i2d_PKCS7_bio(wd, resultCerts.GetPKCS7()) <= 0)
	{
		HandleErrorResult(NULL, this, 0);
		BIO_free_all(wd);
		return;
	}
	BIO_free_all(wd);
	
	m_IsOk=true;
	Close(TRUE);
}

void DlgPublishCSR::OnShow(wxCommandEvent& event)
{
	DlgCsrProperties Dlg(this, mCsr);
}

bool DlgPublishCSR::IsOk()
{
	return m_IsOk;
}

void DlgPublishCSR::OnImport(wxCommandEvent &event)
{
	wxString Csr;
	wxFileDialog dialog(this, _("Open CSR"), "", "", _("CSR File (*.csr)|*.csr"), wxOPEN);

	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	((wxTextCtrl *)FindWindow(IDC_CSR))->LoadFile(dialog.GetPath());

	Csr = ((wxTextCtrl *)FindWindow(IDC_CSR))->GetValue();
	if(!Csr.Len()) return;


	if(!mCsr.SetCSR((char*)Csr.GetData()))
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
}
