/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManagePkiUsers.cpp: implementation of the DlgManagePkiUsers class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgAddPkiUser.h"
#include "DlgCertProperties.h"

#include "DlgManagePkiUsers.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManagePkiUsers, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManagePkiUsers::OnOk)
    EVT_BUTTON(IDC_ADD_USER, DlgManagePkiUsers::OnAddUser)
    EVT_BUTTON(IDC_REVOKE_USER, DlgManagePkiUsers::OnRevokeUser)
    EVT_BUTTON(IDC_USER_PROPERTIES, DlgManagePkiUsers::OnUserProperties)
END_EVENT_TABLE()

DlgManagePkiUsers::DlgManagePkiUsers(wxWindow * wParent, PkiClient * ClientPKI):wxDialog(wParent, (wxWindowID)-1, _("Manage PKI Users"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION | wxMAXIMIZE_BOX | wxRESIZE_BORDER)
{
	m_ClientPKI = ClientPKI;
	DlgManagePkiUsers_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LISTCTRL));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Users_GetBitmap(IDB_USER_SMALL));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("User DN"), wxLIST_ALIGN_DEFAULT, 300);
	m_listCtrl->InsertColumn(1, _("Valid from"), wxLIST_ALIGN_DEFAULT, 100);
	m_listCtrl->InsertColumn(2, _("Valid to"), wxLIST_ALIGN_DEFAULT, 100);

	if(!ReloadList())
	{
		Close(TRUE);
		return;
	}


	CenterOnScreen();
	ShowModal();
}

DlgManagePkiUsers::~DlgManagePkiUsers()
{
	m_listCtrl->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

bool DlgManagePkiUsers::ReloadList()
{
	size_t i;
	DlgMessage dlg(this);

	m_users.clear();

	dlg.wShow(_("Loading User(s) List..."));
	if(!m_ClientPKI->EnumUsersCert(m_users))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return false;
	}
	dlg.wHide();

	m_listCtrl->DeleteAllItems();

	for(i=0; i<m_users.size(); i++)
	{
		m_listCtrl->InsertItem(i, m_users[i].get_userCert().GetStringName(), 0);
		m_listCtrl->SetItemData(i, (long)i);

		m_listCtrl->SetItem(i, 1, FormatTime(m_users[i].get_userCert().GetStartDate()) );
		m_listCtrl->SetItem(i, 2, FormatTime(m_users[i].get_userCert().GetEndDate()) );
	}
	return true;
}

void DlgManagePkiUsers::OnAddUser(wxCommandEvent& event)
{
	DlgAddPkiUser Dlg(this, m_ClientPKI);
	if(Dlg.IsOk())
		ReloadList();
}

void DlgManagePkiUsers::OnRevokeUser(wxCommandEvent& event)
{
	int SelectedItem;
	size_t Index;

	if(DisplayMessage(this, _("Are you sure, you want to revoke this certificate ?"), wxYES_NO) == wxNO) return;
	
	DlgMessage dlg(this);

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	Index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	
	dlg.wShow(_("Revoking Certificate..."));
	if(!m_ClientPKI->RevokeUserCert(m_users[Index].get_userCert().GetSerial()))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlg.wHide();

	ReloadList();
}

void DlgManagePkiUsers::OnOk(wxCommandEvent& event)
{
	Close(TRUE);
}

void DlgManagePkiUsers::OnUserProperties(wxCommandEvent &event)
{
	int SelectedItem;
	size_t Index;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	Index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	DlgCertProperties(this, m_users[Index].get_userCert());
}
