#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

static njb_t njbs[ NJB_MAX_DEVICES ];
static GSList *tracks = NULL;
static guint len = 0;

static void scanning( NomadJukebox *jukebox, guint jobid,
		gpointer data )
{
	printf( "Beginning track scan.....\n" );
}

static void track_add( NomadJukebox *jukebox, guint jobid,
		guint total_tracks, NomadTrack *track,
		gpointer data )
{
	guint id;

	id = nomad_track_get_id( track );
	tracks = g_slist_prepend( tracks, GUINT_TO_POINTER( id ) );
}

static void scanned( NomadJukebox *jukebox, guint jobid,
		guint total, gpointer data )
{
	gboolean *done;
	
	done = (gboolean *)data;
	printf( "\n\nScanned: %i Tracks\n", total );
	*done = TRUE;
}

static void unlock_track( guint id, NomadJukebox *jukebox )
{
	NomadTrack *track;
	NomadTrack *ntrack;

	track = nomad_jukebox_request_track( jukebox, id );
	if( track ) {
		ntrack = nomad_track_copy_and_protect( track, FALSE );
		if( ntrack ) {
			printf( "Unlocking: %u\n", id );
			nomad_jukebox_set_metadata( jukebox, ntrack );
			nomad_track_free( ntrack );
		}
		nomad_track_free( track );
	} else {
		printf( "Failed to find track: %u\n", id );
	}
}

static void changed( guint jobid, const NomadTrack *orig,
		const NomadTrack *track, gpointer data )
{
	gboolean *done;
	guint id;
	
	id = nomad_track_get_id( track );

	done = (gboolean *)data;
	len --;
	*done =( len <= 0 );

	printf( "Unlocked: %u\tRemaining: %i\n", id, len );
}

static void error( guint jobid, const gchar *message, gpointer data )
{
	gboolean *done;

	done = (gboolean *)data;
	len --;
	*done =( len <= 0 );

	printf( "Error unlock track: %s\n", message );
}

int main()
{
	guint number;
	gboolean done;
	NomadJukebox *jukebox;

	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	jukebox = nomad_jukebox_new( &njbs[ 0 ] );
	if( ! nomad_jukebox_acquire( jukebox ) ) {
		fprintf( stderr, "failed to acquire jukebox" );
		return 0;
	}

	done = FALSE;
	g_signal_connect( G_OBJECT( jukebox ), "scanning_tracks",
			G_CALLBACK( scanning ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "track_add",
			G_CALLBACK( track_add ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "scanned_tracks",
			G_CALLBACK( scanned ), &done );
	g_signal_connect( G_OBJECT( jukebox ), "track_changed",
			G_CALLBACK( changed ), &done );
	g_signal_connect( G_OBJECT( jukebox ), "error",
			G_CALLBACK( error ), &done );
	
	nomad_jukebox_build_tracklist( jukebox );
	while( ! done ) {
		usleep( 100 );
	}
	if( tracks ) {
		done = FALSE;
		printf( "Unlocking...\n" );
		len = g_slist_length( tracks );
		g_slist_foreach( tracks, (GFunc)unlock_track, jukebox );
		g_slist_free( tracks );
	}
	while( ! done ) {
		usleep( 100 );
	}

	nomad_jukebox_release( jukebox );

	return 0;
}
